/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.scijava.ui.swing.script.Bookmark;

public class BookmarkDialog
extends JDialog
implements ActionListener {
    JList<Bookmark> list;
    JButton okay;
    JButton cancel;

    public BookmarkDialog(Frame owner, final Vector<Bookmark> bookmarks) {
        super(owner, "Bookmarks", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.list = new JList<Bookmark>(bookmarks);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = BookmarkDialog.this.list.locationToIndex(e.getPoint());
                    ((Bookmark)bookmarks.get(index)).setCaret();
                    BookmarkDialog.this.dispose();
                }
            }
        });
        this.getContentPane().add(this.list);
        this.okay = new JButton("OK");
        this.okay.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(this.okay);
        panel.add(this.cancel);
        this.getContentPane().add(panel);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BookmarkDialog.this.jumpToSelectedBookmark();
                    BookmarkDialog.this.dispose();
                } else if (e.getKeyCode() == 27) {
                    BookmarkDialog.this.dispose();
                }
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.list.addKeyListener(keyListener);
        this.okay.addKeyListener(keyListener);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public boolean jumpToSelectedBookmark() {
        Bookmark bookmark = this.list.getSelectedValue();
        if (bookmark == null) {
            return false;
        }
        bookmark.setCaret();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancel) {
            this.dispose();
        } else if (source == this.okay) {
            this.jumpToSelectedBookmark();
            this.dispose();
        }
    }
}

