/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.imglib2.realtransform.InvertibleRealTransform;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.SpacesTransforms;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.CTNode;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.CoordinateSystems;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformPath;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.StackedCoordinateTransform;

public class TransformGraph {
    public final Gson gson;
    private final ArrayList<CoordinateTransform<?>> transforms;
    private final CoordinateSystems spaces;
    private final HashMap<CoordinateSystem, CTNode> spacesToNodes;

    public TransformGraph() {
        this.spaces = new CoordinateSystems();
        this.transforms = new ArrayList();
        this.spacesToNodes = new HashMap();
        this.gson = SpacesTransforms.buildGson();
    }

    public TransformGraph(List<CoordinateTransform<?>> transforms, CoordinateSystems spaces) {
        this.gson = SpacesTransforms.buildGson();
        this.spaces = spaces;
        this.transforms = new ArrayList();
        this.inferSpacesFromAxes();
        this.spacesToNodes = new HashMap();
        for (CoordinateTransform<?> t : transforms) {
            this.addTransform(t);
        }
        this.updateTransforms();
    }

    public TransformGraph(List<CoordinateTransform<?>> transforms, List<CoordinateSystem> spacesIn) {
        this(transforms, new CoordinateSystems(spacesIn));
    }

    protected void inferSpacesFromAxes() {
        for (CoordinateTransform<?> ct : this.transforms) {
            if (!(ct instanceof AbstractCoordinateTransform) || ((AbstractCoordinateTransform)ct).inferSpacesFromAxes(this.spaces)) continue;
            System.out.println("uh oh - removing " + ct);
            this.transforms.remove(ct);
        }
    }

    public List<CoordinateTransform<?>> getTransforms() {
        return this.transforms;
    }

    public CoordinateSystems getCoordinateSystems() {
        return this.spaces;
    }

    public Optional<CoordinateTransform<?>> getTransform(String name) {
        return this.transforms.stream().filter(x -> x.getName().equals(name)).findAny();
    }

    public HashMap<CoordinateSystem, CTNode> getSpaceNodes() {
        return this.spacesToNodes;
    }

    public CoordinateSystem getInput(CoordinateTransform<?> t) {
        return this.spaces.getSpace(t.getInput());
    }

    public CoordinateSystem getOutput(CoordinateTransform<?> t) {
        return this.spaces.getSpace(t.getOutput());
    }

    public void addTransform(CoordinateTransform<?> t) {
        this.addTransform(t, true);
    }

    private void addTransform(CoordinateTransform<?> t, boolean addInverse) {
        if (this.transforms.stream().anyMatch(x -> {
            if (x != null && x.getName() != null) {
                return x.getName().equals(t.getName());
            }
            return false;
        })) {
            return;
        }
        if (this.spaces.hasSpace(t.getInput()) && this.spaces.hasSpace(t.getOutput())) {
            CoordinateSystem src = this.getInput(t);
            if (this.spacesToNodes.containsKey(src)) {
                this.spacesToNodes.get(src).edges().add(t);
            } else {
                CTNode node = new CTNode(src);
                node.edges().add(t);
                this.spacesToNodes.put(src, node);
            }
            this.transforms.add(t);
        } else {
            this.transforms.add(t);
        }
        if (addInverse && t instanceof InvertibleCoordinateTransform) {
            this.addTransform(new InverseCT((InvertibleCoordinateTransform)t), false);
        }
    }

    public void updateTransforms() {
        this.getCoordinateSystems().updateTransforms(this.getTransforms().stream());
    }

    public void addSpace(CoordinateSystem space) {
        if (this.spaces.add(space)) {
            this.spacesToNodes.put(space, new CTNode(space));
        }
    }

    public void add(TransformGraph g) {
        g.spaces.coordinateSystems().forEach(s -> this.addSpace((CoordinateSystem)s));
        g.transforms.stream().forEach(t -> this.addTransform((CoordinateTransform<?>)t));
    }

    public List<CoordinateTransform<?>> subTransforms(CoordinateSystem input, CoordinateSystem output) {
        return this.getTransforms().stream().filter(t -> this.spaces.inputIsSubspace((CoordinateTransform<?>)t, input) && this.spaces.outputIsSubspace((CoordinateTransform<?>)t, output)).collect(Collectors.toList());
    }

    public CoordinateTransform<?> buildTransformFromAxes(CoordinateSystem from, CoordinateSystem to) {
        ArrayList tList = new ArrayList();
        HashSet<String> outAxes = new HashSet<String>();
        HashSet<String> inAxes = new HashSet<String>();
        String[] outputAxes = to.getAxisNames();
        for (CoordinateTransform<?> t : this.getTransforms()) {
            if (!this.spaces.outputMatchesAny(t, outputAxes)) continue;
            if (AxisUtils.containsAny(outAxes, this.spaces.getOutputAxes(t))) {
                System.err.println("warning: multiple transforms define same output axes");
                return null;
            }
            if (AxisUtils.containsAny(inAxes, this.spaces.getInputAxes(t))) {
                System.err.println("warning: multiple transforms define same output axes");
                return null;
            }
            tList.add(t);
            outAxes.addAll(Arrays.asList(t.getOutputAxes()));
            inAxes.addAll(Arrays.asList(t.getInputAxes()));
        }
        StackedCoordinateTransform totalTransform = new StackedCoordinateTransform(from.getName() + " > " + to.getName(), from.getName(), to.getName(), tList);
        totalTransform.setSpaces(this.spaces);
        totalTransform.buildTransform();
        return totalTransform;
    }

    public CoordinateTransform<?> buildImpliedTransform(CoordinateSystem from, CoordinateSystem to) {
        ArrayList tList = new ArrayList();
        for (String outLabels : to.getAxisNames()) {
            this.getTransforms().stream().filter(t -> this.spaces.outputHasAxis((CoordinateTransform<?>)t, outLabels)).findAny().ifPresent(t -> tList.add((CoordinateTransform<?>)t));
        }
        StackedCoordinateTransform totalTransform = new StackedCoordinateTransform("name", from.getName(), to.getName(), tList);
        return totalTransform;
    }

    public Optional<TransformPath> pathFromAxes(String from, String[] toAxes) {
        return this.path(this.spaces.spaceFrom(from), this.spaces.spaceFrom(toAxes));
    }

    public Optional<TransformPath> pathFromAxes(String[] fromAxes, String to) {
        return this.path(this.spaces.spaceFrom(fromAxes), this.spaces.spaceFrom(to));
    }

    public Optional<TransformPath> pathFromAxes(String[] fromAxes, String[] toAxes) {
        return this.path(this.spaces.spaceFrom(fromAxes), this.spaces.spaceFrom(toAxes));
    }

    public Optional<TransformPath> path(String from, String to) {
        return this.path(this.spaces.spaceFrom(from), this.spaces.spaceFrom(to));
    }

    public Optional<TransformPath> path(CoordinateSystem from, CoordinateSystem to) {
        if (from == null || to == null) {
            return Optional.empty();
        }
        if (from.equals(to)) {
            return Optional.of(new TransformPath(new IdentityCoordinateTransform("identity", from.getName(), to.getName())));
        }
        return this.allPaths(from).stream().filter(p -> this.spaces.getSpace(p.getEnd()).equals(to)).findAny();
    }

    public List<TransformPath> paths(CoordinateSystem from, CoordinateSystem to) {
        return this.allPaths(from).stream().filter(p -> p.getEnd().equals(to)).collect(Collectors.toList());
    }

    public List<TransformPath> allPaths(String from) {
        return this.allPaths(this.spaces.getSpace(from));
    }

    public List<TransformPath> allPaths(CoordinateSystem from) {
        ArrayList<TransformPath> paths = new ArrayList<TransformPath>();
        this.allPathsHelper(paths, from, null);
        return paths;
    }

    private void allPathsHelper(List<TransformPath> paths, CoordinateSystem start, TransformPath pathToStart) {
        CTNode node = this.spacesToNodes.get(start);
        List<CoordinateTransform<?>> edges = null;
        if (node != null) {
            edges = this.spacesToNodes.get(start).edges();
        }
        if (edges == null || edges.size() == 0) {
            return;
        }
        for (CoordinateTransform<?> t : edges) {
            CoordinateSystem end = this.getOutput(t);
            if (pathToStart != null && pathToStart.hasSpace(end)) continue;
            TransformPath p = pathToStart == null ? new TransformPath(t) : new TransformPath(pathToStart, t);
            paths.add(p);
            this.allPathsHelper(paths, end, p);
        }
    }

    private static class InverseCT
    extends AbstractCoordinateTransform<InvertibleRealTransform>
    implements InvertibleCoordinateTransform<InvertibleRealTransform> {
        InvertibleCoordinateTransform<?> ict;

        public InverseCT(InvertibleCoordinateTransform<?> ict) {
            super("invWrap", "inv-" + ict.getName(), ict.getOutput(), ict.getInput());
            this.ict = ict;
        }

        public InverseCT(String type, String name, String inputSpace, String outputSpace, InvertibleCoordinateTransform<?> ict) {
            super(type, name, inputSpace, outputSpace);
            this.ict = ict;
        }

        @Override
        public InvertibleRealTransform getTransform() {
            return this.ict.getInvertibleTransform();
        }

        @Override
        public InvertibleRealTransform getTransform(N5Reader n5) {
            return this.ict.getInvertibleTransform(n5);
        }

        @Override
        public InvertibleRealTransform getInvertibleTransform() {
            return (InvertibleRealTransform)this.ict.getTransform();
        }

        @Override
        public InvertibleRealTransform getInvertibleTransform(N5Reader n5) {
            return (InvertibleRealTransform)this.ict.getTransform(n5);
        }
    }
}

