/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.ops;

import net.imagej.ui.swing.ops.OpTreeTableNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class OpTreeTableModel
extends AbstractTreeTableModel {
    private static final String[] DEV_COLUMNS = new String[]{"Op signature", "Code snippet", "Defined in class"};
    private static final String[] USER_COLUMNS = new String[]{"Available Ops"};
    private final boolean simple;

    public OpTreeTableModel(boolean simple) {
        this.root = new OpTreeTableNode(new String[0]);
        this.simple = simple;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public int getColumnCount() {
        return this.isSimple() ? 1 : 3;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.isSimple() ? USER_COLUMNS[0] : DEV_COLUMNS[0];
            }
            case 1: {
                return DEV_COLUMNS[1];
            }
            case 2: {
                return DEV_COLUMNS[2];
            }
        }
        return "Unknown";
    }

    public Object getValueAt(Object node, int column) {
        OpTreeTableNode treenode = (OpTreeTableNode)node;
        switch (column) {
            case 0: {
                return treenode.getName();
            }
            case 1: {
                return treenode.getCodeCall();
            }
            case 2: {
                return treenode.getReferenceClass();
            }
        }
        return "Unknown";
    }

    public Object getChild(Object node, int index) {
        OpTreeTableNode treenode = (OpTreeTableNode)node;
        return treenode.getChildren().get(index);
    }

    public int getChildCount(Object parent) {
        OpTreeTableNode treenode = (OpTreeTableNode)parent;
        return treenode.getChildren().size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        OpTreeTableNode treenode = (OpTreeTableNode)parent;
        for (int i = 0; i > treenode.getChildren().size(); ++i) {
            if (treenode.getChildren().get(i) != child) continue;
            return i;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        OpTreeTableNode treenode = (OpTreeTableNode)node;
        return treenode.getChildren().size() <= 0;
    }

    public OpTreeTableNode getRoot() {
        return (OpTreeTableNode)super.getRoot();
    }
}

