/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.export.ProgressWriter;
import bdv.gui.BigWarpViewerOptions;
import bdv.gui.TransformSelectorDialog;
import bdv.gui.sourceList.BigWarpSourceListPanel;
import bdv.gui.sourceList.BigWarpSourceTableModel;
import bdv.ij.util.ProgressWriterIJ;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpInit;
import bigwarp.transforms.NgffTransformations;
import bigwarp.transforms.metadata.N5TransformMetadata;
import bigwarp.transforms.metadata.N5TransformMetadataParser;
import bigwarp.transforms.metadata.N5TransformTreeCellRenderer;
import com.formdev.flatlaf.util.UIScale;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.frame.Recorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import mpicbg.spim.data.SpimDataException;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.NativeType;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.bdv.N5ViewerTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ij.N5Importer;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.ui.DatasetSelectorDialog;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.jdom2.JDOMException;

public class BigWarpInitDialog
extends JFrame {
    private static final long serialVersionUID = -2914972130819029899L;
    public static String listSeparator = ",";
    private boolean imageJOpen;
    private DatasetService datasetService;
    private String initialPath;
    private JTextField projectPathTxt;
    private JTextField containerPathText;
    private JTextField transformPathText;
    private JLabel messageLabel;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel listPanel;
    private JTable sourceTable;
    private JButton browseProjectButton;
    private JButton browseBtn;
    private JButton addN5Button;
    private JButton addN5TransformButton;
    private JButton browseTransformButton;
    private BigWarpSourceTableModel sourceTableModel;
    private JComboBox<String> imagePlusDropdown;
    private JButton addImageButton;
    private JButton addPathButton;
    private JButton addTransformButton;
    private DatasetSelectorDialog selectionDialog;
    private TransformSelectorDialog transformSelectionDialog;
    private String lastOpenedContainer = "";
    private String lastBrowsePath = null;
    private ExecutorService exec;
    private Consumer<BigWarpSourceTableModel> okayCallback;
    private Consumer<BigWarpSourceTableModel> cancelCallback;
    private Consumer<String> imagePathUpdateCallback;
    private Consumer<String> transformPathUpdateCallback;
    private Consumer<String> projectPathUpdateCallback;
    public static final int DEFAULT_OUTER_PAD = 8;
    public static final int DEFAULT_BUTTON_PAD = 3;
    public static final int DEFAULT_MID_PAD = 5;
    private static final String commandName = "BigWarp";
    private static final String projectKey = "project";
    private static final String imagesKey = "images";
    private static final String movingKey = "moving";
    private static final String transformsKey = "transforms";
    public static final String ImageJPrefix = "imagej://";
    private String projectLandmarkPath;
    private String imageList;
    private String movingList;
    private String transformList;
    private boolean initialRecorderState;

    public BigWarpInitDialog(String title) {
        this(title, (DatasetService)null);
    }

    public BigWarpInitDialog(String title, DatasetService datasetService) {
        super(title);
        this.datasetService = datasetService;
        this.initialPath = "";
        this.imageJOpen = IJ.getInstance() != null;
        this.buildN5SelectionDialog();
        Container content = this.getContentPane();
        content.add(this.createContent());
        this.pack();
        this.initializeImagePlusSources();
        this.cancelCallback = x -> {
            this.setVisible(false);
            this.dispose();
            Recorder.record = this.initialRecorderState;
        };
        this.okayCallback = x -> {
            this.macroRecord();
            this.runBigWarp();
            Recorder.record = this.initialRecorderState;
            this.setVisible(false);
        };
        this.imagePathUpdateCallback = p -> this.addPath();
        this.transformPathUpdateCallback = p -> this.addTransform();
    }

    public static void main(String[] args) {
        ImageJ ij = new ImageJ();
        new BigWarpInitDialog("bigwarp test");
        BigWarpInitDialog.createAndShow();
    }

    public void setInitialRecorderState(boolean initialRecorderState) {
        this.initialRecorderState = initialRecorderState;
    }

    public static <T extends NativeType<T>> BigWarp<?> runBigWarp(String projectLandmarkPath, String[] images, String[] moving, String[] transforms) {
        String projectLandmarkPathTrim = projectLandmarkPath == null ? null : projectLandmarkPath.trim();
        BigWarpData data = BigWarpInit.initData();
        boolean haveProjectLandmarkArg = projectLandmarkPathTrim != null && !projectLandmarkPathTrim.isEmpty();
        boolean haveProject = haveProjectLandmarkArg && projectLandmarkPathTrim.trim().endsWith(".json");
        boolean haveLandmarks = haveProjectLandmarkArg && projectLandmarkPathTrim.trim().endsWith(".csv");
        int nThreads = IJ.getInstance() != null ? Prefs.getThreads() : 1;
        BigWarpViewerOptions bwOpts = (BigWarpViewerOptions)BigWarpViewerOptions.options().numRenderingThreads(nThreads);
        if (!haveProject) {
            int id = 0;
            int N = images.length;
            for (int i = 0; i < N; ++i) {
                try {
                    Supplier<String> transformSupplier;
                    LinkedHashMap infos = BigWarpInit.createSources(data, images[i], id, moving[i].equals("true"));
                    RealTransform transform = null;
                    if (transforms != null && transforms.length > i) {
                        String transformUrl = transforms[i];
                        if (transformUrl != null && !transformUrl.isEmpty()) {
                            transform = NgffTransformations.open(transformUrl);
                            transformSupplier = () -> transformUrl;
                        } else {
                            transformSupplier = null;
                        }
                    } else {
                        transformSupplier = null;
                    }
                    BigWarpInit.add(data, infos, transform, transformSupplier);
                    id += infos.size();
                    continue;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SpimDataException e) {
                    e.printStackTrace();
                }
            }
        }
        BigWarp bw = null;
        try {
            bwOpts.is2D(BigWarp.detectNumDims(data.sources) == 2);
            data.applyTransformations();
            bw = new BigWarp(data, bwOpts, (ProgressWriter)new ProgressWriterIJ());
            if (haveProject) {
                bw.loadSettings(projectLandmarkPathTrim, true);
            } else if (haveLandmarks) {
                bw.loadLandmarks(projectLandmarkPathTrim);
            }
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return bw;
    }

    public <T extends NativeType<T>> void runBigWarp() {
        boolean haveLandmarks;
        if (Recorder.record) {
            Recorder.setCommand((String)commandName);
            this.macroRecord();
            Recorder.saveCommand();
        }
        BigWarpData data = BigWarpInit.initData();
        this.projectLandmarkPath = this.projectLandmarkPath == null ? this.projectPathTxt.getText().trim() : this.projectLandmarkPath;
        boolean haveProjectLandmarkArg = this.projectLandmarkPath != null && !this.projectLandmarkPath.isEmpty();
        boolean haveProject = haveProjectLandmarkArg && this.projectLandmarkPath.endsWith(".json");
        boolean bl = haveLandmarks = haveProjectLandmarkArg && this.projectLandmarkPath.endsWith(".csv");
        if (!haveProject) {
            int id = 0;
            int N = this.sourceTable.getRowCount();
            for (int i = 0; i < N; ++i) {
                LinkedHashMap infos;
                BigWarpSourceTableModel.SourceRow tableRow = this.sourceTableModel.get(i);
                if (tableRow.type.equals((Object)BigWarpSourceTableModel.SourceType.IMAGEPLUS)) {
                    ImagePlus imp = WindowManager.getImage((String)tableRow.srcName.replaceAll("^imagej://", ""));
                    infos = BigWarpInit.createSources(data, imp, id, 0, tableRow.moving);
                    BigWarpInit.add(data, infos, tableRow.getTransform(), tableRow.getTransformUri());
                    id += infos.size();
                    continue;
                }
                if (tableRow.type.equals((Object)BigWarpSourceTableModel.SourceType.DATASET)) {
                    Dataset dataset = this.datasetService.getDatasets().stream().filter(x -> x.getSource().equals(tableRow.srcName)).findFirst().get();
                    infos = BigWarpInit.createSources(data, dataset, id, tableRow.moving);
                    BigWarpInit.add(data, infos, tableRow.getTransform(), tableRow.getTransformUri());
                    id += infos.size();
                    continue;
                }
                try {
                    LinkedHashMap infos2 = BigWarpInit.createSources(data, tableRow.srcName, id, tableRow.moving);
                    BigWarpInit.add(data, infos2, tableRow.getTransform(), tableRow.getTransformUri());
                    id += infos2.size();
                    continue;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SpimDataException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            data.applyTransformations();
            BigWarp bw = new BigWarp(data, (ProgressWriter)new ProgressWriterIJ());
            if (haveProject) {
                bw.loadSettings(this.projectLandmarkPath, true);
            } else if (haveLandmarks) {
                bw.loadLandmarks(this.projectLandmarkPath);
            }
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public JPanel createContent() {
        int OUTER_PAD = 8;
        int BUTTON_PAD = 3;
        int MID_PAD = 5;
        int frameSizeX = UIScale.scale((int)600);
        JPanel panel = new JPanel(false);
        panel.setPreferredSize(new Dimension(frameSizeX, UIScale.scale((int)335)));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints ctxt = new GridBagConstraints();
        ctxt.gridx = 0;
        ctxt.gridy = 0;
        ctxt.gridwidth = 1;
        ctxt.gridheight = 1;
        ctxt.weightx = 0.0;
        ctxt.weighty = 0.0;
        ctxt.anchor = 22;
        ctxt.fill = 0;
        ctxt.insets = new Insets(8, 8, 5, 3);
        panel.add((Component)new JLabel("BigWarp project or landmarks:"), ctxt);
        GridBagConstraints gbcBar = new GridBagConstraints();
        gbcBar.gridx = 1;
        gbcBar.gridy = 0;
        gbcBar.gridwidth = 6;
        gbcBar.gridheight = 1;
        gbcBar.weightx = 1.0;
        gbcBar.weighty = 0.0;
        gbcBar.fill = 2;
        gbcBar.insets = new Insets(8, 8, 5, 3);
        this.projectPathTxt = new JTextField();
        this.projectPathTxt.setPreferredSize(new Dimension(frameSizeX / 3, this.projectPathTxt.getPreferredSize().height));
        panel.add((Component)this.projectPathTxt, gbcBar);
        gbcBar.gridwidth = 4;
        GridBagConstraints cProjBrowse = new GridBagConstraints();
        cProjBrowse.gridx = 7;
        cProjBrowse.gridy = 0;
        cProjBrowse.gridwidth = 1;
        cProjBrowse.weightx = 0.0;
        cProjBrowse.fill = 2;
        cProjBrowse.insets = new Insets(8, 3, 5, 3);
        this.browseProjectButton = new JButton("Browse");
        this.browseProjectButton.addActionListener(e -> this.browseProjectDialog());
        panel.add((Component)this.browseProjectButton, cProjBrowse);
        ctxt.gridy = 1;
        panel.add((Component)new JLabel("Add open image:"), ctxt);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 3, 5, 3);
        gbc.anchor = 22;
        this.imagePlusDropdown = new JComboBox<String>(new String[]{"<none>"});
        panel.add(this.imagePlusDropdown, gbc);
        this.updateImagePlusDropdown();
        GridBagConstraints cadd = new GridBagConstraints();
        cadd.gridx = 5;
        cadd.gridy = 1;
        cadd.gridwidth = 1;
        cadd.weightx = 0.0;
        cadd.fill = 0;
        cadd.anchor = 21;
        cadd.insets = new Insets(8, 3, 5, 3);
        cadd.gridy = 1;
        this.addImageButton = new JButton("+");
        panel.add((Component)this.addImageButton, cadd);
        this.addImageButton.addActionListener(e -> this.addImage());
        ctxt.gridy = 2;
        JLabel addFileLabel = new JLabel("Add image file/folder:");
        panel.add((Component)addFileLabel, ctxt);
        gbcBar.gridy = 2;
        this.containerPathText = new JTextField();
        this.containerPathText.setText(this.initialPath);
        this.containerPathText.setPreferredSize(new Dimension(frameSizeX / 3, this.containerPathText.getPreferredSize().height));
        panel.add((Component)this.containerPathText, gbcBar);
        cadd.gridy = 2;
        this.addPathButton = new JButton("+");
        this.addPathButton.addActionListener(e -> this.addPath());
        panel.add((Component)this.addPathButton, cadd);
        GridBagConstraints cbrowse = new GridBagConstraints();
        cbrowse.gridx = 6;
        cbrowse.gridy = 2;
        cbrowse.gridwidth = 1;
        cbrowse.weightx = 0.0;
        cbrowse.fill = 2;
        cbrowse.insets = new Insets(8, 3, 5, 3);
        this.browseBtn = new JButton("Browse");
        this.browseBtn.addActionListener(e -> this.browseImageDialog());
        panel.add((Component)this.browseBtn, cbrowse);
        GridBagConstraints cn5 = new GridBagConstraints();
        cn5.gridx = 7;
        cn5.gridy = 2;
        cn5.gridwidth = 1;
        cn5.weightx = 0.0;
        cn5.fill = 2;
        cn5.insets = new Insets(8, 3, 5, 3);
        this.addN5Button = new JButton("H5/N5/Zarr");
        panel.add((Component)this.addN5Button, cn5);
        this.addN5Button.addActionListener(e -> {
            this.selectionDialog = new DatasetSelectorDialog((Function)new N5Importer.N5ViewerReaderFun(), (Function)new N5Importer.N5BasePathFun(), this.lastOpenedContainer, BigWarpInit.GROUP_PARSERS, BigWarpInit.PARSERS);
            this.selectionDialog.setLoaderExecutor(this.exec);
            this.selectionDialog.setTreeRenderer((TreeCellRenderer)new N5ViewerTreeCellRenderer(false));
            this.selectionDialog.setContainerPathUpdateCallback(x -> {
                if (x != null) {
                    this.lastOpenedContainer = x;
                }
            });
            this.selectionDialog.setVirtualOption(false);
            this.selectionDialog.setCropOption(false);
            this.selectionDialog.run(this::n5DialogCallback);
        });
        ctxt.gridy = 3;
        panel.add((Component)new JLabel("Add transformation:"), ctxt);
        this.transformPathText = new JTextField();
        this.transformPathText.setPreferredSize(new Dimension(frameSizeX / 3, this.transformPathText.getPreferredSize().height));
        gbcBar.gridy = 3;
        panel.add((Component)this.transformPathText, gbcBar);
        this.addTransformButton = new JButton("+");
        this.addTransformButton.addActionListener(e -> this.addTransform());
        cadd.gridy = 3;
        panel.add((Component)this.addTransformButton, cadd);
        this.browseTransformButton = new JButton("Browse");
        this.browseTransformButton.addActionListener(e -> this.browseTransformDialog());
        cbrowse.gridy = 3;
        panel.add((Component)this.browseTransformButton, cbrowse);
        cn5.gridy = 3;
        this.addN5TransformButton = new JButton("H5/N5/Zarr");
        panel.add((Component)this.addN5TransformButton, cn5);
        this.addN5TransformButton.addActionListener(e -> {
            if (this.sourceTable.getSelectedRow() < 0) {
                IJ.showMessage((String)"Please highlight the row you would like to transform.");
            } else {
                N5MetadataParser[] tformParsers = new N5MetadataParser[]{new N5TransformMetadataParser()};
                this.transformSelectionDialog = new TransformSelectorDialog((Function<String, N5Reader>)new N5Importer.N5ViewerReaderFun(), (Function<String, String>)new N5Importer.N5BasePathFun(), this.lastOpenedContainer, tformParsers);
                this.transformSelectionDialog.setLoaderExecutor(this.exec);
                this.transformSelectionDialog.setTreeRenderer((TreeCellRenderer)((Object)new N5TransformTreeCellRenderer(true)));
                this.transformSelectionDialog.setContainerPathUpdateCallback(x -> {
                    if (x != null) {
                        this.lastOpenedContainer = x;
                    }
                });
                this.transformSelectionDialog.run(selection -> {
                    String n5RootPath = this.transformSelectionDialog.getN5RootPath();
                    int i = this.sourceTable.getSelectedRow();
                    if (selection.metadata.size() > 0) {
                        String path = ((N5Metadata)selection.metadata.get(0)).getPath();
                        int idx = path.lastIndexOf("/");
                        String group = idx > 0 ? path.substring(0, idx) : "";
                        String attributePath = idx > 0 ? path.substring(idx + 1) : path;
                        this.sourceTableModel.setTransform(i, n5RootPath + "?" + group + "#" + attributePath);
                    }
                    this.repaint();
                });
                JTree tree = this.transformSelectionDialog.getJTree();
                for (TreeSelectionListener l : tree.getTreeSelectionListeners()) {
                    tree.removeTreeSelectionListener(l);
                }
                tree.addTreeSelectionListener(new N5TransformTreeSelectionListener(tree.getSelectionModel()));
            }
        });
        GridBagConstraints clist = new GridBagConstraints();
        clist.gridx = 0;
        clist.gridy = 4;
        clist.gridwidth = 8;
        clist.gridheight = 3;
        clist.weightx = 1.0;
        clist.weighty = 1.0;
        clist.fill = 1;
        clist.insets = new Insets(8, 3, 5, 3);
        this.sourceTableModel = new BigWarpSourceTableModel(t -> {
            String val = NgffTransformations.detectTransforms(t);
            if (val != null) {
                this.showMessage(1000, "Found transformation");
            }
            return val;
        });
        BigWarpSourceListPanel srcListPanel = new BigWarpSourceListPanel(this.sourceTableModel);
        this.sourceTableModel.setContainer(srcListPanel);
        this.sourceTable = srcListPanel.getJTable();
        this.sourceTable.putClientProperty("terminateEditOnFocusLost", true);
        panel.add((Component)srcListPanel, clist);
        GridBagConstraints cbot = new GridBagConstraints();
        cbot.gridx = 0;
        cbot.gridy = 7;
        cbot.gridwidth = 4;
        cbot.gridheight = 1;
        cbot.weightx = 1.0;
        cbot.weighty = 0.0;
        cbot.fill = 2;
        cbot.anchor = 17;
        cbot.insets = new Insets(8, 8, 8, 8);
        this.messageLabel = new JLabel("");
        this.messageLabel.setVisible(true);
        panel.add((Component)this.messageLabel, cbot);
        this.okBtn = new JButton("OK");
        this.okBtn.addActionListener(e -> this.okayCallback.accept(this.sourceTableModel));
        cbot.gridx = 6;
        cbot.weightx = 0.0;
        cbot.gridwidth = 1;
        cbot.ipadx = 40;
        cbot.fill = 2;
        cbot.anchor = 13;
        cbot.insets = new Insets(5, 8, 8, 3);
        panel.add((Component)this.okBtn, cbot);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(e -> this.cancelCallback.accept(this.sourceTableModel));
        cbot.gridx = 7;
        cbot.ipadx = 0;
        cbot.gridwidth = 1;
        cbot.fill = 2;
        cbot.anchor = 13;
        cbot.insets = new Insets(5, 3, 8, 8);
        panel.add((Component)this.cancelBtn, cbot);
        return panel;
    }

    public void buildN5SelectionDialog() {
        this.exec = Executors.newFixedThreadPool(Prefs.getThreads());
    }

    public void n5DialogCallback(DataSelection selection) {
        String n5RootPath = this.selectionDialog.getN5RootPath();
        for (N5Metadata m : selection.metadata) {
            this.sourceTableModel.add(n5RootPath + "?" + m.getPath());
        }
        this.repaint();
    }

    public void n5DialogTransformCallback(DataSelection selection) {
        String n5RootPath = this.transformSelectionDialog.getN5RootPath();
        int i = this.sourceTable.getSelectedRow();
        if (selection.metadata.size() > 0) {
            this.sourceTableModel.setTransform(i, n5RootPath + "?" + ((N5Metadata)selection.metadata.get(0)).getPath());
        }
        this.repaint();
    }

    protected void addImage() {
        if (!this.imageJOpen && this.datasetService == null) {
            return;
        }
        String title = (String)this.imagePlusDropdown.getSelectedItem();
        if (!this.addDataset(title, false)) {
            this.addImagePlus(title);
        }
        this.repaint();
    }

    protected boolean addDataset(String datasetSource, boolean moving) {
        if (this.datasetService.getDatasets().stream().filter(x -> x.getSource().equals(datasetSource)).count() > 0L) {
            this.sourceTableModel.addDataset(datasetSource, moving);
            return true;
        }
        return false;
    }

    protected void addImagePlus(String title) {
        this.addImagePlus(title, true);
    }

    protected void addImagePlus(String title, boolean moving) {
        if (IJ.getInstance() == null) {
            return;
        }
        ImagePlus imp = WindowManager.getImage((String)title);
        if (!title.isEmpty() && imp != null) {
            this.sourceTableModel.addImagePlus(ImageJPrefix + title, moving);
            this.repaint();
        }
    }

    protected void addPath() {
        String path = this.containerPathText.getText();
        if (!path.isEmpty()) {
            this.sourceTableModel.add(path);
            this.repaint();
        }
    }

    protected void addTransform() {
        String path = this.transformPathText.getText();
        int row = this.sourceTable.getSelectedRow();
        if (!path.isEmpty() && row >= 0) {
            this.sourceTableModel.setTransform(row, path);
            this.repaint();
        }
    }

    protected void updateImagePlusDropdown() {
        int[] ids;
        if (!this.imageJOpen && this.datasetService == null) {
            return;
        }
        ArrayList<String> titleList = new ArrayList<String>();
        if (this.datasetService != null) {
            for (Dataset d : this.datasetService.getDatasets()) {
                titleList.add(d.getSource());
            }
        }
        int N = (ids = WindowManager.getIDList()) == null ? 0 : ids.length;
        for (int i = 0; i < N; ++i) {
            String t = WindowManager.getImage((int)ids[i]).getTitle();
            if (titleList.contains(t)) continue;
            titleList.add(t);
        }
        String[] titles = new String[titleList.size()];
        for (int i = 0; i < titleList.size(); ++i) {
            titles[i] = (String)titleList.get(i);
        }
        this.imagePlusDropdown.setModel(new DefaultComboBoxModel<String>(titles));
    }

    public void initializeImagePlusSources() {
        int N = this.imagePlusDropdown.getModel().getSize();
        if (N > 0) {
            if (this.datasetService == null) {
                this.addImagePlus(this.imagePlusDropdown.getItemAt(0), true);
            } else {
                this.addDataset(this.imagePlusDropdown.getItemAt(0), true);
            }
        }
        if (N > 1) {
            if (this.datasetService == null) {
                this.addImagePlus(this.imagePlusDropdown.getItemAt(1), false);
            } else {
                this.addDataset(this.imagePlusDropdown.getItemAt(1), false);
            }
        }
    }

    public static BigWarpInitDialog createAndShow() {
        return BigWarpInitDialog.createAndShow(null);
    }

    public static BigWarpInitDialog createAndShow(DatasetService datasets) {
        BigWarpInitDialog frame = new BigWarpInitDialog(commandName, datasets);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    private String browseDialogGeneral(int mode, FileFilter filefilter) {
        String path;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(mode);
        if (filefilter == null) {
            fileChooser.setFileFilter(filefilter);
        }
        if (this.lastBrowsePath != null && !this.lastBrowsePath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.lastBrowsePath));
        } else if (this.initialPath != null && !this.initialPath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.initialPath));
        } else if (this.imageJOpen) {
            File f = null;
            String currDir = IJ.getDirectory((String)"current");
            String homeDir = IJ.getDirectory((String)"home");
            if (currDir != null) {
                f = new File(currDir);
            } else if (homeDir != null) {
                f = new File(homeDir);
            }
            fileChooser.setCurrentDirectory(f);
        }
        int ret = fileChooser.showOpenDialog(this);
        if (ret != 0) {
            return null;
        }
        this.lastBrowsePath = path = fileChooser.getSelectedFile().getAbsolutePath();
        return path;
    }

    public void setImagePathUpdateCallback(Consumer<String> callback) {
        this.imagePathUpdateCallback = callback;
    }

    public void setTransformPathUpdateCallback(Consumer<String> callback) {
        this.transformPathUpdateCallback = callback;
    }

    public void setProjectPathUpdateCallback(Consumer<String> callback) {
        this.projectPathUpdateCallback = callback;
    }

    private String browseProjectDialog() {
        String s = this.browseDialogGeneral(0, new FileNameExtensionFilter("JSON file", "json"));
        this.projectPathTxt.setText(s);
        if (this.projectPathUpdateCallback != null) {
            this.projectPathUpdateCallback.accept(s);
        }
        return s;
    }

    private String browseImageDialog() {
        String s = this.browseDialogGeneral(2, null);
        this.containerPathText.setText(s);
        if (this.imagePathUpdateCallback != null) {
            this.imagePathUpdateCallback.accept(s);
        }
        return s;
    }

    private String browseTransformDialog() {
        String s = this.browseDialogGeneral(2, null);
        this.transformPathText.setText(s);
        if (this.transformPathUpdateCallback != null) {
            this.transformPathUpdateCallback.accept(s);
        }
        return s;
    }

    public void setParameters(String projectLandmarkPath, String images, String moving, String transforms) {
        this.projectLandmarkPath = projectLandmarkPath;
        this.imageList = images;
        this.movingList = moving;
        this.transformList = transforms;
    }

    public void updateTableFromParameters() {
        for (int i = 0; i < this.sourceTableModel.getRowCount(); ++i) {
            this.sourceTableModel.remove(i);
        }
        String[] imageParams = this.imageList.split(listSeparator, -1);
        String[] movingParams = this.movingList.split(listSeparator, -1);
        String[] transformParams = this.transformList.split(listSeparator, -1);
        int N = imageParams.length;
        if (movingParams.length != N || transformParams.length != N) {
            System.err.println("Parameter arrays must have identical lengths");
            return;
        }
        for (int i = 0; i < N; ++i) {
            this.sourceTableModel.add(imageParams[i], movingParams[i].trim().equals("true"));
            this.sourceTableModel.setTransform(i, transformParams[i]);
        }
    }

    public void updateParametersFromTable() {
        StringBuffer imageList = new StringBuffer();
        StringBuffer movingList = new StringBuffer();
        StringBuffer transformList = new StringBuffer();
        int N = this.sourceTable.getRowCount();
        for (int i = 0; i < N; ++i) {
            imageList.append(this.sourceTableModel.get((int)i).srcName);
            movingList.append(this.sourceTableModel.get((int)i).moving);
            transformList.append(this.sourceTableModel.get((int)i).transformUrl);
            if (i >= N - 1) continue;
            imageList.append(listSeparator);
            movingList.append(listSeparator);
            transformList.append(listSeparator);
        }
        this.imageList = imageList.toString();
        this.movingList = movingList.toString();
        this.transformList = transformList.toString();
    }

    public String macroRecord() {
        if (!Recorder.record) {
            return "";
        }
        this.updateParametersFromTable();
        Recorder.resetCommandOptions();
        Recorder.recordOption((String)imagesKey, (String)this.imageList.toString());
        Recorder.recordOption((String)movingKey, (String)this.movingList.toString());
        if (this.transformList != null) {
            Recorder.recordOption((String)transformsKey, (String)this.transformList.toString());
        }
        return Recorder.getCommandOptions();
    }

    protected void showMessage(int timeMillis, String message) {
        this.messageLabel.setText(message);
        Timer timer = new Timer(timeMillis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BigWarpInitDialog.this.messageLabel.setText("");
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static void runMacro(String args) {
        String project = Macro.getValue((String)args, (String)projectKey, (String)"");
        String[] images = Macro.getValue((String)args, (String)imagesKey, (String)"").split(",", -1);
        String[] moving = Macro.getValue((String)args, (String)movingKey, (String)"").split(",", -1);
        String[] transforms = Macro.getValue((String)args, (String)transformsKey, (String)"").split(",", -1);
        if (!project.isEmpty()) {
            BigWarpInitDialog.runBigWarp(project, null, null, null);
        } else {
            if (images.length == 0 || moving.length == 0) {
                System.err.println("images and moving keys required");
                return;
            }
            BigWarpInitDialog.runBigWarp(null, images, moving, transforms);
        }
    }

    public static class N5TransformTreeSelectionListener
    implements TreeSelectionListener {
        private TreeSelectionModel selectionModel;

        public N5TransformTreeSelectionListener(TreeSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public void valueChanged(TreeSelectionEvent sel) {
            int i = 0;
            for (TreePath path : sel.getPaths()) {
                N5SwingTreeNode node;
                if (!sel.isAddedPath(i)) continue;
                Object last = path.getLastPathComponent();
                if (last instanceof N5SwingTreeNode && ((node = (N5SwingTreeNode)last).getMetadata() == null || !(node.getMetadata() instanceof N5TransformMetadata))) {
                    this.selectionModel.removeSelectionPath(path);
                }
                ++i;
            }
        }
    }
}

