/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.ui.convertersetupeditor.MaskBoundsRangePanel;
import bigwarp.BigWarp;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.source.PlateauSphericalMaskSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaskOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -8614381106547838575L;
    private static final String FALLOFF_HELP_TEXT = "Controls the shape of the mask in the transition region.";
    private static final String AUTO_ESTIMATE_HELP_TEXT = "If selected, the mask location and size will be dynamically updated as you add landmarks.";
    private static final String SHOW_MASK_OVERLAY_HELP_TEXT = "Toggles the visibility of the mask overlay";
    private static final String INTERPOLATION_HELP_TEXT = "Controls whether a mask is applied to the transformation and how the transformation changes in the mask transition region.\nIf your transformation has lots of rotation, try selecting \"ROTATION\" or \"SIMILARITY\".";
    public static final String[] maskTypes = new String[]{"NONE", "LINEAR", "ROTATION", "SIMILARITY"};
    private final BigWarp<?> bw;
    private final JCheckBox autoEstimateMaskButton;
    private final JCheckBox showMaskOverlayButton;
    private final JLabel falloffTypeLabel;
    private final JComboBox<PlateauSphericalMaskRealRandomAccessible.FalloffShape> falloffTypeDropdown;
    private final JLabel maskTypeLabel;
    private final JComboBox<String> maskTypeDropdown;
    private final MaskBoundsRangePanel maskRangePanel;
    private ActionListener falloffListener;

    public MaskOptionsPanel(BigWarp<?> bw) {
        super(new GridBagLayout());
        this.bw = bw;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Mask options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.autoEstimateMaskButton = new JCheckBox("Auto-estimate mask", true);
        this.autoEstimateMaskButton.setToolTipText(AUTO_ESTIMATE_HELP_TEXT);
        this.showMaskOverlayButton = new JCheckBox("Show mask overlay", true);
        this.showMaskOverlayButton.setToolTipText(SHOW_MASK_OVERLAY_HELP_TEXT);
        this.falloffTypeLabel = new JLabel("Mask falloff");
        this.falloffTypeLabel.setToolTipText(FALLOFF_HELP_TEXT);
        this.falloffTypeDropdown = new JComboBox<PlateauSphericalMaskRealRandomAccessible.FalloffShape>(PlateauSphericalMaskRealRandomAccessible.FalloffShape.values());
        this.falloffTypeDropdown.setToolTipText(FALLOFF_HELP_TEXT);
        this.maskTypeLabel = new JLabel("Mask interpolation");
        this.maskTypeLabel.setToolTipText(INTERPOLATION_HELP_TEXT);
        this.maskTypeDropdown = new JComboBox<String>(maskTypes);
        this.maskTypeDropdown.setToolTipText(INTERPOLATION_HELP_TEXT);
        this.maskRangePanel = new MaskBoundsRangePanel(bw);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.maskTypeLabel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 21;
        this.add(this.maskTypeDropdown, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 22;
        this.add((Component)this.falloffTypeLabel, gbc);
        gbc.gridx = 2;
        gbc.anchor = 21;
        this.add(this.falloffTypeDropdown, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 22;
        this.add((Component)this.autoEstimateMaskButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 21;
        this.add((Component)this.showMaskOverlayButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 21;
        this.add((Component)new JLabel("Imported mask intensity range:"), gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 21;
        this.add((Component)((Object)this.maskRangePanel), gbc);
    }

    public void addActions() {
        this.autoEstimateMaskButton.addActionListener(e -> {
            if (this.autoEstimateMaskButton.isSelected()) {
                this.bw.autoEstimateMask();
            }
        });
        this.showMaskOverlayButton.addActionListener(e -> this.bw.setMaskOverlayVisibility(this.showMaskOverlayButton.isSelected() && this.isMask()));
        this.maskTypeDropdown.addActionListener(e -> this.bw.updateTransformMask());
    }

    public void setMask(final PlateauSphericalMaskSource maskSource) {
        if (this.falloffListener == null) {
            this.falloffTypeDropdown.removeActionListener(this.falloffListener);
        }
        this.falloffTypeDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                maskSource.getRandomAccessible().setFalloffShape((PlateauSphericalMaskRealRandomAccessible.FalloffShape)((Object)MaskOptionsPanel.this.falloffTypeDropdown.getSelectedItem()));
                MaskOptionsPanel.this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
                MaskOptionsPanel.this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
            }
        });
    }

    public JCheckBox getAutoEstimateMaskButton() {
        return this.autoEstimateMaskButton;
    }

    public JCheckBox getShowMaskOverlayButton() {
        return this.showMaskOverlayButton;
    }

    public JComboBox<String> getMaskTypeDropdown() {
        return this.maskTypeDropdown;
    }

    public JComboBox<PlateauSphericalMaskRealRandomAccessible.FalloffShape> getMaskFalloffTypeDropdown() {
        return this.falloffTypeDropdown;
    }

    public MaskBoundsRangePanel getMaskRangeSlider() {
        return this.maskRangePanel;
    }

    public String getType() {
        return (String)this.maskTypeDropdown.getSelectedItem();
    }

    public boolean isMask() {
        return this.maskTypeDropdown.getSelectedIndex() > 0;
    }

    public boolean showMaskOverlay() {
        return this.showMaskOverlayButton.isSelected();
    }
}

