/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;

public class SpatiallyInterpolatedRealTransform<T extends RealType<T>>
implements RealTransform {
    private RealRandomAccessible<T> lambda;
    private RealRandomAccess<T> lambdaAccess;
    private final RealTransform a;
    private final RealTransform b;
    private final RealPoint pa;
    private final RealPoint pb;
    private final double[] arrA;
    private final double[] arrB;

    public SpatiallyInterpolatedRealTransform(RealTransform a, RealTransform b, RealRandomAccessible<T> lambda) {
        assert (a.numTargetDimensions() == b.numTargetDimensions() && a.numSourceDimensions() == b.numSourceDimensions());
        this.a = a;
        this.b = b;
        this.lambda = lambda;
        if (lambda != null) {
            this.lambdaAccess = lambda.realRandomAccess();
        }
        int nd = a.numTargetDimensions();
        this.arrA = new double[nd];
        this.arrB = new double[nd];
        this.pa = RealPoint.wrap((double[])this.arrA);
        this.pb = RealPoint.wrap((double[])this.arrB);
    }

    public int numSourceDimensions() {
        return this.a.numSourceDimensions();
    }

    public int numTargetDimensions() {
        return this.a.numTargetDimensions();
    }

    public void apply(double[] source, double[] target) {
        this.a.apply(source, this.arrA);
        this.b.apply(source, this.arrB);
        for (int i = 0; i < this.numSourceDimensions(); ++i) {
            this.lambdaAccess.setPosition(source[i], i);
        }
        double am = ((RealType)this.lambdaAccess.get()).getRealDouble();
        double bm = 1.0 - am;
        for (int i = 0; i < this.numTargetDimensions(); ++i) {
            target[i] = am * this.arrA[i] + bm * this.arrB[i];
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.a.apply(source, (RealPositionable)this.pa);
        this.b.apply(source, (RealPositionable)this.pb);
        this.lambdaAccess.setPosition(source);
        double am = ((RealType)this.lambdaAccess.get()).getRealDouble();
        double bm = 1.0 - am;
        for (int i = 0; i < this.numTargetDimensions(); ++i) {
            target.setPosition(am * this.pa.getDoublePosition(i) + bm * this.pb.getDoublePosition(i), i);
        }
    }

    public RealTransform copy() {
        return new SpatiallyInterpolatedRealTransform<T>(this.a.copy(), this.b.copy(), this.lambda);
    }
}

