/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

import com.jogamp.math.DoubleUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec4f;

public final class Vec3d {
    private double x;
    private double y;
    private double z;

    public Vec3d() {
    }

    public Vec3d(Vec3d vec3d) {
        this.set(vec3d);
    }

    public Vec3d(Vec4f vec4f) {
        this.set(vec4f);
    }

    public Vec3d(Vec2f vec2f, double d) {
        this.set(vec2f, d);
    }

    public Vec3d copy() {
        return new Vec3d(this);
    }

    public Vec3d(double[] dArray) {
        this.set(dArray);
    }

    public Vec3d(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Vec3d set(Vec3d vec3d) {
        this.x = vec3d.x;
        this.y = vec3d.y;
        this.z = vec3d.z;
        return this;
    }

    public Vec3d set(Vec2f vec2f, double d) {
        this.x = vec2f.x();
        this.y = vec2f.y();
        this.z = d;
        return this;
    }

    public Vec3d set(Vec4f vec4f) {
        this.x = vec4f.x();
        this.y = vec4f.y();
        this.z = vec4f.z();
        return this;
    }

    public Vec3d set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vec3d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        return this;
    }

    public Vec3d toArray(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        return this;
    }

    public void set(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public double[] get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        return dArray;
    }

    public double get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public Vec3d max(Vec3d vec3d) {
        this.x = Math.max(this.x, vec3d.x);
        this.y = Math.max(this.y, vec3d.y);
        this.z = Math.max(this.z, vec3d.z);
        return this;
    }

    public Vec3d min(Vec3d vec3d) {
        this.x = Math.min(this.x, vec3d.x);
        this.y = Math.min(this.y, vec3d.y);
        this.z = Math.min(this.z, vec3d.z);
        return this;
    }

    public Vec3d mul(double d) {
        return new Vec3d(this).scale(d);
    }

    public Vec3d mul(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x * vec3d2.x;
        this.y = vec3d.y * vec3d2.y;
        this.z = vec3d.z * vec3d2.z;
        return this;
    }

    public Vec3d mul(Vec3d vec3d) {
        return this.mul(vec3d.x, vec3d.y, vec3d.z);
    }

    public Vec3d mul(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
        return this;
    }

    public Vec3d div(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x / vec3d2.x;
        this.y = vec3d.y / vec3d2.y;
        this.z = vec3d.z / vec3d2.z;
        return this;
    }

    public Vec3d div(Vec3d vec3d) {
        this.x /= vec3d.x;
        this.y /= vec3d.y;
        this.z /= vec3d.z;
        return this;
    }

    public Vec3d scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vec3d plus(Vec3d vec3d) {
        return new Vec3d(this).add(vec3d);
    }

    public Vec3d plus(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x + vec3d2.x;
        this.y = vec3d.y + vec3d2.y;
        this.z = vec3d.z + vec3d2.z;
        return this;
    }

    public Vec3d add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public Vec3d add(Vec3d vec3d) {
        this.x += vec3d.x;
        this.y += vec3d.y;
        this.z += vec3d.z;
        return this;
    }

    public Vec3d minus(Vec3d vec3d) {
        return new Vec3d(this).sub(vec3d);
    }

    public Vec3d minus(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x - vec3d2.x;
        this.y = vec3d.y - vec3d2.y;
        this.z = vec3d.z - vec3d2.z;
        return this;
    }

    public Vec3d sub(Vec3d vec3d) {
        this.x -= vec3d.x;
        this.y -= vec3d.y;
        this.z -= vec3d.z;
        return this;
    }

    public boolean isZero() {
        return DoubleUtil.isZero(this.x) && DoubleUtil.isZero(this.y) && DoubleUtil.isZero(this.z);
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vec3d normalize() {
        double d = this.lengthSq();
        if (DoubleUtil.isZero(d)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            double d2 = 1.0 / Math.sqrt(d);
            this.x *= d2;
            this.y *= d2;
            this.z *= d2;
        }
        return this;
    }

    public double distSq(Vec3d vec3d) {
        double d = this.x - vec3d.x;
        double d2 = this.y - vec3d.y;
        double d3 = this.z - vec3d.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public double dist(Vec3d vec3d) {
        return Math.sqrt(this.distSq(vec3d));
    }

    public double dot(Vec3d vec3d) {
        return this.x * vec3d.x + this.y * vec3d.y + this.z * vec3d.z;
    }

    public Vec3d cross(Vec3d vec3d) {
        return new Vec3d().cross(this, vec3d);
    }

    public Vec3d cross(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.y * vec3d2.z - vec3d.z * vec3d2.y;
        this.y = vec3d.z * vec3d2.x - vec3d.x * vec3d2.z;
        this.z = vec3d.x * vec3d2.y - vec3d.y * vec3d2.x;
        return this;
    }

    public double cosAngle(Vec3d vec3d) {
        return this.dot(vec3d) / (this.length() * vec3d.length());
    }

    public double angle(Vec3d vec3d) {
        return Math.acos(this.cosAngle(vec3d));
    }

    public boolean isEqual(Vec3d vec3d, double d) {
        if (this == vec3d) {
            return true;
        }
        return DoubleUtil.isEqual(this.x, vec3d.x, d) && DoubleUtil.isEqual(this.y, vec3d.y, d) && DoubleUtil.isEqual(this.z, vec3d.z, d);
    }

    public boolean isEqual(Vec3d vec3d) {
        if (this == vec3d) {
            return true;
        }
        return DoubleUtil.isEqual(this.x, vec3d.x) && DoubleUtil.isEqual(this.y, vec3d.y) && DoubleUtil.isEqual(this.z, vec3d.z);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec3d) {
            return this.isEqual((Vec3d)object);
        }
        return false;
    }

    public String toString() {
        return this.x + " / " + this.y + " / " + this.z;
    }
}

