/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.ShaderAttributeObjectRetained;
import org.scijava.vecmath.Matrix3f;
import org.scijava.vecmath.Matrix4f;
import org.scijava.vecmath.Point2f;
import org.scijava.vecmath.Point2i;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Point3i;
import org.scijava.vecmath.Point4f;
import org.scijava.vecmath.Point4i;
import org.scijava.vecmath.Tuple2f;
import org.scijava.vecmath.Tuple2i;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Tuple3i;
import org.scijava.vecmath.Tuple4f;
import org.scijava.vecmath.Tuple4i;

class ShaderAttributeArrayRetained
extends ShaderAttributeObjectRetained {
    ShaderAttributeArrayRetained() {
    }

    void initValue(int index, Object value) {
        ((ArrayWrapper)this.attrWrapper).set(index, value);
    }

    void setValue(int index, Object value) {
        this.initValue(index, value);
        this.setValue(this.attrWrapper.getRef());
    }

    int length() {
        return ((ArrayWrapper)this.attrWrapper).length();
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeArrayRetained mirrorSAA = new ShaderAttributeArrayRetained();
            mirrorSAA.createObjectData(this.getValue());
            this.mirror = mirrorSAA;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    @Override
    int computeClassType(Object value) {
        Class<?> objClass = value.getClass();
        if (!objClass.isArray()) {
            throw new ClassCastException(objClass + " -- must be array class");
        }
        for (int i = 0; i < classTable.length; ++i) {
            if (!classTableArr[i].isInstance(value)) continue;
            return i;
        }
        throw new ClassCastException(objClass + " -- unrecognized class");
    }

    @Override
    Class getBaseClass(int classType) {
        return classTableArr[classType];
    }

    @Override
    ShaderAttributeObjectRetained.AttrWrapper createAttrWrapper(Object value, int classType) {
        ArrayWrapper attrWrapper = null;
        switch (classType) {
            case 0: {
                attrWrapper = new IntegerArrayWrapper();
                break;
            }
            case 1: {
                attrWrapper = new FloatArrayWrapper();
                break;
            }
            case 2: {
                attrWrapper = new Tuple2iArrayWrapper();
                break;
            }
            case 3: {
                attrWrapper = new Tuple2fArrayWrapper();
                break;
            }
            case 4: {
                attrWrapper = new Tuple3iArrayWrapper();
                break;
            }
            case 5: {
                attrWrapper = new Tuple3fArrayWrapper();
                break;
            }
            case 6: {
                attrWrapper = new Tuple4iArrayWrapper();
                break;
            }
            case 7: {
                attrWrapper = new Tuple4fArrayWrapper();
                break;
            }
            case 8: {
                attrWrapper = new Matrix3fArrayWrapper();
                break;
            }
            case 9: {
                attrWrapper = new Matrix4fArrayWrapper();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        attrWrapper.set(value);
        return attrWrapper;
    }

    static class Matrix4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix4fArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Matrix4f[] arr = (Matrix4f[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length * 16];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 16;
                this.value[j + 0] = arr[i].m00;
                this.value[j + 1] = arr[i].m01;
                this.value[j + 2] = arr[i].m02;
                this.value[j + 3] = arr[i].m03;
                this.value[j + 4] = arr[i].m10;
                this.value[j + 5] = arr[i].m11;
                this.value[j + 6] = arr[i].m12;
                this.value[j + 7] = arr[i].m13;
                this.value[j + 8] = arr[i].m20;
                this.value[j + 9] = arr[i].m21;
                this.value[j + 10] = arr[i].m22;
                this.value[j + 11] = arr[i].m23;
                this.value[j + 12] = arr[i].m30;
                this.value[j + 13] = arr[i].m31;
                this.value[j + 14] = arr[i].m32;
                this.value[j + 15] = arr[i].m33;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 16;
            Matrix4f m = (Matrix4f)value;
            this.value[j + 0] = m.m00;
            this.value[j + 1] = m.m01;
            this.value[j + 2] = m.m02;
            this.value[j + 3] = m.m03;
            this.value[j + 4] = m.m10;
            this.value[j + 5] = m.m11;
            this.value[j + 6] = m.m12;
            this.value[j + 7] = m.m13;
            this.value[j + 8] = m.m20;
            this.value[j + 9] = m.m21;
            this.value[j + 10] = m.m22;
            this.value[j + 11] = m.m23;
            this.value[j + 12] = m.m30;
            this.value[j + 13] = m.m31;
            this.value[j + 14] = m.m32;
            this.value[j + 15] = m.m33;
        }

        @Override
        Object get() {
            Matrix4f[] arr = new Matrix4f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 16;
                arr[i] = new Matrix4f();
                arr[i].m00 = this.value[j + 0];
                arr[i].m01 = this.value[j + 1];
                arr[i].m02 = this.value[j + 2];
                arr[i].m03 = this.value[j + 3];
                arr[i].m10 = this.value[j + 4];
                arr[i].m11 = this.value[j + 5];
                arr[i].m12 = this.value[j + 6];
                arr[i].m13 = this.value[j + 7];
                arr[i].m20 = this.value[j + 8];
                arr[i].m21 = this.value[j + 9];
                arr[i].m22 = this.value[j + 10];
                arr[i].m23 = this.value[j + 11];
                arr[i].m30 = this.value[j + 12];
                arr[i].m31 = this.value[j + 13];
                arr[i].m32 = this.value[j + 14];
                arr[i].m33 = this.value[j + 15];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Matrix3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix3fArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Matrix3f[] arr = (Matrix3f[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length * 9];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 9;
                this.value[j + 0] = arr[i].m00;
                this.value[j + 1] = arr[i].m01;
                this.value[j + 2] = arr[i].m02;
                this.value[j + 3] = arr[i].m10;
                this.value[j + 4] = arr[i].m11;
                this.value[j + 5] = arr[i].m12;
                this.value[j + 6] = arr[i].m20;
                this.value[j + 7] = arr[i].m21;
                this.value[j + 8] = arr[i].m22;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 9;
            Matrix3f m = (Matrix3f)value;
            this.value[j + 0] = m.m00;
            this.value[j + 1] = m.m01;
            this.value[j + 2] = m.m02;
            this.value[j + 3] = m.m10;
            this.value[j + 4] = m.m11;
            this.value[j + 5] = m.m12;
            this.value[j + 6] = m.m20;
            this.value[j + 7] = m.m21;
            this.value[j + 8] = m.m22;
        }

        @Override
        Object get() {
            Matrix3f[] arr = new Matrix3f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 9;
                arr[i] = new Matrix3f();
                arr[i].m00 = this.value[j + 0];
                arr[i].m01 = this.value[j + 1];
                arr[i].m02 = this.value[j + 2];
                arr[i].m10 = this.value[j + 3];
                arr[i].m11 = this.value[j + 4];
                arr[i].m12 = this.value[j + 5];
                arr[i].m20 = this.value[j + 6];
                arr[i].m21 = this.value[j + 7];
                arr[i].m22 = this.value[j + 8];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple4fArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple4f[] arr = (Tuple4f[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length * 4];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 4;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
                this.value[j + 2] = arr[i].z;
                this.value[j + 3] = arr[i].w;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 4;
            this.value[j + 0] = ((Tuple4f)value).x;
            this.value[j + 1] = ((Tuple4f)value).y;
            this.value[j + 2] = ((Tuple4f)value).z;
            this.value[j + 3] = ((Tuple4f)value).w;
        }

        @Override
        Object get() {
            Tuple4f[] arr = new Tuple4f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 4;
                arr[i] = new Point4f();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
                arr[i].z = this.value[j + 2];
                arr[i].w = this.value[j + 3];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple4iArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple4i[] arr = (Tuple4i[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new int[this.length * 4];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 4;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
                this.value[j + 2] = arr[i].z;
                this.value[j + 3] = arr[i].w;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 4;
            this.value[j + 0] = ((Tuple4i)value).x;
            this.value[j + 1] = ((Tuple4i)value).y;
            this.value[j + 2] = ((Tuple4i)value).z;
            this.value[j + 3] = ((Tuple4i)value).w;
        }

        @Override
        Object get() {
            Tuple4i[] arr = new Tuple4i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 4;
                arr[i] = new Point4i();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
                arr[i].z = this.value[j + 2];
                arr[i].w = this.value[j + 3];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple3fArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple3f[] arr = (Tuple3f[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length * 3];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 3;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
                this.value[j + 2] = arr[i].z;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 3;
            this.value[j + 0] = ((Tuple3f)value).x;
            this.value[j + 1] = ((Tuple3f)value).y;
            this.value[j + 2] = ((Tuple3f)value).z;
        }

        @Override
        Object get() {
            Tuple3f[] arr = new Tuple3f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 3;
                arr[i] = new Point3f();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
                arr[i].z = this.value[j + 2];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple3iArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple3i[] arr = (Tuple3i[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new int[this.length * 3];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 3;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
                this.value[j + 2] = arr[i].z;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 3;
            this.value[j + 0] = ((Tuple3i)value).x;
            this.value[j + 1] = ((Tuple3i)value).y;
            this.value[j + 2] = ((Tuple3i)value).z;
        }

        @Override
        Object get() {
            Tuple3i[] arr = new Tuple3i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 3;
                arr[i] = new Point3i();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
                arr[i].z = this.value[j + 2];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple2fArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple2f[] arr = (Tuple2f[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length * 2];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 2;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 2;
            this.value[j + 0] = ((Tuple2f)value).x;
            this.value[j + 1] = ((Tuple2f)value).y;
        }

        @Override
        Object get() {
            Tuple2f[] arr = new Tuple2f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 2;
                arr[i] = new Point2f();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple2iArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Tuple2i[] arr = (Tuple2i[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new int[this.length * 2];
            }
            for (int i = 0; i < this.length; ++i) {
                int j = i * 2;
                this.value[j + 0] = arr[i].x;
                this.value[j + 1] = arr[i].y;
            }
        }

        @Override
        void set(int index, Object value) {
            int j = index * 2;
            this.value[j + 0] = ((Tuple2i)value).x;
            this.value[j + 1] = ((Tuple2i)value).y;
        }

        @Override
        Object get() {
            Tuple2i[] arr = new Tuple2i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int j = i * 2;
                arr[i] = new Point2i();
                arr[i].x = this.value[j + 0];
                arr[i].y = this.value[j + 1];
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class FloatArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        FloatArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Float[] arr = (Float[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new float[this.length];
            }
            for (int i = 0; i < this.length; ++i) {
                this.value[i] = arr[i].floatValue();
            }
        }

        @Override
        void set(int index, Object value) {
            this.value[index] = ((Float)value).floatValue();
        }

        @Override
        Object get() {
            Float[] arr = new Float[this.length];
            for (int i = 0; i < this.length; ++i) {
                arr[i] = new Float(this.value[i]);
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class IntegerArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        IntegerArrayWrapper() {
        }

        @Override
        void set(Object value) {
            Integer[] arr = (Integer[])value;
            if (this.length != arr.length) {
                this.length = arr.length;
                this.value = new int[this.length];
            }
            for (int i = 0; i < this.length; ++i) {
                this.value[i] = arr[i];
            }
        }

        @Override
        void set(int index, Object value) {
            this.value[index] = (Integer)value;
        }

        @Override
        Object get() {
            Integer[] arr = new Integer[this.length];
            for (int i = 0; i < this.length; ++i) {
                arr[i] = new Integer(this.value[i]);
            }
            return arr;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static abstract class ArrayWrapper
    extends ShaderAttributeObjectRetained.AttrWrapper {
        int length = 0;

        ArrayWrapper() {
        }

        int length() {
            return this.length;
        }

        abstract void set(int var1, Object var2);
    }
}

