/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.util.Map;

public class mxSwimlaneManager
extends mxEventSource {
    protected mxGraph graph;
    protected boolean enabled;
    protected boolean horizontal;
    protected boolean addEnabled;
    protected boolean resizeEnabled;
    protected mxEventSource.mxIEventListener addHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            if (mxSwimlaneManager.this.isEnabled() && mxSwimlaneManager.this.isAddEnabled()) {
                mxSwimlaneManager.this.cellsAdded((Object[])evt.getProperty("cells"));
            }
        }
    };
    protected mxEventSource.mxIEventListener resizeHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            if (mxSwimlaneManager.this.isEnabled() && mxSwimlaneManager.this.isResizeEnabled()) {
                mxSwimlaneManager.this.cellsResized((Object[])evt.getProperty("cells"));
            }
        }
    };

    public mxSwimlaneManager(mxGraph graph) {
        this.setGraph(graph);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean value) {
        this.horizontal = value;
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean value) {
        this.addEnabled = value;
    }

    public boolean isResizeEnabled() {
        return this.resizeEnabled;
    }

    public void setResizeEnabled(boolean value) {
        this.resizeEnabled = value;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph graph) {
        if (this.graph != null) {
            this.graph.removeListener(this.addHandler);
            this.graph.removeListener(this.resizeHandler);
        }
        this.graph = graph;
        if (this.graph != null) {
            this.graph.addListener("addCells", this.addHandler);
            this.graph.addListener("cellsResized", this.resizeHandler);
        }
    }

    protected boolean isSwimlaneIgnored(Object swimlane) {
        return !this.getGraph().isSwimlane(swimlane);
    }

    protected boolean isCellHorizontal(Object cell) {
        if (this.graph.isSwimlane(cell)) {
            mxCellState state = this.graph.getView().getState(cell);
            Map<String, Object> style = state != null ? state.getStyle() : this.graph.getCellStyle(cell);
            return mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
        }
        return !this.isHorizontal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsAdded(Object[] cells) {
        if (cells != null) {
            mxIGraphModel model = this.getGraph().getModel();
            model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    if (this.isSwimlaneIgnored(cells[i])) continue;
                    this.swimlaneAdded(cells[i]);
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    protected void swimlaneAdded(Object swimlane) {
        Object child;
        mxIGraphModel model = this.getGraph().getModel();
        Object parent = model.getParent(swimlane);
        int childCount = model.getChildCount(parent);
        mxRectangle geo = null;
        for (int i = 0; i < childCount && ((child = model.getChildAt(parent, i)) == swimlane || this.isSwimlaneIgnored(child) || (geo = model.getGeometry(child)) == null); ++i) {
        }
        if (geo != null) {
            boolean parentHorizontal = parent != null ? this.isCellHorizontal(parent) : this.horizontal;
            this.resizeSwimlane(swimlane, geo.getWidth(), geo.getHeight(), parentHorizontal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsResized(Object[] cells) {
        if (cells != null) {
            mxIGraphModel model = this.getGraph().getModel();
            model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    Object top;
                    mxGeometry geo;
                    if (this.isSwimlaneIgnored(cells[i]) || (geo = model.getGeometry(cells[i])) == null) continue;
                    mxRectangle size = new mxRectangle(0.0, 0.0, geo.getWidth(), geo.getHeight());
                    Object current = top = cells[i];
                    while (current != null) {
                        top = current;
                        mxRectangle tmp = this.graph.isSwimlane(current = model.getParent(current)) ? this.graph.getStartSize(current) : new mxRectangle();
                        size.setWidth(size.getWidth() + tmp.getWidth());
                        size.setHeight(size.getHeight() + tmp.getHeight());
                    }
                    boolean parentHorizontal = current != null ? this.isCellHorizontal(current) : this.horizontal;
                    this.resizeSwimlane(top, size.getWidth(), size.getHeight(), parentHorizontal);
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resizeSwimlane(Object swimlane, double w, double h, boolean parentHorizontal) {
        mxIGraphModel model = this.getGraph().getModel();
        model.beginUpdate();
        try {
            mxGeometry geo;
            boolean horizontal = this.isCellHorizontal(swimlane);
            if (!this.isSwimlaneIgnored(swimlane) && (geo = model.getGeometry(swimlane)) != null && (parentHorizontal && geo.getHeight() != h || !parentHorizontal && geo.getWidth() != w)) {
                geo = (mxGeometry)geo.clone();
                if (parentHorizontal) {
                    geo.setHeight(h);
                } else {
                    geo.setWidth(w);
                }
                model.setGeometry(swimlane, geo);
            }
            mxRectangle tmp = this.graph.isSwimlane(swimlane) ? this.graph.getStartSize(swimlane) : new mxRectangle();
            w -= tmp.getWidth();
            h -= tmp.getHeight();
            int childCount = model.getChildCount(swimlane);
            for (int i = 0; i < childCount; ++i) {
                Object child = model.getChildAt(swimlane, i);
                this.resizeSwimlane(child, w, h, horizontal);
            }
        }
        finally {
            model.endUpdate();
        }
    }

    public void destroy() {
        this.setGraph(null);
    }
}

