/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.SplitCriterion;
import weka.core.ContingencyTables;

public abstract class EntropyBasedSplitCrit
extends SplitCriterion {
    private static final long serialVersionUID = -2618691439791653056L;

    public final double lnFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return ContingencyTables.lnFunc(num);
    }

    public final double oldEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int j = 0; j < bags.numClasses(); ++j) {
            returnValue += this.lnFunc(bags.perClass(j));
        }
        return (this.lnFunc(bags.total()) - returnValue) / ContingencyTables.log2;
    }

    public final double newEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int i = 0; i < bags.numBags(); ++i) {
            for (int j = 0; j < bags.numClasses(); ++j) {
                returnValue += this.lnFunc(bags.perClassPerBag(i, j));
            }
            returnValue -= this.lnFunc(bags.perBag(i));
        }
        return -(returnValue / ContingencyTables.log2);
    }

    public final double splitEnt(Distribution bags) {
        double returnValue = 0.0;
        for (int i = 0; i < bags.numBags(); ++i) {
            returnValue += this.lnFunc(bags.perBag(i));
        }
        return (this.lnFunc(bags.total()) - returnValue) / ContingencyTables.log2;
    }
}

