/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;

public class MiddleOutConstructor
extends BallTreeConstructor
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -8523314263062524462L;
    protected int m_RSeed = 1;
    protected Random rand = new Random(this.m_RSeed);
    private double rootRadius = -1.0;
    protected boolean m_RandomInitialAnchor = true;

    public String globalInfo() {
        return "The class that builds a BallTree middle out.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore");
        result.setValue(TechnicalInformation.Field.TITLE, "The Anchors Hierarchy: Using the Triangle Inequality to Survive High Dimensional Data");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "UAI '00: Proceedings of the 16th Conference on Uncertainty in Artificial Intelligence");
        result.setValue(TechnicalInformation.Field.PAGES, "397-405");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers Inc.");
        result.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA, USA");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MASTERSTHESIS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        additional.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        additional.setValue(TechnicalInformation.Field.YEAR, "2007");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    @Override
    public BallNode buildTree() throws Exception {
        this.m_NumLeaves = 0;
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        if (this.rootRadius == -1.0) {
            this.rootRadius = BallNode.calcRadius(this.m_InstList, this.m_Instances, BallNode.calcCentroidPivot(this.m_InstList, this.m_Instances), this.m_DistanceFunction);
        }
        BallNode root = this.buildTreeMiddleOut(0, this.m_Instances.numInstances() - 1);
        return root;
    }

    protected BallNode buildTreeMiddleOut(int startIdx, int endIdx) throws Exception {
        int numInsts = endIdx - startIdx + 1;
        int numAnchors = (int)Math.round(Math.sqrt(numInsts));
        if (numAnchors > 1) {
            Instance pivot = BallNode.calcCentroidPivot(startIdx, endIdx, this.m_InstList, this.m_Instances);
            double radius = BallNode.calcRadius(startIdx, endIdx, this.m_InstList, this.m_Instances, pivot, this.m_DistanceFunction);
            if (numInsts <= this.m_MaxInstancesInLeaf || this.rootRadius == 0.0 || radius / this.rootRadius < this.m_MaxRelLeafRadius) {
                BallNode node = new BallNode(startIdx, endIdx, this.m_NumNodes, pivot, radius);
                return node;
            }
            Vector<TempNode> anchors = new Vector<TempNode>(numAnchors);
            this.createAnchorsHierarchy(anchors, numAnchors, startIdx, endIdx);
            BallNode node = this.mergeNodes(anchors, startIdx, endIdx);
            this.buildLeavesMiddleOut(node);
            return node;
        }
        Instance pivot = BallNode.calcCentroidPivot(startIdx, endIdx, this.m_InstList, this.m_Instances);
        BallNode node = new BallNode(startIdx, endIdx, this.m_NumNodes, pivot, BallNode.calcRadius(startIdx, endIdx, this.m_InstList, this.m_Instances, pivot, this.m_DistanceFunction));
        return node;
    }

    protected void createAnchorsHierarchy(Vector<TempNode> anchors, int numAnchors, int startIdx, int endIdx) throws Exception {
        TempNode anchr1;
        TempNode amax = anchr1 = this.m_RandomInitialAnchor ? this.getRandomAnchor(startIdx, endIdx) : this.getFurthestFromMeanAnchor(startIdx, endIdx);
        Vector<double[]> anchorDistances = new Vector<double[]>(numAnchors - 1);
        anchors.add(anchr1);
        while (anchors.size() < numAnchors) {
            Instance newpivot;
            TempNode newAnchor = new TempNode();
            newAnchor.points = new MyIdxList();
            newAnchor.anchor = newpivot = this.m_Instances.instance(amax.points.getFirst().idx);
            newAnchor.idx = amax.points.getFirst().idx;
            this.setInterAnchorDistances(anchors, newAnchor, anchorDistances);
            newAnchor.radius = this.stealPoints(newAnchor, anchors, anchorDistances) ? newAnchor.points.getFirst().distance : 0.0;
            anchors.add(newAnchor);
            amax = anchors.elementAt(0);
            for (int i = 1; i < anchors.size(); ++i) {
                newAnchor = anchors.elementAt(i);
                if (!(newAnchor.radius > amax.radius)) continue;
                amax = newAnchor;
            }
        }
    }

    protected void buildLeavesMiddleOut(BallNode node) throws Exception {
        if (node.m_Left != null && node.m_Right != null) {
            this.buildLeavesMiddleOut(node.m_Left);
            this.buildLeavesMiddleOut(node.m_Right);
        } else {
            if (node.m_Left != null || node.m_Right != null) {
                throw new Exception("Invalid leaf assignment. Please check code");
            }
            BallNode n2 = this.buildTreeMiddleOut(node.m_Start, node.m_End);
            if (n2.m_Left != null && n2.m_Right != null) {
                node.m_Left = n2.m_Left;
                node.m_Right = n2.m_Right;
                this.buildLeavesMiddleOut(node);
            } else if (n2.m_Left != null || n2.m_Right != null) {
                throw new Exception("Invalid leaf assignment. Please check code");
            }
        }
    }

    protected BallNode mergeNodes(Vector<TempNode> list, int startIdx, int endIdx) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            TempNode n = list.get(i);
            n.anchor = this.calcPivot(n.points, new MyIdxList(), this.m_Instances);
            n.radius = this.calcRadius(n.points, new MyIdxList(), n.anchor, this.m_Instances);
        }
        Instance minPivot = null;
        int min1 = -1;
        int min2 = -1;
        while (list.size() > 1) {
            double minRadius = Double.POSITIVE_INFINITY;
            for (int i = 0; i < list.size(); ++i) {
                TempNode first = list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    TempNode second = list.get(j);
                    Instance pivot = this.calcPivot(first, second, this.m_Instances);
                    double tmpRadius = this.calcRadius(first, second);
                    if (!(tmpRadius < minRadius)) continue;
                    minRadius = tmpRadius;
                    minPivot = pivot;
                    min1 = i;
                    min2 = j;
                }
            }
            TempNode parent = new TempNode();
            parent.left = list.get(min1);
            parent.right = list.get(min2);
            parent.anchor = minPivot;
            parent.radius = this.calcRadius(parent.left.points, parent.right.points, minPivot, this.m_Instances);
            parent.points = parent.left.points.append(parent.left.points, parent.right.points);
            list.remove(min1);
            list.remove(min2 - 1);
            list.add(parent);
        }
        TempNode tmpRoot = list.get(list.size() - 1);
        if (endIdx - startIdx + 1 != tmpRoot.points.length()) {
            throw new Exception("Root nodes instance list is of irregular length. Please check code. Length should be: " + (endIdx - startIdx + 1) + " whereas it is found to be: " + tmpRoot.points.length());
        }
        for (int i = 0; i < tmpRoot.points.length(); ++i) {
            this.m_InstList[startIdx + i] = tmpRoot.points.get((int)i).idx;
        }
        BallNode node = this.makeBallTreeNodes(tmpRoot, startIdx, endIdx, 0);
        return node;
    }

    protected BallNode makeBallTreeNodes(TempNode node, int startidx, int endidx, int depth) {
        BallNode ball = null;
        if (node.left != null && node.right != null) {
            ball = new BallNode(startidx, endidx, this.m_NumNodes, node.anchor, node.radius);
            ++this.m_NumNodes;
            ball.m_Left = this.makeBallTreeNodes(node.left, startidx, startidx + node.left.points.length() - 1, depth + 1);
            ball.m_Right = this.makeBallTreeNodes(node.right, startidx + node.left.points.length(), endidx, depth + 1);
            ++this.m_MaxDepth;
        } else {
            ball = new BallNode(startidx, endidx, this.m_NumNodes, node.anchor, node.radius);
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
        }
        return ball;
    }

    protected TempNode getFurthestFromMeanAnchor(int startIdx, int endIdx) {
        TempNode anchor = new TempNode();
        Instance centroid = BallNode.calcCentroidPivot(startIdx, endIdx, this.m_InstList, this.m_Instances);
        anchor.radius = Double.NEGATIVE_INFINITY;
        for (int i = startIdx; i <= endIdx; ++i) {
            Instance temp = this.m_Instances.instance(this.m_InstList[i]);
            double tmpr = this.m_DistanceFunction.distance(centroid, temp);
            if (!(tmpr > anchor.radius)) continue;
            anchor.idx = this.m_InstList[i];
            anchor.anchor = temp;
            anchor.radius = tmpr;
        }
        this.setPoints(anchor, startIdx, endIdx, this.m_InstList);
        return anchor;
    }

    protected TempNode getRandomAnchor(int startIdx, int endIdx) {
        TempNode anchr1 = new TempNode();
        anchr1.idx = this.m_InstList[startIdx + this.rand.nextInt(endIdx - startIdx + 1)];
        anchr1.anchor = this.m_Instances.instance(anchr1.idx);
        this.setPoints(anchr1, startIdx, endIdx, this.m_InstList);
        anchr1.radius = anchr1.points.getFirst().distance;
        return anchr1;
    }

    public void setPoints(TempNode node, int startIdx, int endIdx, int[] indices) {
        node.points = new MyIdxList();
        for (int i = startIdx; i <= endIdx; ++i) {
            Instance temp = this.m_Instances.instance(indices[i]);
            double dist = this.m_DistanceFunction.distance(node.anchor, temp);
            node.points.insertReverseSorted(indices[i], dist);
        }
    }

    public void setInterAnchorDistances(Vector<TempNode> anchors, TempNode newAnchor, Vector<double[]> anchorDistances) throws Exception {
        double[] distArray = new double[anchors.size()];
        for (int i = 0; i < anchors.size(); ++i) {
            Instance anchr = anchors.elementAt((int)i).anchor;
            distArray[i] = this.m_DistanceFunction.distance(anchr, newAnchor.anchor);
        }
        anchorDistances.add(distArray);
    }

    public boolean stealPoints(TempNode newAnchor, Vector<TempNode> anchors, Vector<double[]> anchorDistances) {
        double[] distArray;
        double maxDist = Double.NEGATIVE_INFINITY;
        for (double element : distArray = anchorDistances.lastElement()) {
            if (!(maxDist < element)) continue;
            maxDist = element;
        }
        boolean anyPointsStolen = false;
        boolean pointsStolen = false;
        Instance newAnchInst = newAnchor.anchor;
        for (int i = 0; i < anchors.size(); ++i) {
            TempNode anchorI = anchors.elementAt(i);
            Instance anchIInst = anchorI.anchor;
            pointsStolen = false;
            double interAnchMidDist = this.m_DistanceFunction.distance(newAnchInst, anchIInst) / 2.0;
            for (int j = 0; j < anchorI.points.length(); ++j) {
                double distI;
                ListNode tmp = anchorI.points.get(j);
                if (tmp.distance < interAnchMidDist) break;
                double newDist = this.m_DistanceFunction.distance(newAnchInst, this.m_Instances.instance(tmp.idx));
                if (!(newDist < (distI = tmp.distance))) continue;
                newAnchor.points.insertReverseSorted(tmp.idx, newDist);
                anchorI.points.remove(j);
                pointsStolen = true;
                anyPointsStolen = true;
            }
            if (!pointsStolen) continue;
            anchorI.radius = anchorI.points.getFirst().distance;
        }
        return anyPointsStolen;
    }

    public Instance calcPivot(TempNode node1, TempNode node2, Instances insts) {
        int k;
        int classIdx = this.m_Instances.classIndex();
        double[] attrVals = new double[insts.numAttributes()];
        double anchr1Ratio = (double)node1.points.length() / (double)(node1.points.length() + node2.points.length());
        double anchr2Ratio = (double)node2.points.length() / (double)(node1.points.length() + node2.points.length());
        for (k = 0; k < node1.anchor.numValues(); ++k) {
            if (node1.anchor.index(k) == classIdx) continue;
            int n = k;
            attrVals[n] = attrVals[n] + node1.anchor.valueSparse(k) * anchr1Ratio;
        }
        for (k = 0; k < node2.anchor.numValues(); ++k) {
            if (node2.anchor.index(k) == classIdx) continue;
            int n = k;
            attrVals[n] = attrVals[n] + node2.anchor.valueSparse(k) * anchr2Ratio;
        }
        DenseInstance temp = new DenseInstance(1.0, attrVals);
        return temp;
    }

    public Instance calcPivot(MyIdxList list1, MyIdxList list2, Instances insts) {
        int j;
        int k;
        Instance temp;
        int classIdx = this.m_Instances.classIndex();
        double[] attrVals = new double[insts.numAttributes()];
        for (int i = 0; i < list1.length(); ++i) {
            temp = insts.instance(list1.get((int)i).idx);
            for (k = 0; k < temp.numValues(); ++k) {
                if (temp.index(k) == classIdx) continue;
                int n = k;
                attrVals[n] = attrVals[n] + temp.valueSparse(k);
            }
        }
        for (j = 0; j < list2.length(); ++j) {
            temp = insts.instance(list2.get((int)j).idx);
            for (k = 0; k < temp.numValues(); ++k) {
                if (temp.index(k) == classIdx) continue;
                int n = k;
                attrVals[n] = attrVals[n] + temp.valueSparse(k);
            }
        }
        j = 0;
        int numInsts = list1.length() + list2.length();
        while (j < attrVals.length) {
            int n = j++;
            attrVals[n] = attrVals[n] / (double)numInsts;
        }
        temp = new DenseInstance(1.0, attrVals);
        return temp;
    }

    public double calcRadius(TempNode n1, TempNode n2) {
        Instance p1 = n1.anchor;
        Instance p2 = n2.anchor;
        double radius = n1.radius + this.m_DistanceFunction.distance(p1, p2) + n2.radius;
        return radius / 2.0;
    }

    public double calcRadius(MyIdxList list1, MyIdxList list2, Instance pivot, Instances insts) {
        double dist;
        double radius = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < list1.length(); ++i) {
            dist = this.m_DistanceFunction.distance(pivot, insts.instance(list1.get((int)i).idx));
            if (!(dist > radius)) continue;
            radius = dist;
        }
        for (int j = 0; j < list2.length(); ++j) {
            dist = this.m_DistanceFunction.distance(pivot, insts.instance(list2.get((int)j).idx));
            if (!(dist > radius)) continue;
            radius = dist;
        }
        return radius;
    }

    @Override
    public int[] addInstance(BallNode node, Instance inst) throws Exception {
        throw new Exception("Addition of instances after the tree is built, not possible with MiddleOutConstructor.");
    }

    @Override
    public void setMaxInstancesInLeaf(int num) throws Exception {
        if (num < 2) {
            throw new Exception("The maximum number of instances in a leaf for using MiddleOutConstructor must be >=2.");
        }
        super.setMaxInstancesInLeaf(num);
    }

    @Override
    public void setInstances(Instances insts) {
        super.setInstances(insts);
        this.rootRadius = -1.0;
    }

    @Override
    public void setInstanceList(int[] instList) {
        super.setInstanceList(instList);
        this.rootRadius = -1.0;
    }

    public String initialAnchorRandomTipText() {
        return "Whether the initial anchor is chosen randomly.";
    }

    public boolean isInitialAnchorRandom() {
        return this.m_RandomInitialAnchor;
    }

    public void setInitialAnchorRandom(boolean randomInitialAnchor) {
        this.m_RandomInitialAnchor = randomInitialAnchor;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    @Override
    public int getSeed() {
        return this.m_RSeed;
    }

    @Override
    public void setSeed(int seed) {
        this.m_RSeed = seed;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe seed for the random number generator used\n\tin selecting random anchor.\n(default: 1)", "S", 1, "-S <num>"));
        newVector.addElement(new Option("\tUse randomly chosen initial anchors.", "R", 0, "-R"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String temp = Utils.getOption('S', options);
        if (temp.length() > 0) {
            this.setSeed(Integer.parseInt(temp));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
        this.setInitialAnchorRandom(Utils.getFlag('R', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getSeed());
        if (this.isInitialAnchorRandom()) {
            result.add("-R");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void checkIndicesList(MyIdxList list, int startidx, int endidx) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            ListNode node = list.get(i);
            boolean found = false;
            for (int j = startidx; j <= endidx; ++j) {
                if (node.idx != this.m_InstList[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new Exception("Error: Element " + node.idx + " of the list not in the array.\nArray: " + this.printInsts(startidx, endidx) + "\nList: " + this.printList(list));
        }
    }

    public String printInsts(int startIdx, int endIdx) {
        StringBuffer bf = new StringBuffer();
        try {
            bf.append("i: ");
            for (int i = startIdx; i <= endIdx; ++i) {
                if (i == startIdx) {
                    bf.append("" + this.m_InstList[i]);
                    continue;
                }
                bf.append(", " + this.m_InstList[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bf.toString();
    }

    public String printList(MyIdxList points) {
        if (points == null || points.length() == 0) {
            return "";
        }
        StringBuffer bf = new StringBuffer();
        try {
            for (int i = 0; i < points.size(); ++i) {
                ListNode temp = points.get(i);
                if (i == 0) {
                    bf.append("" + temp.idx);
                    continue;
                }
                bf.append(", " + temp.idx);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bf.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11269 $");
    }

    protected class TempNode
    implements RevisionHandler {
        Instance anchor;
        int idx;
        double radius;
        MyIdxList points;
        TempNode left;
        TempNode right;

        protected TempNode() {
        }

        public String toString() {
            if (this.points == null || this.points.length() == 0) {
                return this.idx + "";
            }
            StringBuffer bf = new StringBuffer();
            try {
                bf.append(this.idx + " p: ");
                for (int i = 0; i < this.points.size(); ++i) {
                    ListNode temp = this.points.get(i);
                    if (i == 0) {
                        bf.append("" + temp.idx);
                        continue;
                    }
                    bf.append(", " + temp.idx);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return bf.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 11269 $");
        }
    }

    protected class MyIdxList
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -2283869109722934927L;
        protected ArrayList<ListNode> m_List;

        public MyIdxList() {
            this.m_List = new ArrayList();
        }

        public MyIdxList(int capacity) {
            this.m_List = new ArrayList(capacity);
        }

        public ListNode getFirst() {
            return this.m_List.get(0);
        }

        public void insertReverseSorted(int idx, double distance) {
            int i = 0;
            for (ListNode temp : this.m_List) {
                if (temp.distance < distance) break;
                ++i;
            }
            this.m_List.add(i, new ListNode(idx, distance));
        }

        public ListNode get(int index) {
            return this.m_List.get(index);
        }

        public void remove(int index) {
            this.m_List.remove(index);
        }

        public int length() {
            return this.m_List.size();
        }

        public int size() {
            return this.m_List.size();
        }

        public MyIdxList append(MyIdxList list1, MyIdxList list2) {
            MyIdxList temp = new MyIdxList(list1.size() + list2.size());
            temp.m_List.addAll(list1.m_List);
            temp.m_List.addAll(list2.m_List);
            return temp;
        }

        public void checkSorting(MyIdxList list) throws Exception {
            Iterator<ListNode> en = this.m_List.iterator();
            ListNode first = null;
            ListNode second = null;
            while (en.hasNext()) {
                if (first == null) {
                    first = en.next();
                    continue;
                }
                second = en.next();
                if (!(first.distance < second.distance)) continue;
                throw new Exception("List not sorted correctly. first.distance: " + first.distance + " second.distance: " + second.distance + " Please check code.");
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 11269 $");
        }
    }

    protected class ListNode
    implements RevisionHandler,
    Serializable {
        int idx = -1;
        double distance = Double.NEGATIVE_INFINITY;

        public ListNode(int i, double d) {
            this.idx = i;
            this.distance = d;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 11269 $");
        }
    }
}

