/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import weka.core.Environment;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;

public class LookAndFeel {
    public static String PROPERTY_FILE = "weka/gui/LookAndFeel.props";
    protected static Properties LOOKANDFEEL_PROPERTIES;

    public static List<String> getAvailableLookAndFeelClasses() {
        LinkedList<String> lafs = new LinkedList<String>();
        for (UIManager.LookAndFeelInfo i : UIManager.getInstalledLookAndFeels()) {
            lafs.add(i.getClassName());
        }
        return lafs;
    }

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
            if (System.getProperty("os.name").toLowerCase().contains("mac os x") && (classname.equals("javax.swing.plaf.metal.MetalLookAndFeel") || classname.equals("javax.swing.plaf.nimbus.NimbusLookAndFeel"))) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent e) {
                        if (!e.isConsumed() && e.isMetaDown() && (e.getKeyCode() == 86 || e.getKeyCode() == 65 || e.getKeyCode() == 67 || e.getKeyCode() == 88)) {
                            e.setModifiers(128);
                        }
                        return false;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static void setLookAndFeel(String appID, String lookAndFeelKey, String defaultLookAndFeel) throws IOException {
        Settings forLookAndFeelOnly = new Settings("weka", appID);
        String laf = forLookAndFeelOnly.getSetting(appID, lookAndFeelKey, defaultLookAndFeel, Environment.getSystemWide());
        if (laf.length() <= 0 || !laf.contains(".") || !LookAndFeel.setLookAndFeel(laf)) {
            LookAndFeel.setLookAndFeel();
        }
    }

    public static boolean setLookAndFeel() {
        String classname = LOOKANDFEEL_PROPERTIES.getProperty("Theme", "");
        if (classname.equals("")) {
            classname = LookAndFeel.getSystemLookAndFeel();
        }
        return LookAndFeel.setLookAndFeel(classname);
    }

    public static String getSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
        String[] result = new String[laf.length];
        for (int i = 0; i < laf.length; ++i) {
            result[i] = laf[i].getClassName();
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("\nInstalled Look and Feel themes:");
        String[] list = LookAndFeel.getInstalledLookAndFeels();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(i + 1 + ". " + list[i]);
        }
        System.out.println("\nNote: a theme can be set in '" + PROPERTY_FILE + "'.");
    }

    static {
        try {
            WekaPackageClassLoaderManager.forName("com.formdev.flatlaf.FlatLightLaf");
            UIManager.installLookAndFeel("Flat Light", "com.formdev.flatlaf.FlatLightLaf");
            UIManager.installLookAndFeel("Flat Dark", "com.formdev.flatlaf.FlatDarkLaf");
            UIManager.installLookAndFeel("Flat IntelliJ", "com.formdev.flatlaf.FlatIntelliJLaf");
            UIManager.installLookAndFeel("Flat Darcula", "com.formdev.flatlaf.FlatDarculaLaf");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "LookAndFeel: failed to install FlatLaf.", "LookAndFeel", 0);
        }
        try {
            LOOKANDFEEL_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "LookAndFeel: Could not read a LookAndFeel configuration file.\nAn example file is included in the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\"  and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\nor the directory that java was started from\n", "LookAndFeel", 0);
        }
    }
}

