/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.CausalFilter;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CausalFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(CausalFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Random() {
        int[] lag1 = new int[]{0, 1, 2};
        float[] a = new float[]{1.0f, -1.8f, 0.81f};
        CausalFilter cf = new CausalFilter(lag1, a);
        int n = 100;
        float tiny = (float)n * 10.0f * 1.1920929E-7f;
        float[] x = CausalFilterTest.rands(n);
        float[] y = CausalFilterTest.rands(n);
        float[] ax = CausalFilterTest.zeros(n);
        float[] ay = CausalFilterTest.zeros(n);
        cf.apply(x, ax);
        cf.applyTranspose(y, ay);
        float dyx = CausalFilterTest.dot(y, ax);
        float dxy = CausalFilterTest.dot(x, ay);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n);
        y = CausalFilterTest.rands(n);
        float[] bx = CausalFilterTest.zeros(n);
        float[] by = CausalFilterTest.zeros(n);
        cf.applyInverse(x, bx);
        cf.applyInverseTranspose(y, by);
        dyx = CausalFilterTest.dot(y, bx);
        dxy = CausalFilterTest.dot(x, by);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n);
        y = ArrayMath.copy(x);
        cf.apply(y, y);
        cf.applyInverse(y, y);
        CausalFilterTest.assertEqual(x, y);
        x = CausalFilterTest.rands(n);
        y = ArrayMath.copy(x);
        cf.applyInverseTranspose(y, y);
        cf.applyTranspose(y, y);
        CausalFilterTest.assertEqual(x, y);
    }

    public void test2Random() {
        int[] lag1 = new int[]{0, 1, 2, 3, 4, -4, -3, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
        float[] a = new float[]{1.7954845f, -0.64490664f, -0.03850411f, -0.01793403f, -0.00708972f, -0.02290331f, -0.04141619f, -0.08457147f, -0.20031442f, -0.5565992f};
        CausalFilter cf = new CausalFilter(lag1, lag2, a);
        int n1 = 19;
        int n2 = 21;
        float tiny = (float)(n1 * n2) * 10.0f * 1.1920929E-7f;
        float[][] x = CausalFilterTest.rands(n1, n2);
        float[][] y = CausalFilterTest.rands(n1, n2);
        float[][] ax = CausalFilterTest.zeros(n1, n2);
        float[][] ay = CausalFilterTest.zeros(n1, n2);
        cf.apply(x, ax);
        cf.applyTranspose(y, ay);
        float dyx = CausalFilterTest.dot(y, ax);
        float dxy = CausalFilterTest.dot(x, ay);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n1, n2);
        y = CausalFilterTest.rands(n1, n2);
        float[][] bx = CausalFilterTest.zeros(n1, n2);
        float[][] by = CausalFilterTest.zeros(n1, n2);
        cf.applyInverse(x, bx);
        cf.applyInverseTranspose(y, by);
        dyx = CausalFilterTest.dot(y, bx);
        dxy = CausalFilterTest.dot(x, by);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n1, n2);
        y = ArrayMath.copy(x);
        cf.apply(y, y);
        cf.applyInverse(y, y);
        CausalFilterTest.assertEqual(x, y);
        x = CausalFilterTest.rands(n1, n2);
        y = ArrayMath.copy(x);
        cf.applyInverseTranspose(y, y);
        cf.applyTranspose(y, y);
        CausalFilterTest.assertEqual(x, y);
    }

    public void test3Random() {
        int[] lag1 = new int[]{0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, 0, 0, 0};
        int[] lag3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        float[] a = new float[]{2.3110454f, -0.4805547f, -0.0143204f, -0.0291793f, -0.1057476f, -0.4572746f, -0.0115732f, -0.0047283f, -0.0149963f, -0.0408317f, -0.0945958f, -0.0223166f, -0.0062781f, -0.0213786f, -0.0898909f, -0.4322719f};
        CausalFilter cf = new CausalFilter(lag1, lag2, lag3, a);
        int n1 = 11;
        int n2 = 13;
        int n3 = 12;
        float tiny = (float)(n1 * n2 * n3) * 10.0f * 1.1920929E-7f;
        float[][][] x = CausalFilterTest.rands(n1, n2, n3);
        float[][][] y = CausalFilterTest.rands(n1, n2, n3);
        float[][][] ax = CausalFilterTest.zeros(n1, n2, n3);
        float[][][] ay = CausalFilterTest.zeros(n1, n2, n3);
        cf.apply(x, ax);
        cf.applyTranspose(y, ay);
        float dyx = CausalFilterTest.dot(y, ax);
        float dxy = CausalFilterTest.dot(x, ay);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n1, n2, n3);
        y = CausalFilterTest.rands(n1, n2, n3);
        float[][][] bx = CausalFilterTest.zeros(n1, n2, n3);
        float[][][] by = CausalFilterTest.zeros(n1, n2, n3);
        cf.applyInverse(x, bx);
        cf.applyInverseTranspose(y, by);
        dyx = CausalFilterTest.dot(y, bx);
        dxy = CausalFilterTest.dot(x, by);
        CausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = CausalFilterTest.rands(n1, n2, n3);
        y = ArrayMath.copy(x);
        cf.apply(y, y);
        cf.applyInverse(y, y);
        CausalFilterTest.assertEqual(x, y);
        x = CausalFilterTest.rands(n1, n2, n3);
        y = ArrayMath.copy(x);
        cf.applyInverseTranspose(y, y);
        cf.applyTranspose(y, y);
        CausalFilterTest.assertEqual(x, y);
    }

    public void testFactorFomelExample() {
        float[] r = new float[]{24.0f, 242.0f, 867.0f, 1334.0f, 867.0f, 242.0f, 24.0f};
        int[] lag1 = new int[]{0, 1, 2, 3};
        CausalFilter cf = new CausalFilter(lag1);
        cf.factorWilsonBurg(10, 0.0f, r);
        float[] a = cf.getA();
        CausalFilterTest.assertEquals((float)24.0f, (float)a[0], (float)1.1920929E-6f);
        CausalFilterTest.assertEquals((float)26.0f, (float)a[1], (float)1.1920929E-6f);
        CausalFilterTest.assertEquals((float)9.0f, (float)a[2], (float)1.1920929E-6f);
        CausalFilterTest.assertEquals((float)1.0f, (float)a[3], (float)1.1920929E-6f);
    }

    public void testFactorLaplacian2() {
        float[][] r = new float[][]{{0.0f, -0.999f, 0.0f}, {-0.999f, 4.0f, -0.999f}, {0.0f, -0.999f, 0.0f}};
        int[] lag1 = new int[]{0, 1, 2, 3, 4, -4, -3, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
        CausalFilter cf = new CausalFilter(lag1, lag2);
        cf.factorWilsonBurg(100, 1.1920929E-7f, r);
        float[][] s = new float[3][3];
        float[][] t = new float[3][3];
        s[1][1] = 1.0f;
        cf.apply(s, t);
        cf.applyTranspose(t, s);
        float emax = 0.01f * r[1][1];
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int i1 = 0; i1 < 3; ++i1) {
                CausalFilterTest.assertEquals((float)r[i2][i1], (float)s[i2][i1], (float)emax);
            }
        }
    }

    public void testFactorLaplacian3() {
        float[][][] r = new float[][][]{new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, -0.999f, 0.0f}, {0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, -0.999f, 0.0f}, {-0.999f, 6.0f, -0.999f}, {0.0f, -0.999f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, -0.999f, 0.0f}, {0.0f, 0.0f, 0.0f}}};
        int[] lag1 = new int[]{0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, 0, 0, 0};
        int[] lag3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        CausalFilter cf = new CausalFilter(lag1, lag2, lag3);
        cf.factorWilsonBurg(100, 1.1920929E-7f, r);
        float[][][] s = new float[3][3][3];
        float[][][] t = new float[3][3][3];
        s[1][1][1] = 1.0f;
        cf.apply(s, t);
        cf.applyTranspose(t, s);
        float emax = 0.01f * r[1][1][1];
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    CausalFilterTest.assertEquals((float)r[i3][i2][i1], (float)s[i3][i2][i1], (float)emax);
                }
            }
        }
    }

    public void xtestFactorPlane2Filter() {
        int[] lag1 = new int[]{0, 1, 2, 3, -3, -2, -1, 0, 1};
        int[] lag2 = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1};
        float[][] s = new float[3][7];
        float[][] t = new float[3][7];
        int maxiter = 100;
        float epsilon = 1.1920929E-7f;
        int ntheta = 2;
        float dtheta = 0.7853982f;
        float ftheta = -0.3926991f;
        CausalFilter cf = new CausalFilter(lag1, lag2);
        for (int itheta = 0; itheta < ntheta; ++itheta) {
            float theta = ftheta + (float)itheta * dtheta;
            float n1 = ArrayMath.cos(theta);
            float n2 = ArrayMath.sin(theta);
            System.out.println("theta=" + theta + " n1=" + n1 + " n2=" + n2);
            float m12 = 0.5f * (n1 - n2);
            float p12 = 0.5f * (n1 + n2);
            float[][] r = new float[][]{{-m12 * m12, -2.0f * m12 * p12, -p12 * p12}, {2.0f * m12 * p12, 1.01f, 2.0f * m12 * p12}, {-p12 * p12, -2.0f * m12 * p12, -m12 * m12}};
            cf.factorWilsonBurg(maxiter, epsilon, r);
            ArrayMath.dump(r);
            ArrayMath.zero(s);
            int k1 = (s[0].length - 1) / 2;
            int k2 = (s.length - 1) / 2;
            s[k2][k1] = 1.0f;
            cf.apply(s, t);
            cf.applyTranspose(t, s);
            ArrayMath.dump(s);
            ArrayMath.dump(t);
        }
    }

    public static void xtestFactorPlane3Filter() {
        int[] lag1 = new int[]{0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3, -3, -2, -1, 0, 1, 2, 3};
        int[] lag2 = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3};
        int[] lag3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        float[][][] s = new float[3][7][7];
        float[][][] t = new float[3][7][7];
        int m = lag1.length;
        float[] amax = new float[m];
        int maxiter = 100;
        float epsilon = 1.1920929E-7f;
        int nphi = 19;
        float dphi = (float)Math.PI * 2 / (float)(nphi - 1);
        float fphi = (float)(-Math.PI);
        int ntheta = 5;
        float dtheta = 1.5707964f / (float)(ntheta - 1);
        float ftheta = 0.0f;
        CausalFilter cf = new CausalFilter(lag1, lag2, lag3);
        for (int iphi = 0; iphi < nphi; ++iphi) {
            float phi = fphi + (float)iphi * dphi;
            for (int itheta = 0; itheta < ntheta; ++itheta) {
                float theta = ftheta + (float)itheta * dtheta;
                float n1 = ArrayMath.cos(theta);
                float n2 = ArrayMath.sin(theta) * ArrayMath.cos(phi);
                float n3 = ArrayMath.sin(theta) * ArrayMath.sin(phi);
                System.out.println("\nphi=" + phi + " theta=" + theta + " n1=" + n1 + " n2=" + n2 + " n3=" + n3);
                float m12 = 0.5f * (n1 - n2);
                float m13 = 0.5f * (n1 - n3);
                float m23 = 0.5f * (n2 - n3);
                float p12 = 0.5f * (n1 + n2);
                float p13 = 0.5f * (n1 + n3);
                float p23 = 0.5f * (n2 + n3);
                float[][][] r = new float[][][]{new float[][]{{0.0f, -m23 * m23, 0.0f}, {-m13 * m13, -2.0f * (m13 * p13 + m23 * p23), -p13 * p13}, {0.0f, -p23 * p23, 0.0f}}, new float[][]{{-m12 * m12, 2.0f * (-m12 * p12 + m23 * p23), -p12 * p12}, {2.0f * (m12 * p12 + m13 * p13), 2.02f, 2.0f * (m12 * p12 + m13 * p13)}, {-p12 * p12, 2.0f * (-m12 * p12 + m23 * p23), -m12 * m12}}, new float[][]{{0.0f, -p23 * p23, 0.0f}, {-p13 * p13, -2.0f * (m13 * p13 + m23 * p23), -m13 * m13}, {0.0f, -m23 * m23, 0.0f}}};
                cf.factorWilsonBurg(maxiter, epsilon, r);
                float[] a = cf.getA();
                for (int j = 0; j < m; ++j) {
                    if (!(ArrayMath.abs(a[j]) > amax[j])) continue;
                    amax[j] = ArrayMath.abs(a[j]);
                }
                ArrayMath.zero(s);
                int k1 = (s[0][0].length - 1) / 2;
                int k2 = (s[0].length - 1) / 2;
                int k3 = (s.length - 1) / 2;
                s[k3][k2][k1] = 1.0f;
                cf.apply(s, t);
                cf.applyTranspose(t, s);
            }
        }
        for (int j = 0; j < m; ++j) {
            System.out.println("lag1=" + lag1[j] + " lag2=" + lag2[j] + " lag3=" + lag3[j] + " amax=" + amax[j]);
        }
    }

    private static float[] rands(int n1) {
        return ArrayMath.sub(ArrayMath.randfloat(n1), 0.5f);
    }

    private static float[][] rands(int n1, int n2) {
        return ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
    }

    private static float[][][] rands(int n1, int n2, int n3) {
        return ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
    }

    private static float[] zeros(int n1) {
        return ArrayMath.zerofloat(n1);
    }

    private static float[][] zeros(int n1, int n2) {
        return ArrayMath.zerofloat(n1, n2);
    }

    private static float[][][] zeros(int n1, int n2, int n3) {
        return ArrayMath.zerofloat(n1, n2, n3);
    }

    private static float dot(float[] x, float[] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][] x, float[][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][][] x, float[][][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static void assertEqual(float[] re, float[] ra) {
        int n = re.length;
        float tolerance = (float)n * 1.1920929E-7f;
        for (int i = 0; i < n; ++i) {
            CausalFilterTest.assertEquals((float)re[i], (float)ra[i], (float)tolerance);
        }
    }

    private static void assertEqual(float[][] re, float[][] ra) {
        int n2 = re.length;
        int n1 = re[0].length;
        float tolerance = (float)(n1 * n2) * 1.1920929E-7f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                CausalFilterTest.assertEquals((float)re[i2][i1], (float)ra[i2][i1], (float)tolerance);
            }
        }
    }

    private static void assertEqual(float[][][] re, float[][][] ra) {
        int n3 = re.length;
        int n2 = re[0].length;
        int n1 = re[0][0].length;
        float tolerance = (float)(n1 * n2 * n3) * 1.1920929E-7f;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    CausalFilterTest.assertEquals((float)re[i3][i2][i1], (float)ra[i3][i2][i1], (float)tolerance);
                }
            }
        }
    }
}

