/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.LocalCausalFilter;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalCausalFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LocalCausalFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Random() {
        int[] lag1 = new int[]{0, 1, 2};
        final float[] ar = new float[]{1.0f, -1.8f, 0.81f};
        final float[] as = new float[]{1.0f, -1.6f, 0.64f};
        LocalCausalFilter lcf = new LocalCausalFilter(lag1);
        LocalCausalFilter.A1 a1 = new LocalCausalFilter.A1(){

            @Override
            public void get(int i1, float[] a) {
                if (i1 % 2 == 0) {
                    a[0] = ar[0];
                    a[1] = ar[1];
                    a[2] = ar[2];
                } else {
                    a[0] = as[0];
                    a[1] = as[1];
                    a[2] = as[2];
                }
            }
        };
        int n = 100;
        float tiny = (float)n * 10.0f * 1.1920929E-7f;
        float[] x = LocalCausalFilterTest.rands(n);
        float[] y = LocalCausalFilterTest.rands(n);
        float[] ax = LocalCausalFilterTest.zeros(n);
        float[] ay = LocalCausalFilterTest.zeros(n);
        lcf.apply(a1, x, ax);
        lcf.applyTranspose(a1, y, ay);
        float dyx = LocalCausalFilterTest.dot(y, ax);
        float dxy = LocalCausalFilterTest.dot(x, ay);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n);
        y = LocalCausalFilterTest.rands(n);
        float[] bx = LocalCausalFilterTest.zeros(n);
        float[] by = LocalCausalFilterTest.zeros(n);
        lcf.applyInverse(a1, x, bx);
        lcf.applyInverseTranspose(a1, y, by);
        dyx = LocalCausalFilterTest.dot(y, bx);
        dxy = LocalCausalFilterTest.dot(x, by);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n);
        y = ArrayMath.copy(x);
        lcf.apply(a1, y, y);
        lcf.applyInverse(a1, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
        x = LocalCausalFilterTest.rands(n);
        y = LocalCausalFilterTest.zeros(n);
        lcf.applyInverseTranspose(a1, x, y);
        lcf.applyTranspose(a1, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
    }

    public void test2Random() {
        int[] lag1 = new int[]{0, 1, 2, 3, 4, -4, -3, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
        float[] aa = new float[]{1.7954845f, -0.64490664f, -0.03850411f, -0.01793403f, -0.00708972f, -0.02290331f, -0.04141619f, -0.08457147f, -0.20031442f, -0.5565992f};
        final float[] ar = ArrayMath.mul(1.0f, aa);
        final float[] as = ArrayMath.mul(2.0f, aa);
        LocalCausalFilter lcf = new LocalCausalFilter(lag1, lag2);
        LocalCausalFilter.A2 a2 = new LocalCausalFilter.A2(){

            @Override
            public void get(int i1, int i2, float[] a) {
                if ((i1 + i2) % 2 == 0) {
                    ArrayMath.copy(ar, a);
                } else {
                    ArrayMath.copy(as, a);
                }
            }
        };
        int n1 = 19;
        int n2 = 21;
        float tiny = (float)(n1 * n2) * 10.0f * 1.1920929E-7f;
        float[][] x = LocalCausalFilterTest.rands(n1, n2);
        float[][] y = LocalCausalFilterTest.rands(n1, n2);
        float[][] ax = LocalCausalFilterTest.zeros(n1, n2);
        float[][] ay = LocalCausalFilterTest.zeros(n1, n2);
        lcf.apply(a2, x, ax);
        lcf.applyTranspose(a2, y, ay);
        float dyx = LocalCausalFilterTest.dot(y, ax);
        float dxy = LocalCausalFilterTest.dot(x, ay);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n1, n2);
        y = LocalCausalFilterTest.rands(n1, n2);
        float[][] bx = LocalCausalFilterTest.zeros(n1, n2);
        float[][] by = LocalCausalFilterTest.zeros(n1, n2);
        lcf.applyInverse(a2, x, bx);
        lcf.applyInverseTranspose(a2, y, by);
        dyx = LocalCausalFilterTest.dot(y, bx);
        dxy = LocalCausalFilterTest.dot(x, by);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n1, n2);
        y = ArrayMath.copy(x);
        lcf.apply(a2, y, y);
        lcf.applyInverse(a2, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
        x = LocalCausalFilterTest.rands(n1, n2);
        y = LocalCausalFilterTest.zeros(n1, n2);
        lcf.applyInverseTranspose(a2, x, y);
        lcf.applyTranspose(a2, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
    }

    public void test3Random() {
        int[] lag1 = new int[]{0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0};
        int[] lag2 = new int[]{0, 0, 0, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, 0, 0, 0};
        int[] lag3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        float[] aa = new float[]{2.3110454f, -0.4805547f, -0.0143204f, -0.0291793f, -0.1057476f, -0.4572746f, -0.0115732f, -0.0047283f, -0.0149963f, -0.0408317f, -0.0945958f, -0.0223166f, -0.0062781f, -0.0213786f, -0.0898909f, -0.4322719f};
        final float[] ar = ArrayMath.mul(1.0f, aa);
        final float[] as = ArrayMath.mul(2.0f, aa);
        LocalCausalFilter lcf = new LocalCausalFilter(lag1, lag2, lag3);
        LocalCausalFilter.A3 a3 = new LocalCausalFilter.A3(){

            @Override
            public void get(int i1, int i2, int i3, float[] a) {
                if ((i1 + i2 + i3) % 2 == 0) {
                    ArrayMath.copy(ar, a);
                } else {
                    ArrayMath.copy(as, a);
                }
            }
        };
        int n1 = 11;
        int n2 = 13;
        int n3 = 12;
        float tiny = (float)(n1 * n2 * n3) * 10.0f * 1.1920929E-7f;
        float[][][] x = LocalCausalFilterTest.rands(n1, n2, n3);
        float[][][] y = LocalCausalFilterTest.rands(n1, n2, n3);
        float[][][] ax = LocalCausalFilterTest.zeros(n1, n2, n3);
        float[][][] ay = LocalCausalFilterTest.zeros(n1, n2, n3);
        lcf.apply(a3, x, ax);
        lcf.applyTranspose(a3, y, ay);
        float dyx = LocalCausalFilterTest.dot(y, ax);
        float dxy = LocalCausalFilterTest.dot(x, ay);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n1, n2, n3);
        y = LocalCausalFilterTest.rands(n1, n2, n3);
        float[][][] bx = LocalCausalFilterTest.zeros(n1, n2, n3);
        float[][][] by = LocalCausalFilterTest.zeros(n1, n2, n3);
        lcf.applyInverse(a3, x, bx);
        lcf.applyInverseTranspose(a3, y, by);
        dyx = LocalCausalFilterTest.dot(y, bx);
        dxy = LocalCausalFilterTest.dot(x, by);
        LocalCausalFilterTest.assertEquals((float)dyx, (float)dxy, (float)tiny);
        x = LocalCausalFilterTest.rands(n1, n2, n3);
        y = ArrayMath.copy(x);
        lcf.apply(a3, y, y);
        lcf.applyInverse(a3, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
        x = LocalCausalFilterTest.rands(n1, n2, n3);
        y = LocalCausalFilterTest.zeros(n1, n2, n3);
        lcf.applyInverseTranspose(a3, x, y);
        lcf.applyTranspose(a3, y, y);
        LocalCausalFilterTest.assertEqual(x, y);
    }

    private static float[] rands(int n1) {
        return ArrayMath.sub(ArrayMath.randfloat(n1), 0.5f);
    }

    private static float[][] rands(int n1, int n2) {
        return ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
    }

    private static float[][][] rands(int n1, int n2, int n3) {
        return ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
    }

    private static float[] zeros(int n1) {
        return ArrayMath.zerofloat(n1);
    }

    private static float[][] zeros(int n1, int n2) {
        return ArrayMath.zerofloat(n1, n2);
    }

    private static float[][][] zeros(int n1, int n2, int n3) {
        return ArrayMath.zerofloat(n1, n2, n3);
    }

    private static float dot(float[] x, float[] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][] x, float[][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static float dot(float[][][] x, float[][][] y) {
        return ArrayMath.sum(ArrayMath.mul(x, y));
    }

    private static void assertEqual(float[] re, float[] ra) {
        int n = re.length;
        float tolerance = (float)n * 1.1920929E-7f;
        for (int i = 0; i < n; ++i) {
            LocalCausalFilterTest.assertEquals((float)re[i], (float)ra[i], (float)tolerance);
        }
    }

    private static void assertEqual(float[][] re, float[][] ra) {
        int n2 = re.length;
        int n1 = re[0].length;
        float tolerance = (float)(n1 * n2) * 1.1920929E-7f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                LocalCausalFilterTest.assertEquals((float)re[i2][i1], (float)ra[i2][i1], (float)tolerance);
            }
        }
    }

    private static void assertEqual(float[][][] re, float[][][] ra) {
        int n3 = re.length;
        int n2 = re[0].length;
        int n1 = re[0][0].length;
        float tolerance = (float)(n1 * n2 * n3) * 1.1920929E-7f;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    LocalCausalFilterTest.assertEquals((float)re[i3][i2][i1], (float)ra[i3][i2][i1], (float)tolerance);
                }
            }
        }
    }
}

