/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class TrilinearInterpolator3 {
    private float[] _x1;
    private float[] _x2;
    private float[] _x3;
    private float[][][] _a000;
    private float[][][] _a100;
    private float[][][] _a010;
    private float[][][] _a001;
    private float[][][] _a110;
    private float[][][] _a101;
    private float[][][] _a011;
    private float[][][] _a111;
    private int[] _ks = new int[]{0, 0, 0};

    public TrilinearInterpolator3(float[] x1, float[] x2, float[] x3, float[][][] y) {
        this(x1.length, x2.length, x3.length, x1, x2, x3, y);
    }

    public TrilinearInterpolator3(int n1, int n2, int n3, float[] x1, float[] x2, float[] x3, float[][][] y) {
        Check.argument(ArrayMath.isMonotonic(x1), "array x1 is monotonic");
        Check.argument(ArrayMath.isMonotonic(x2), "array x2 is monotonic");
        Check.argument(ArrayMath.isMonotonic(x3), "array x3 is monotonic");
        this._x1 = ArrayMath.copy(n1, x1);
        this._x2 = ArrayMath.copy(n2, x2);
        this._x3 = ArrayMath.copy(n3, x3);
        this.makeCoefficients(x1, x2, x3, y);
    }

    public float interpolate(float x1, float x2, float x3) {
        return this.interpolate000(x1, x2, x3);
    }

    public float interpolate000(float x1, float x2, float x3) {
        return this.interpolate000(x1, x2, x3, this._ks);
    }

    public float interpolate100(float x1, float x2, float x3) {
        return this.interpolate100(x1, x2, x3, this._ks);
    }

    public float interpolate010(float x1, float x2, float x3) {
        return this.interpolate010(x1, x2, x3, this._ks);
    }

    public float interpolate001(float x1, float x2, float x3) {
        return this.interpolate001(x1, x2, x3, this._ks);
    }

    public float[][][] interpolate(Sampling s1, Sampling s2, Sampling s3) {
        return this.interpolate000(s1, s2, s3);
    }

    public float[][][] interpolate000(Sampling s1, Sampling s2, Sampling s3) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        float[][][] y = new float[n3][n2][n1];
        this.interpolate000(s1, s2, s3, y);
        return y;
    }

    public void interpolate(Sampling s1, Sampling s2, Sampling s3, float[][][] y) {
        this.interpolate000(s1, s2, s3, y);
    }

    public void interpolate000(Sampling s1, Sampling s2, Sampling s3, float[][][] y) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        int[] k1 = TrilinearInterpolator3.makeIndices(s1, this._x1);
        int[] k2 = TrilinearInterpolator3.makeIndices(s2, this._x2);
        int[] k3 = TrilinearInterpolator3.makeIndices(s3, this._x3);
        for (int i3 = 0; i3 < n3; ++i3) {
            float x3 = (float)s3.getValue(i3);
            for (int i2 = 0; i2 < n2; ++i2) {
                float x2 = (float)s2.getValue(i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    float x1 = (float)s1.getValue(i1);
                    y[i3][i2][i1] = this.interpolate000(x1, x2, x3, k1[i1], k2[i2], k3[i3]);
                }
            }
        }
    }

    public float[][][] interpolate(float[] x1, float[] x2, float[] x3) {
        return this.interpolate000(x1, x2, x3);
    }

    public float[][][] interpolate000(float[] x1, float[] x2, float[] x3) {
        int n1 = x1.length;
        int n2 = x2.length;
        int n3 = x3.length;
        float[][][] y = new float[n3][n2][n1];
        this.interpolate000(x1, x2, x3, y);
        return y;
    }

    public void interpolate(float[] x1, float[] x2, float[] x3, float[][][] y) {
        this.interpolate000(x1, x2, x3, y);
    }

    public void interpolate000(float[] x1, float[] x2, float[] x3, float[][][] y) {
        int n1 = x1.length;
        int n2 = x2.length;
        int n3 = x3.length;
        int[] k1 = TrilinearInterpolator3.makeIndices(x1, this._x1);
        int[] k2 = TrilinearInterpolator3.makeIndices(x2, this._x2);
        int[] k3 = TrilinearInterpolator3.makeIndices(x3, this._x3);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i3][i2][i1] = this.interpolate000(x1[i1], x2[i2], x3[i3], k1[i1], k2[i2], k3[i3]);
                }
            }
        }
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private static int index(float x, float[] xs, int i) {
        if ((i = ArrayMath.binarySearch(xs, x, i)) < 0) {
            int n = i = i < -1 ? -2 - i : 0;
        }
        if (i >= xs.length - 1) {
            i = xs.length - 2;
        }
        return i;
    }

    private void updateIndices(float x1, float x2, float x3, int[] ks) {
        ks[0] = TrilinearInterpolator3.index(x1, this._x1, ks[0]);
        ks[1] = TrilinearInterpolator3.index(x2, this._x2, ks[1]);
        ks[2] = TrilinearInterpolator3.index(x3, this._x3, ks[2]);
    }

    private static int[] makeIndices(float[] xi, float[] xs) {
        int n = xi.length;
        int[] ki = new int[n];
        ki[0] = TrilinearInterpolator3.index(xi[0], xs, 0);
        for (int i = 1; i < n; ++i) {
            ki[i] = TrilinearInterpolator3.index(xi[i], xs, ki[i - 1]);
        }
        return ki;
    }

    private static int[] makeIndices(Sampling si, float[] xs) {
        int n = si.getCount();
        int[] ki = new int[n];
        ki[0] = TrilinearInterpolator3.index((float)si.getValue(0), xs, 0);
        for (int i = 1; i < n; ++i) {
            ki[i] = TrilinearInterpolator3.index((float)si.getValue(i), xs, ki[i - 1]);
        }
        return ki;
    }

    private float interpolate000(float x1, float x2, float x3, int[] ks) {
        this.updateIndices(x1, x2, x3, ks);
        return this.interpolate000(x1, x2, x3, ks[0], ks[1], ks[2]);
    }

    private float interpolate100(float x1, float x2, float x3, int[] ks) {
        this.updateIndices(x1, x2, x3, ks);
        return this.interpolate100(x1, x2, x3, ks[0], ks[1], ks[2]);
    }

    private float interpolate010(float x1, float x2, float x3, int[] ks) {
        this.updateIndices(x1, x2, x3, ks);
        return this.interpolate010(x1, x2, x3, ks[0], ks[1], ks[2]);
    }

    private float interpolate001(float x1, float x2, float x3, int[] ks) {
        this.updateIndices(x1, x2, x3, ks);
        return this.interpolate001(x1, x2, x3, ks[0], ks[1], ks[2]);
    }

    private float interpolate000(float x1, float x2, float x3, int k1, int k2, int k3) {
        float d1 = x1 - this._x1[k1];
        float d2 = x2 - this._x2[k2];
        float d3 = x3 - this._x3[k3];
        return this._a000[k3][k2][k1] + d1 * (this._a100[k3][k2][k1] + d3 * this._a101[k3][k2][k1]) + d2 * (this._a010[k3][k2][k1] + d1 * this._a110[k3][k2][k1]) + d3 * (this._a001[k3][k2][k1] + d2 * (this._a011[k3][k2][k1] + d1 * this._a111[k3][k2][k1]));
    }

    private float interpolate100(float x1, float x2, float x3, int k1, int k2, int k3) {
        float d2 = x2 - this._x2[k2];
        float d3 = x3 - this._x3[k3];
        return this._a100[k3][k2][k1] + d2 * this._a110[k3][k2][k1] + d3 * (this._a101[k3][k2][k1] + d2 * this._a111[k3][k2][k1]);
    }

    private float interpolate010(float x1, float x2, float x3, int k1, int k2, int k3) {
        float d1 = x1 - this._x1[k1];
        float d3 = x3 - this._x3[k3];
        return this._a010[k3][k2][k1] + d1 * this._a110[k3][k2][k1] + d3 * (this._a011[k3][k2][k1] + d1 * this._a111[k3][k2][k1]);
    }

    private float interpolate001(float x1, float x2, float x3, int k1, int k2, int k3) {
        float d1 = x1 - this._x1[k1];
        float d2 = x2 - this._x2[k2];
        return this._a001[k3][k2][k1] + d1 * this._a101[k3][k2][k1] + d2 * (this._a011[k3][k2][k1] + d1 * this._a111[k3][k2][k1]);
    }

    private void makeCoefficients(float[] x1, float[] x2, float[] x3, float[][][] y) {
        int n1 = x1.length;
        int n2 = x2.length;
        int n3 = x3.length;
        this._a000 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a100 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a010 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a001 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a110 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a101 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a011 = new float[n3 - 1][n2 - 1][n1 - 1];
        this._a111 = new float[n3 - 1][n2 - 1][n1 - 1];
        for (int k3 = 0; k3 < n3 - 1; ++k3) {
            float d3 = x3[k3 + 1] - x3[k3];
            for (int k2 = 0; k2 < n2 - 1; ++k2) {
                float d2 = x2[k2 + 1] - x2[k2];
                for (int k1 = 0; k1 < n1 - 1; ++k1) {
                    float d1 = x1[k1 + 1] - x1[k1];
                    float y000 = y[k3][k2][k1];
                    float y100 = y[k3][k2][k1 + 1];
                    float y010 = y[k3][k2 + 1][k1];
                    float y001 = y[k3 + 1][k2][k1];
                    float y110 = y[k3][k2 + 1][k1 + 1];
                    float y101 = y[k3 + 1][k2][k1 + 1];
                    float y011 = y[k3 + 1][k2 + 1][k1];
                    float y111 = y[k3 + 1][k2 + 1][k1 + 1];
                    this._a000[k3][k2][k1] = y000;
                    this._a100[k3][k2][k1] = (y100 - y000) / d1;
                    this._a010[k3][k2][k1] = (y010 - y000) / d2;
                    this._a001[k3][k2][k1] = (y001 - y000) / d3;
                    this._a110[k3][k2][k1] = (y000 - y100 + y110 - y010) / (d1 * d2);
                    this._a101[k3][k2][k1] = (y000 - y100 + y101 - y001) / (d1 * d3);
                    this._a011[k3][k2][k1] = (y000 - y010 + y011 - y001) / (d2 * d3);
                    this._a111[k3][k2][k1] = (y111 - y000 + y100 - y011 + y010 - y101 + y001 - y110) / (d1 * d2 * d3);
                }
            }
        }
    }
}

