/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayInput;
import edu.mines.jtk.io.ArrayInputAdapter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class ArrayInputStream
extends FilterInputStream
implements ArrayInput {
    private DataInputStream _dis;
    private ArrayInput _ai;
    private ByteOrder _bo;

    public ArrayInputStream(InputStream is) {
        this(is, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputStream(FileInputStream fis) {
        this(fis, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputStream(String name) throws FileNotFoundException {
        this(new FileInputStream(name));
    }

    public ArrayInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public ArrayInputStream(InputStream is, ByteOrder bo) {
        super(is);
        this._dis = new DataInputStream(new BufferedInputStream(is));
        this._ai = new ArrayInputAdapter(this._dis, bo);
        this._bo = bo;
    }

    public ArrayInputStream(String name, ByteOrder bo) throws FileNotFoundException {
        this(new FileInputStream(name), bo);
    }

    public ArrayInputStream(File file, ByteOrder bo) throws FileNotFoundException {
        this(new FileInputStream(file), bo);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this._ai.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this._ai.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this._ai.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this._ai.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this._ai.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this._ai.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this._ai.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this._ai.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this._ai.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this._ai.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this._ai.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this._ai.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this._ai.readDouble();
    }

    @Override
    public final String readLine() throws IOException {
        return this._ai.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this._ai.readUTF();
    }

    @Override
    public void readBytes(byte[] v, int k, int n) throws IOException {
        this._ai.readBytes(v, k, n);
    }

    @Override
    public void readBytes(byte[] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readBytes(byte[][] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readBytes(byte[][][] v) throws IOException {
        this._ai.readBytes(v);
    }

    @Override
    public void readChars(char[] v, int k, int n) throws IOException {
        this._ai.readChars(v, k, n);
    }

    @Override
    public void readChars(char[] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readChars(char[][] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readChars(char[][][] v) throws IOException {
        this._ai.readChars(v);
    }

    @Override
    public void readShorts(short[] v, int k, int n) throws IOException {
        this._ai.readShorts(v, k, n);
    }

    @Override
    public void readShorts(short[] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readShorts(short[][] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readShorts(short[][][] v) throws IOException {
        this._ai.readShorts(v);
    }

    @Override
    public void readInts(int[] v, int k, int n) throws IOException {
        this._ai.readInts(v, k, n);
    }

    @Override
    public void readInts(int[] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readInts(int[][] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readInts(int[][][] v) throws IOException {
        this._ai.readInts(v);
    }

    @Override
    public void readLongs(long[] v, int k, int n) throws IOException {
        this._ai.readLongs(v, k, n);
    }

    @Override
    public void readLongs(long[] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readLongs(long[][] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readLongs(long[][][] v) throws IOException {
        this._ai.readLongs(v);
    }

    @Override
    public void readFloats(float[] v, int k, int n) throws IOException {
        this._ai.readFloats(v, k, n);
    }

    @Override
    public void readFloats(float[] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readFloats(float[][] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readFloats(float[][][] v) throws IOException {
        this._ai.readFloats(v);
    }

    @Override
    public void readDoubles(double[] v, int k, int n) throws IOException {
        this._ai.readDoubles(v, k, n);
    }

    @Override
    public void readDoubles(double[] v) throws IOException {
        this._ai.readDoubles(v);
    }

    @Override
    public void readDoubles(double[][] v) throws IOException {
        this._ai.readDoubles(v);
    }

    @Override
    public void readDoubles(double[][][] v) throws IOException {
        this._ai.readDoubles(v);
    }
}

