/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.util.Check;

public class DMatrixQrd {
    int _m;
    int _n;
    double[][] _qr;
    double[] _rdiag;

    public DMatrixQrd(DMatrix a) {
        Check.argument(a.getM() >= a.getN(), "m >= n");
        int m = this._m = a.getM();
        int n = this._n = a.getN();
        this._qr = a.get();
        this._rdiag = new double[this._n];
        for (int k = 0; k < n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < m; ++i) {
                nrm = Math.hypot(nrm, this._qr[i][k]);
            }
            if (nrm != 0.0) {
                if (this._qr[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < m; ++i) {
                    double[] dArray = this._qr[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] / nrm;
                }
                double[] dArray = this._qr[k];
                int n3 = k;
                dArray[n3] = dArray[n3] + 1.0;
                for (int j = k + 1; j < n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        s += this._qr[i2][k] * this._qr[i2][j];
                    }
                    s = -s / this._qr[k][k];
                    for (i2 = k; i2 < m; ++i2) {
                        double[] dArray2 = this._qr[i2];
                        int n4 = j;
                        dArray2[n4] = dArray2[n4] + s * this._qr[i2][k];
                    }
                }
            }
            this._rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this._n; ++j) {
            if (this._rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public DMatrix getQ() {
        double[][] q = new double[this._m][this._n];
        for (int k = this._n - 1; k >= 0; --k) {
            for (int i = 0; i < this._m; ++i) {
                q[i][k] = 0.0;
            }
            q[k][k] = 1.0;
            for (int j = k; j < this._n; ++j) {
                int i;
                if (this._qr[k][k] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this._m; ++i) {
                    s += this._qr[i][k] * q[i][j];
                }
                s = -s / this._qr[k][k];
                for (i = k; i < this._m; ++i) {
                    double[] dArray = q[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this._qr[i][k];
                }
            }
        }
        return new DMatrix(this._m, this._n, q);
    }

    public DMatrix getR() {
        double[][] r = new double[this._n][this._n];
        for (int i = 0; i < this._n; ++i) {
            r[i][i] = this._rdiag[i];
            for (int j = i + 1; j < this._n; ++j) {
                r[i][j] = this._qr[i][j];
            }
        }
        return new DMatrix(this._n, this._n, r);
    }

    public DMatrix solve(DMatrix b) {
        int j;
        int k;
        Check.argument(b.getM() == this._m, "A and B have the same number of rows");
        Check.state(this.isFullRank(), "A is of full rank");
        int nx = b.getN();
        double[][] x = b.get();
        for (k = 0; k < this._n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this._m; ++i) {
                    s += this._qr[i][k] * x[i][j];
                }
                s = -s / this._qr[k][k];
                for (i = k; i < this._m; ++i) {
                    double[] dArray = x[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this._qr[i][k];
                }
            }
        }
        for (k = this._n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = x[k];
                int n = j++;
                dArray[n] = dArray[n] / this._rdiag[k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = x[i];
                    int n = j2;
                    dArray[n] = dArray[n] - x[k][j2] * this._qr[i][k];
                }
            }
        }
        return new DMatrix(this._m, nx, x).get(0, this._n - 1, null);
    }
}

