/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.scijava.command.CommandService;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.MenuBar;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.plugin.LabkitProbabilityMapForImagesInDirectoryPlugin;
import sc.fiji.labkit.ui.plugin.LabkitSegmentImagesInDirectoryPlugin;

public class BatchSegmentAction {
    private final Extensible extensible;
    private final Holder<SegmentationItem> selectedSegmenter;

    public BatchSegmentAction(Extensible extensible, Holder<SegmentationItem> selectedSegmenter) {
        this.extensible = extensible;
        this.selectedSegmenter = selectedSegmenter;
        extensible.addMenuItem(MenuBar.OTHERS_MENU, "Batch Segment Images ...", 0.0f, ignore -> this.segmentImages(), null, "");
        extensible.addMenuItem(MenuBar.OTHERS_MENU, "Batch Calculate Probability Maps for Images ...", 1.0f, ignore -> this.calculateProbibilityMaps(), null, "");
    }

    private void segmentImages() {
        CommandService command = (CommandService)this.extensible.context().service(CommandService.class);
        command.run(LabkitSegmentImagesInDirectoryPlugin.class, true, new Object[]{"segmenter_file", this.createClassifierFile()});
    }

    private void calculateProbibilityMaps() {
        CommandService command = (CommandService)this.extensible.context().service(CommandService.class);
        command.run(LabkitProbabilityMapForImagesInDirectoryPlugin.class, true, new Object[]{"segmenter_file", this.createClassifierFile()});
    }

    private String createClassifierFile() {
        try {
            SegmentationItem segmenter = this.selectedSegmenter.get();
            if (!segmenter.isModified()) {
                return segmenter.getFileName();
            }
            String tmp = Files.createTempFile("labkit-pixel-classifier", ".classifier", new FileAttribute[0]).toFile().toString();
            segmenter.saveModel(tmp);
            return tmp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

