/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sc.fiji.labkit.ui.Preferences;
import sc.fiji.labkit.ui.SegmentationComponent;

public class SetLabelsAction {
    private final Preferences preference;
    private final SegmentationComponent segmentationComponent;

    public SetLabelsAction(SegmentationComponent segmentationComponent, Preferences preferences) {
        this.segmentationComponent = segmentationComponent;
        this.preference = preferences;
        this.addAction("Available Labels On Start Up ...", "defaultLabels", this::defaultLabels);
    }

    private void addAction(String title, String command, Runnable action) {
    }

    private void defaultLabels() {
        Optional<List<String>> result = SetLabelsAction.dialog(this.preference.getDefaultLabels());
        result.ifPresent(this.preference::setDefaultLabels);
    }

    private static Optional<List<String>> dialog(List<String> labels) {
        JTextArea textArea = new JTextArea();
        StringJoiner joiner = new StringJoiner("\n");
        labels.forEach(joiner::add);
        textArea.setPreferredSize(new Dimension(200, 200));
        textArea.setText(joiner.toString());
        int result = JOptionPane.showConfirmDialog(null, new Object[]{"When Labkit is started the first time for an image,\nthese labels will be available:", new JScrollPane(textArea)}, "Labels On Start Up", 2, -1);
        if (result == 0) {
            return Optional.of(Arrays.asList(textArea.getText().split("\n")));
        }
        return Optional.empty();
    }

    public static void main(String ... args) {
        Optional<List<String>> result = SetLabelsAction.dialog(Arrays.asList("Hello", "World"));
        System.out.println(result);
    }
}

