/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.BlockWriter;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Writer;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.cache.N5JsonCache;
import org.janelia.saalfeldlab.n5.zarr.DType;
import org.janelia.saalfeldlab.n5.zarr.N5ZarrReader;
import org.janelia.saalfeldlab.n5.zarr.ZArrayAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrCompressor;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;

public class ZarrKeyValueWriter
extends ZarrKeyValueReader
implements CachedGsonKeyValueN5Writer {
    protected String dimensionSeparator;

    public ZarrKeyValueWriter(KeyValueAccess keyValueAccess, String basePath, GsonBuilder gsonBuilder, boolean mapN5DatasetAttributes, boolean mergeAttributes, String dimensionSeparator, boolean cacheAttributes) throws N5Exception {
        super(false, keyValueAccess, basePath, gsonBuilder, mapN5DatasetAttributes, mergeAttributes, cacheAttributes, false);
        this.dimensionSeparator = dimensionSeparator;
        N5Reader.Version version = null;
        if (this.exists("/") && !ZarrKeyValueReader.VERSION.isCompatible(version = this.getVersion())) {
            throw new N5Exception.N5IOException("Incompatible version " + version + " (this is " + ZarrKeyValueReader.VERSION + ").");
        }
        if (version == null || version == VERSION_ZERO) {
            this.createGroup("/");
            this.setVersion("/");
        }
    }

    public void setVersion(String path) throws N5Exception {
        this.setVersion(path, false);
    }

    protected void setVersion(String path, boolean create) throws N5Exception {
        JsonObject versionObject = new JsonObject();
        versionObject.add("zarr_format", (JsonElement)new JsonPrimitive((Number)N5ZarrReader.VERSION.getMajor()));
        String normalPath = N5URI.normalizeGroupPath((String)path);
        if (create || this.groupExists(normalPath)) {
            this.writeZGroup(normalPath, (JsonElement)versionObject);
        } else if (this.datasetExists(normalPath)) {
            JsonObject zarrayJson = this.getZArray(normalPath).getAsJsonObject();
            zarrayJson.add("zarr_format", (JsonElement)new JsonPrimitive((Number)N5ZarrReader.VERSION.getMajor()));
            this.writeZArray(normalPath, (JsonElement)zarrayJson);
        }
    }

    protected void initializeGroup(String normalPath) throws N5Exception {
        String[] components = this.keyValueAccess.components(normalPath);
        String path = "";
        for (int i = 0; i < components.length; ++i) {
            path = this.keyValueAccess.compose(new String[]{path, components[i]});
            this.setVersion(path, true);
        }
    }

    public void createGroup(String path) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath((String)path);
        if (this.cacheMeta()) {
            if (this.getCache().isGroup(normalPath, ".zgroup")) {
                return;
            }
            if (this.getCache().isDataset(normalPath, ".zarray")) {
                throw new N5Exception("Can't make a group on existing dataset.");
            }
        }
        try {
            this.keyValueAccess.createDirectories(this.absoluteGroupPath(normalPath));
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to create group " + path, e);
        }
        JsonObject versionObject = new JsonObject();
        versionObject.add("zarr_format", (JsonElement)new JsonPrimitive((Number)N5ZarrReader.VERSION.getMajor()));
        String[] pathParts = this.getKeyValueAccess().components(normalPath);
        String parent = N5URI.normalizeGroupPath((String)"/");
        if (pathParts.length == 0) {
            pathParts = new String[]{""};
        }
        for (String child : pathParts) {
            String childPath;
            String string = childPath = parent.isEmpty() ? child : parent + "/" + child;
            if (this.cacheMeta()) {
                this.getCache().initializeNonemptyCache(childPath, ".zgroup");
                this.getCache().updateCacheInfo(childPath, ".zgroup", (JsonElement)versionObject);
                if (parent != null && !child.isEmpty()) {
                    this.getCache().addChildIfPresent(parent, child);
                }
            }
            this.setVersion(childPath, true);
            parent = childPath;
        }
    }

    public void createDataset(String path, DatasetAttributes datasetAttributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath((String)path);
        boolean wasGroup = false;
        if (this.cacheMeta()) {
            if (this.getCache().isDataset(normalPath, ".zarray")) {
                return;
            }
            if (this.getCache().isGroup(normalPath, ".zgroup")) {
                wasGroup = true;
            }
        }
        String absPath = this.absoluteGroupPath(normalPath);
        try {
            this.keyValueAccess.createDirectories(absPath);
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to create directories " + absPath, e);
        }
        String[] pathParts = this.keyValueAccess.components(normalPath);
        String parent = Arrays.stream(pathParts).limit(pathParts.length - 1).collect(Collectors.joining("/"));
        this.createGroup(parent);
        ZArrayAttributes zarray = this.createZArrayAttributes(datasetAttributes);
        HashMap<String, Object> zarrayMap = zarray.asMap();
        JsonElement attributes = this.gson.toJsonTree(zarrayMap);
        this.writeJsonResource(normalPath, ".zarray", zarrayMap);
        if (wasGroup) {
            this.deleteJsonResource(normalPath, ".zgroup");
        }
        if (this.cacheMeta()) {
            this.getCache().initializeNonemptyCache(normalPath, ".zarray");
            this.getCache().updateCacheInfo(normalPath, ".zarray", attributes);
            if (this.getCache().isDataset(normalPath, ".zarray") && wasGroup) {
                this.getCache().updateCacheInfo(normalPath, ".zgroup", (JsonElement)N5JsonCache.emptyJson);
            }
            this.getCache().addChildIfPresent(parent, pathParts[pathParts.length - 1]);
        }
    }

    public void setAttributes(String path, Map<String, ?> attributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath((String)path);
        if (!this.exists(normalPath)) {
            throw new N5Exception.N5IOException("" + normalPath + " is not a group or dataset.");
        }
        JsonElement existingAttributes = this.getAttributesUnmapped(normalPath);
        JsonObject newAttributes = existingAttributes != null && existingAttributes.isJsonObject() ? existingAttributes.getAsJsonObject() : new JsonObject();
        if ((newAttributes = GsonUtils.insertAttributes((JsonElement)newAttributes, attributes, (Gson)this.gson)).isJsonObject()) {
            ZarrJsonElements zje = ZarrKeyValueWriter.build(newAttributes.getAsJsonObject(), this.getGson(), this.mapN5DatasetAttributes);
            this.writeZArray(normalPath, (JsonElement)zje.zarray);
            this.writeZAttrs(normalPath, (JsonElement)zje.zattrs);
            this.writeZGroup(normalPath, (JsonElement)zje.zgroup);
        } else {
            this.writeZAttrs(normalPath, (JsonElement)newAttributes);
        }
    }

    public boolean removeAttribute(String pathName, String key) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath((String)pathName);
        String normalKey = N5URI.normalizeAttributePath((String)key);
        if (!this.keyValueAccess.exists(this.keyValueAccess.compose(this.uri, new String[]{normalPath, ".zattrs"}))) {
            return false;
        }
        if (key.equals("/")) {
            this.writeJsonResource(normalPath, ".zattrs", JsonNull.INSTANCE);
            if (this.cacheMeta()) {
                this.cache.updateCacheInfo(normalPath, ".zattrs", (JsonElement)JsonNull.INSTANCE);
            }
            return true;
        }
        JsonElement attributes = this.getZAttributes(normalPath);
        if (GsonUtils.removeAttribute((JsonElement)attributes, (String)normalKey) != null) {
            if (this.cacheMeta()) {
                this.cache.updateCacheInfo(normalPath, ".zattrs", attributes);
            }
            this.writeJsonResource(normalPath, ".zattrs", attributes);
            return true;
        }
        return false;
    }

    public <T> T removeAttribute(String pathName, String key, Class<T> cls) throws N5Exception {
        Object obj;
        String normalPath = N5URI.normalizeGroupPath((String)pathName);
        String normalKey = N5URI.normalizeAttributePath((String)key);
        JsonElement attributes = this.getZAttributes(normalPath);
        try {
            obj = GsonUtils.removeAttribute((JsonElement)attributes, (String)normalKey, cls, (Gson)this.gson);
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
        if (obj != null) {
            if (this.cacheMeta()) {
                this.cache.updateCacheInfo(normalPath, ".zattrs", attributes);
            }
            this.writeJsonResource(normalPath, ".zattrs", attributes);
        }
        return (T)obj;
    }

    public void setDatasetAttributes(String pathName, DatasetAttributes datasetAttributes) throws N5Exception {
        this.setZArrayAttributes(pathName, this.createZArrayAttributes(datasetAttributes));
    }

    protected ZArrayAttributes createZArrayAttributes(DatasetAttributes datasetAttributes) {
        long[] shape = (long[])datasetAttributes.getDimensions().clone();
        ZarrKeyValueWriter.reorder(shape);
        int[] chunks = (int[])datasetAttributes.getBlockSize().clone();
        ZarrKeyValueWriter.reorder(chunks);
        DType dType = new DType(datasetAttributes.getDataType());
        ZArrayAttributes zArrayAttributes = new ZArrayAttributes(N5ZarrReader.VERSION.getMajor(), shape, chunks, dType, ZarrCompressor.fromCompression(datasetAttributes.getCompression()), "0", 'C', this.dimensionSeparator, dType.getFilters());
        return zArrayAttributes;
    }

    public void setZArrayAttributes(String pathName, ZArrayAttributes attributes) throws N5Exception {
        this.writeZArray(pathName, this.gson.toJsonTree(attributes.asMap()));
    }

    protected void setZGroup(String pathName, N5Reader.Version version) throws IOException {
        this.writeZGroup(pathName, this.gson.toJsonTree((Object)version));
    }

    protected void deleteJsonResource(String normalPath, String jsonName) throws N5Exception {
        String absolutePath = this.keyValueAccess.compose(this.uri, new String[]{normalPath, jsonName});
        try {
            this.keyValueAccess.delete(absolutePath);
        }
        catch (Throwable e1) {
            throw new N5Exception.N5IOException("Failed to delete " + absolutePath, e1);
        }
    }

    protected void writeJsonResource(String normalPath, String jsonName, Object attributes) throws N5Exception {
        if (attributes == null) {
            return;
        }
        String absolutePath = this.keyValueAccess.compose(this.uri, new String[]{normalPath, jsonName});
        try (LockedChannel lock = this.keyValueAccess.lockForWriting(absolutePath);){
            Writer writer = lock.newWriter();
            this.gson.toJson(attributes, (Appendable)writer);
            writer.flush();
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to write " + absolutePath, e);
        }
    }

    protected void writeZArray(String normalGroupPath, JsonElement attributes) throws N5Exception {
        if (attributes == null) {
            return;
        }
        this.writeJsonResource(normalGroupPath, ".zarray", this.gson.fromJson(attributes, ZArrayAttributes.class));
        if (this.cacheMeta()) {
            this.cache.updateCacheInfo(normalGroupPath, ".zarray", attributes);
        }
    }

    protected void writeZGroup(String normalGroupPath, JsonElement attributes) throws N5Exception {
        if (attributes == null) {
            return;
        }
        this.writeJsonResource(normalGroupPath, ".zgroup", attributes);
        if (this.cacheMeta()) {
            this.cache.updateCacheInfo(normalGroupPath, ".zgroup", attributes);
        }
    }

    protected void writeZAttrs(String normalGroupPath, JsonElement attributes) throws N5Exception {
        if (attributes == null) {
            return;
        }
        this.writeJsonResource(normalGroupPath, ".zattrs", attributes);
        if (this.cacheMeta()) {
            this.cache.updateCacheInfo(normalGroupPath, ".zattrs", attributes);
        }
    }

    public static <T> void writeBlock(OutputStream out, ZarrDatasetAttributes datasetAttributes, DataBlock<T> dataBlock) throws IOException {
        int[] blockSize = datasetAttributes.getBlockSize();
        DType dType = datasetAttributes.getDType();
        BlockWriter writer = datasetAttributes.getCompression().getWriter();
        if (!Arrays.equals(blockSize, dataBlock.getSize())) {
            byte[] padCropped = ZarrKeyValueWriter.padCrop(dataBlock.toByteBuffer().array(), dataBlock.getSize(), blockSize, dType.getNBytes(), dType.getNBits(), datasetAttributes.getFillBytes());
            ByteArrayDataBlock padCroppedDataBlock = new ByteArrayDataBlock(blockSize, dataBlock.getGridPosition(), padCropped);
            writer.write((DataBlock)padCroppedDataBlock, out);
        } else {
            writer.write(dataBlock, out);
        }
    }

    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) throws N5Exception {
        ZarrDatasetAttributes zarrDatasetAttributes = datasetAttributes instanceof ZarrDatasetAttributes ? (ZarrDatasetAttributes)datasetAttributes : this.getDatasetAttributes(pathName);
        String normalPath = N5URI.normalizeGroupPath((String)pathName);
        String path = this.keyValueAccess.compose(this.uri, new String[]{normalPath, ZarrKeyValueWriter.getZarrDataBlockPath(dataBlock.getGridPosition(), zarrDatasetAttributes.getDimensionSeparator(), zarrDatasetAttributes.isRowMajor()).toString()});
        String[] components = this.keyValueAccess.components(path);
        String parent = this.keyValueAccess.compose((String[])Arrays.stream(components).limit(components.length - 1).toArray(String[]::new));
        try {
            this.keyValueAccess.createDirectories(parent);
            try (LockedChannel lockedChannel = this.keyValueAccess.lockForWriting(path);){
                ZarrKeyValueWriter.writeBlock(lockedChannel.newOutputStream(), zarrDatasetAttributes, dataBlock);
            }
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to write block " + Arrays.toString(dataBlock.getGridPosition()) + " into dataset " + path, e);
        }
    }

    public boolean deleteBlock(String path, long ... gridPosition) throws N5Exception {
        String normPath = N5URI.normalizeGroupPath((String)path);
        ZarrDatasetAttributes zarrDatasetAttributes = this.getDatasetAttributes(normPath);
        String absolutePath = this.keyValueAccess.compose(this.uri, new String[]{normPath, ZarrKeyValueReader.getZarrDataBlockPath(gridPosition, zarrDatasetAttributes.getDimensionSeparator(), zarrDatasetAttributes.isRowMajor())});
        try {
            if (this.keyValueAccess.exists(absolutePath)) {
                this.keyValueAccess.delete(absolutePath);
            }
        }
        catch (Throwable e) {
            throw new N5Exception.N5IOException("Failed to delete block " + Arrays.toString(gridPosition) + " from dataset " + path, e);
        }
        return true;
    }

    public static byte[] padCrop(byte[] src, int[] srcBlockSize, int[] dstBlockSize, int nBytes, int nBits, byte[] fill_value) {
        assert (srcBlockSize.length == dstBlockSize.length) : "Dimensions do not match.";
        int n = srcBlockSize.length;
        if (nBytes != 0) {
            int d;
            int[] srcStrides = new int[n];
            int[] dstStrides = new int[n];
            int[] srcSkip = new int[n];
            int[] dstSkip = new int[n];
            srcStrides[0] = dstStrides[0] = nBytes;
            for (d = 1; d < n; ++d) {
                srcStrides[d] = srcBlockSize[d] * srcBlockSize[d - 1];
                dstStrides[d] = dstBlockSize[d] * dstBlockSize[d - 1];
            }
            for (d = 0; d < n; ++d) {
                srcSkip[d] = Math.max(1, dstBlockSize[d] - srcBlockSize[d]);
                dstSkip[d] = Math.max(1, srcBlockSize[d] - dstBlockSize[d]);
            }
            long[] srcIntervalDimensions = new long[n];
            long[] dstIntervalDimensions = new long[n];
            srcIntervalDimensions[0] = srcBlockSize[0] * nBytes;
            dstIntervalDimensions[0] = dstBlockSize[0] * nBytes;
            for (int d2 = 1; d2 < n; ++d2) {
                srcIntervalDimensions[d2] = srcBlockSize[d2];
                dstIntervalDimensions[d2] = dstBlockSize[d2];
            }
            byte[] dst = new byte[(int)Intervals.numElements((long[])dstIntervalDimensions)];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                dst[i] = fill_value[j];
                if (++j != fill_value.length) continue;
                j = 0;
            }
            ArrayImg srcImg = ArrayImgs.bytes((byte[])src, (long[])srcIntervalDimensions);
            ArrayImg dstImg = ArrayImgs.bytes((byte[])dst, (long[])dstIntervalDimensions);
            FinalInterval intersection = Intervals.intersect((Interval)srcImg, (Interval)dstImg);
            Cursor srcCursor = Views.interval((RandomAccessible)srcImg, (Interval)intersection).cursor();
            Cursor dstCursor = Views.interval((RandomAccessible)dstImg, (Interval)intersection).cursor();
            while (srcCursor.hasNext()) {
                ((ByteType)dstCursor.next()).set((GenericByteType)srcCursor.next());
            }
            return dst;
        }
        return null;
    }

    protected void redirectDatasetAttribute(JsonObject src, String key, ZarrJsonElements zarrElems, ZarrDatasetAttributes dsetAttrs) {
        this.redirectDatasetAttribute(src, key, zarrElems, key, dsetAttrs);
    }

    protected static void redirectDatasetAttribute(JsonObject src, String srcKey, JsonObject dest, String destKey) {
        if (src.has(srcKey)) {
            JsonElement e = src.get(srcKey);
            dest.add(destKey, e);
            src.remove(srcKey);
        }
    }

    protected void redirectDatasetAttribute(JsonObject src, String srcKey, ZarrJsonElements zarrElems, String destKey, ZarrDatasetAttributes dsetAttrs) {
        if (src.has(srcKey) && dsetAttrs != null) {
            JsonElement e = src.get(srcKey);
            if (e.isJsonArray() && dsetAttrs.isRowMajor()) {
                ZarrKeyValueWriter.reorder(e.getAsJsonArray());
            }
            zarrElems.getOrMakeZarray().add(destKey, e);
            src.remove(srcKey);
        }
    }

    protected void redirectGroupDatasetAttribute(JsonObject src, String srcKey, ZarrJsonElements zarrElems, String destKey, ZarrDatasetAttributes dsetAttrs) {
        if (src.has(srcKey) && dsetAttrs != null) {
            JsonElement e = src.get(srcKey);
            if (e.isJsonArray() && dsetAttrs.isRowMajor()) {
                ZarrKeyValueWriter.reorder(e.getAsJsonArray());
            }
            zarrElems.getOrMakeZarray().add(destKey, e);
            src.remove(srcKey);
        }
    }

    protected static void redirectDataType(JsonObject src, JsonObject dest) {
        if (src.has("dataType")) {
            JsonElement e = src.get("dataType");
            dest.addProperty("dtype", new DType(DataType.fromString((String)e.getAsString())).toString());
            src.remove("dataType");
        }
    }

    protected static void redirectCompression(JsonObject src, Gson gson, JsonObject dest) {
        if (src.has("compression")) {
            Compression c = (Compression)gson.fromJson(src.get("compression"), Compression.class);
            if (c.getClass() == RawCompression.class) {
                dest.add("compressor", (JsonElement)JsonNull.INSTANCE);
            } else {
                dest.add("compressor", gson.toJsonTree((Object)ZarrCompressor.fromCompression(c)));
            }
            src.remove("compression");
        }
    }

    protected static ZarrJsonElements build(JsonObject obj, Gson gson) {
        return ZarrKeyValueWriter.build(obj, gson, true);
    }

    protected static ZarrJsonElements build(JsonObject obj, Gson gson, boolean mapN5Attributes) {
        if (mapN5Attributes) {
            ZarrKeyValueWriter.redirectDatasetAttribute(obj, "dimensions", obj, "shape");
            ZarrKeyValueWriter.redirectDatasetAttribute(obj, "blockSize", obj, "chunks");
            ZarrKeyValueWriter.redirectDataType(obj, obj);
            ZarrKeyValueWriter.redirectCompression(obj, gson, obj);
        }
        ZarrJsonElements zje = new ZarrJsonElements();
        if (ZarrKeyValueWriter.hasRequiredArrayKeys(obj)) {
            ZarrKeyValueWriter.move(obj, () -> zje.getOrMakeZarray(), ZArrayAttributes.allKeys);
            ZarrKeyValueWriter.reverseAttrsWhenCOrder((JsonElement)zje.zarray);
        } else if (obj.has("zarr_format")) {
            ZarrKeyValueWriter.move(obj, () -> zje.getOrMakeZgroup(), "zarr_format");
        }
        zje.zattrs = obj;
        return zje;
    }

    protected static boolean hasRequiredArrayKeys(JsonObject obj) {
        return obj.has("shape") && obj.has("chunks") && obj.has("dtype") && obj.has("compressor") && obj.has("fill_value") && obj.has("order") && obj.has("zarr_format") && obj.has("filters");
    }

    protected static void move(JsonObject src, Supplier<JsonObject> dstSup, String ... keys) {
        for (String key : keys) {
            if (!src.has(key)) continue;
            JsonObject dst = dstSup.get();
            dst.add(key, src.get(key));
            src.remove(key);
        }
    }

    static void reorder(long[] array) {
        int max = array.length - 1;
        for (int i = (max - 1) / 2; i >= 0; --i) {
            int j = max - i;
            long a = array[i];
            array[i] = array[j];
            array[j] = a;
        }
    }

    static void reorder(int[] array) {
        int max = array.length - 1;
        for (int i = (max - 1) / 2; i >= 0; --i) {
            int j = max - i;
            int a = array[i];
            array[i] = array[j];
            array[j] = a;
        }
    }

    static void reorder(JsonArray array) {
        int max = array.size() - 1;
        for (int i = (max - 1) / 2; i >= 0; --i) {
            int j = max - i;
            JsonElement a = array.get(i);
            array.set(i, array.get(j));
            array.set(j, a);
        }
    }

    protected static class ZarrJsonElements {
        public JsonObject zattrs;
        public JsonObject zgroup;
        public JsonObject zarray;

        public JsonObject getOrMakeZarray() {
            if (this.zarray == null) {
                this.zarray = new JsonObject();
            }
            return this.zarray;
        }

        public JsonObject getOrMakeZattrs() {
            if (this.zattrs == null) {
                this.zattrs = new JsonObject();
            }
            return this.zattrs;
        }

        public JsonObject getOrMakeZgroup() {
            if (this.zgroup == null) {
                this.zgroup = new JsonObject();
            }
            return this.zgroup;
        }
    }
}

