/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Convolve3d {
    private static int w;
    private static int h;
    private static int d;
    private static int r_x;
    private static int r_y;
    private static int r_z;
    private static Object[] slices_in;
    private static boolean isByte;
    private static boolean isShort;
    private static boolean isFloat;
    private static float[][][] H;

    public static ImagePlus convolve(ImagePlus image, float[] H_x, float[] H_y, float[] H_z) {
        ImagePlus tmp1 = Convolve3d.convolveX(image, H_x);
        ImagePlus tmp2 = Convolve3d.convolveY(tmp1, H_y);
        return Convolve3d.convolveZ(tmp2, H_z);
    }

    public static ImagePlus convolveX(ImagePlus image, float[] H_x) {
        float[][][] H = new float[1][1][H_x.length];
        for (int i = 0; i < H_x.length; ++i) {
            H[0][0][i] = H_x[i];
        }
        return Convolve3d.convolve(image, H);
    }

    public static ImagePlus convolveY(ImagePlus image, float[] H_y) {
        float[][][] H = new float[1][H_y.length][1];
        for (int i = 0; i < H_y.length; ++i) {
            H[0][i][0] = H_y[i];
        }
        return Convolve3d.convolve(image, H);
    }

    public static ImagePlus convolveZ(ImagePlus image, float[] H_z) {
        float[][][] H = new float[H_z.length][1][1];
        for (int i = 0; i < H_z.length; ++i) {
            H[i][0][0] = H_z[i];
        }
        return Convolve3d.convolve(image, H);
    }

    public static ImagePlus convolve(ImagePlus image, float[][][] kernel) {
        H = kernel;
        r_z = H.length;
        r_y = H[0].length;
        r_x = H[0][0].length;
        w = image.getWidth();
        h = image.getHeight();
        d = image.getStackSize();
        int min_x = r_x / 2;
        int max_x = w - r_x / 2;
        int min_y = r_y / 2;
        int max_y = h - r_y / 2;
        int min_z = r_z / 2;
        int max_z = d - r_z / 2;
        slices_in = new Object[d];
        float[][] slices_out = new float[d][];
        for (int i = 0; i < d; ++i) {
            Convolve3d.slices_in[i] = image.getStack().getProcessor(i + 1).getPixels();
            slices_out[i] = new float[w * h];
        }
        isByte = slices_in[0] instanceof byte[];
        isShort = slices_in[0] instanceof short[];
        isFloat = slices_in[0] instanceof float[];
        for (int z = 0; z < d; ++z) {
            IJ.showProgress((int)z, (int)d);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    slices_out[z][y * Convolve3d.w + x] = Convolve3d.convolvePoint(z, y, x);
                }
            }
        }
        ImageStack stack = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            stack.addSlice("", (ImageProcessor)new FloatProcessor(w, h, slices_out[z], null));
        }
        ImagePlus result = new ImagePlus("", stack);
        result.setCalibration(image.getCalibration());
        return result;
    }

    private static float convolvePoint(int z, int y, int x) {
        float sum = 0.0f;
        for (int k = -r_z / 2; k <= r_z / 2; ++k) {
            for (int j = -r_y / 2; j <= r_y / 2; ++j) {
                for (int i = -r_x / 2; i <= r_x / 2; ++i) {
                    sum += Convolve3d.getValue(x + i, y + j, z + k) * H[k + r_z / 2][j + r_y / 2][i + r_x / 2];
                }
            }
        }
        return sum;
    }

    private static float getValue(int x, int y, int z) {
        if (x < 0) {
            return 0.0f;
        }
        if (x > w - 1) {
            return 0.0f;
        }
        if (y < 0) {
            return 0.0f;
        }
        if (y > h - 1) {
            return 0.0f;
        }
        if (z < 0) {
            return 0.0f;
        }
        if (z > d - 1) {
            return 0.0f;
        }
        int index = y * w + x;
        if (isByte) {
            return ((byte[])slices_in[z])[index] & 0xFF;
        }
        if (isShort) {
            return ((short[])slices_in[z])[index];
        }
        if (isFloat) {
            return ((float[])slices_in[z])[index];
        }
        IJ.error((String)"Neither byte nor float image");
        return -1.0f;
    }
}

