/*
 * Decompiled with CFR 0.152.
 */
package vib.app.gui;

import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import vib.app.FileGroup;

public class FileGroupDialog
extends Panel
implements ActionListener,
DropTargetListener {
    private FileGroup files;
    private boolean showWholePath = false;
    private List list;
    private TextField nameTF;
    private Button add;
    private Button delete;
    private Button template;
    private Checkbox wholePath;
    private boolean showTemplateButton;

    public FileGroupDialog(FileGroup fg) {
        this(fg, true);
    }

    public FileGroupDialog(FileGroup fg, boolean showTemplateButton) {
        this.files = fg;
        this.showTemplateButton = showTemplateButton;
        this.list = new List();
        this.list.setDropTarget(null);
        DropTarget dropTarget = new DropTarget(this.list, this);
        this.createList();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        Label name = new Label("Files: ");
        name.setFont(new Font("Monospace", 1, 14));
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(name, c);
        this.add(name);
        ScrollPane scroll = new ScrollPane();
        scroll.add(this.list);
        scroll.setPreferredSize(new Dimension(300, 100));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.5;
        c.weightx = 0.5;
        gridbag.setConstraints(scroll, c);
        this.add(scroll);
        Panel buttons = new Panel(new GridLayout(3, 1));
        this.add = new Button("Add to files");
        this.add.addActionListener(this);
        buttons.add(this.add);
        this.delete = new Button("Delete from files");
        this.delete.addActionListener(this);
        buttons.add(this.delete);
        this.template = new Button("Use as template");
        this.template.addActionListener(this);
        if (showTemplateButton) {
            buttons.add(this.template);
        }
        ++c.gridx;
        c.fill = 2;
        gridbag.setConstraints(buttons, c);
        this.add(buttons);
        this.wholePath = new Checkbox("Show absolute path", this.showWholePath);
        this.wholePath.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FileGroupDialog.this.showWholePath = FileGroupDialog.this.wholePath.getState();
                FileGroupDialog.this.createList();
                FileGroupDialog.this.repaint();
            }
        });
        ++c.gridy;
        --c.gridx;
        c.fill = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        gridbag.setConstraints(this.wholePath, c);
        this.add(this.wholePath);
    }

    public File getSelected() {
        int selected = this.list.getSelectedIndex();
        if (selected != -1) {
            return (File)this.files.get(selected);
        }
        return null;
    }

    public Button getTemplateButton() {
        return this.template;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.add) {
            OpenDialog dialog = new OpenDialog("Add file...", "");
            String f = dialog.getDirectory() + dialog.getFileName();
            if (f != null && !this.files.add(f)) {
                System.out.println("File " + f + " could not be added to the filegroup");
            }
            this.createList();
            this.repaint();
        } else if (e.getSource() == this.delete) {
            int[] idx = this.list.getSelectedIndexes();
            for (int i = 0; i < idx.length; ++i) {
                this.files.remove(idx[i]);
            }
            this.createList();
            this.repaint();
        }
    }

    public void update() {
        this.createList();
        this.repaint();
    }

    private void createList() {
        this.list.clear();
        for (int i = 0; i < this.files.size(); ++i) {
            if (this.showWholePath) {
                this.list.add(((File)this.files.get(i)).getAbsolutePath());
                continue;
            }
            this.list.add(((File)this.files.get(i)).getName());
        }
    }

    private static java.util.List textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        try {
            Transferable t = e.getTransferable();
            java.util.List l = null;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                l = (java.util.List)t.getTransferData(DataFlavor.javaFileListFlavor);
            } else {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (t.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)t.getTransferData(uriListFlavor);
                    System.out.println("got data: " + data);
                    l = FileGroupDialog.textURIListToFileList(data);
                }
            }
            if (l != null) {
                for (File f : l) {
                    this.files.add(f.getAbsolutePath());
                }
                this.update();
            }
            e.dropComplete(true);
        }
        catch (Exception ex) {
            e.dropComplete(false);
        }
    }

    public static void main(String[] args) {
        FileGroup fg = new FileGroup("TestGroup");
        fg.add("/home/bene/apt_list");
        fg.add("/home/bene/tmp.java");
        fg.add("/home/bene/tmp.class");
        Frame f = new Frame();
        FileGroupDialog d = new FileGroupDialog(fg);
        f.add(d);
        f.pack();
        f.show();
        fg.debug();
    }
}

