/*
 * Decompiled with CFR 0.152.
 */
package vib.edge;

import java.util.Vector;

public class SphereIterators {
    static final double EPSILON = 1.0E-15;

    public static double[][] SampleSphereSurface(double radius, double spacing) {
        return SphereIterators.SampleSphereSurface(radius, spacing, 1.0);
    }

    public static double[][] SampleSphereSurface(double radius, double spacing, double zfactor) {
        double N = Math.PI / (spacing /= radius);
        double totalLength = 4.0 * N;
        int count = (int)(totalLength * 1.0 / spacing);
        double[][] result = new double[count][3];
        for (int i = 0; i < count; ++i) {
            double l = spacing * (double)i;
            double t = zfactor * N / Math.PI * Math.acos(1.0 - l / 2.0 / N / zfactor) + 1.0E-15;
            result[i][0] = radius * Math.sin(t / zfactor * Math.PI / N) * Math.cos(Math.PI * 2 * t);
            result[i][1] = radius * Math.sin(t / zfactor * Math.PI / N) * Math.sin(Math.PI * 2 * t);
            result[i][2] = zfactor * radius * Math.cos(t / zfactor * Math.PI / N);
        }
        return result;
    }

    public static void printLandmarkSet(int[][] points) {
        double[][] dpoints = new double[points.length][3];
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                dpoints[i][j] = points[i][j];
            }
        }
        SphereIterators.printLandmarkSet(dpoints);
    }

    public static void printLandmarkSet(double[][] points) {
        System.out.println("# HyperMesh 3D ASCII 1.0\n\ndefine Markers " + points.length + "\n\nParameters {\n\tContentType \"LandmarkSet\",\n\tNumSets 1\n}\n\nMarkers { float[3] Coordinates }  @1\n\n# Data section follows^L\n@1\n");
        for (int i = 0; i < points.length; ++i) {
            System.out.println(points[i][0] + " " + points[i][1] + " " + points[i][2]);
        }
        System.out.println();
    }

    public static boolean isUpperHalf(int[] v, double[] normal) throws Exception {
        return SphereIterators.isUpperHalf(v[0], v[1], v[2], normal);
    }

    public static boolean isUpperHalf(int x, int y, int z, double[] normal) throws Exception {
        double result = (double)x * normal[0] + (double)y * normal[1] + (double)z * normal[2];
        if (result == 0.0) {
            throw new Exception("Neither upper nor lower half!");
        }
        return result > 0.0;
    }

    public static int[][] SphereIterator(double radius) {
        return SphereIterators.SphereIterator(radius, 1.0);
    }

    public static int[][] SphereIterator(double radius, double zFactor) {
        return SphereIterators.SphereIterator(radius, 1.0, 1.0, zFactor);
    }

    public static int[][] SphereIterator(double radius, double xFactor, double yFactor, double zFactor) {
        Vector<int[]> result = new Vector<int[]>();
        double r2 = radius * radius;
        int zDiff = (int)Math.floor(radius / zFactor);
        for (int z = -zDiff; z <= zDiff; ++z) {
            double z1 = (double)z * zFactor;
            int yDiff = (int)(Math.sqrt(r2 - z1 * z1) / yFactor);
            for (int y = -yDiff; y <= yDiff; ++y) {
                double y1 = (double)y * yFactor;
                int xDiff = (int)(Math.sqrt(r2 - z1 * z1 - y1 * y1) / xFactor);
                int x = -xDiff;
                while (x <= xDiff) {
                    int[] p = new int[]{x++, y, z};
                    result.add(p);
                }
            }
        }
        int[][] ret = new int[result.size()][3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int[])result.get(i);
        }
        return ret;
    }

    static boolean isNull(int[] v) {
        return v[0] == 0 && v[1] == 0 && v[2] == 0;
    }

    public static int[][] HalfSphereIterator(double radius, double[] normal) {
        return SphereIterators.HalfSphereIterator(radius, normal, 1.0);
    }

    public static int[][] HalfSphereIterator(double radius, double[] normal, double zfactor) {
        Vector<int[]> result = new Vector<int[]>();
        int[][] sphereIterator = SphereIterators.SphereIterator(radius, zfactor);
        for (int i = 0; i < sphereIterator.length; ++i) {
            try {
                if (SphereIterators.isNull(sphereIterator[i]) || !SphereIterators.isUpperHalf(sphereIterator[i], normal)) continue;
                result.add(sphereIterator[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[][] ret = new int[result.size()][3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int[])result.get(i);
        }
        return ret;
    }

    public static int[][][] HalfSphereIteratorsIterator(double radius, double[][] normals) {
        return SphereIterators.HalfSphereIteratorsIterator(radius, normals, 1.0);
    }

    public static int[][][] HalfSphereIteratorsIterator(double radius, double[][] normals, double zfactor) {
        int length = normals.length - 1;
        if (length < 0) {
            return new int[0][][];
        }
        int[][][] result = new int[length][][];
        int[][] sphereIterator = SphereIterators.SphereIterator(radius, zfactor);
        for (int i = 0; i < normals.length - 1; ++i) {
            int j;
            Vector<int[]> v = new Vector<int[]>();
            for (j = 0; j < sphereIterator.length; ++j) {
                try {
                    if (SphereIterators.isUpperHalf(sphereIterator[j], normals[i]) == SphereIterators.isUpperHalf(sphereIterator[j], normals[i + 1])) continue;
                    v.add(sphereIterator[j]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result[i] = new int[v.size()][3];
            for (j = 0; j < result[i].length; ++j) {
                result[i][j] = (int[])v.get(j);
            }
        }
        return result;
    }

    static void put(boolean[][][] sphere, int r, int[] c, boolean v) {
        sphere[r + c[0]][r + c[1]][r + c[2]] = v;
    }

    static boolean get(boolean[][][] sphere, int r, int[] c) {
        return sphere[r + c[0]][r + c[1]][r + c[2]];
    }

    public static boolean testHalfSphereIteratorsIterator(double radius, double[][] normals) {
        int i;
        int r = (int)radius;
        boolean[][][] sphere = new boolean[2 * r + 1][2 * r + 1][2 * r + 1];
        System.err.println("Building HalfSphereIterator");
        int[][] halfSphereIterator = SphereIterators.HalfSphereIterator(radius, normals[0]);
        System.err.println("... returned " + halfSphereIterator.length + " coordinates");
        System.err.println("Building Sphere");
        for (i = 0; i < halfSphereIterator.length; ++i) {
            SphereIterators.put(sphere, r, halfSphereIterator[i], true);
            sphere[r - halfSphereIterator[i][0]][r - halfSphereIterator[i][1]][r - halfSphereIterator[i][2]] = false;
        }
        System.err.println("Checking Sphere");
        for (i = 0; i < halfSphereIterator.length; ++i) {
            if (SphereIterators.get(sphere, r, halfSphereIterator[i])) continue;
            System.err.println("Detected error in HalfSphereIterator");
            return false;
        }
        System.err.println("Building HalfSphereIteratorsIterator");
        int[][][] iterator2 = SphereIterators.HalfSphereIteratorsIterator(radius, normals);
        if (iterator2.length + 1 != normals.length) {
            System.err.println("Wrong length of HalfSphereIteratorsIterator");
            return false;
        }
        System.err.println("... returned " + iterator2.length + " iterators");
        System.err.println("Checking HalfSphereIteratorsIterator");
        for (int i2 = 0; i2 < iterator2.length; ++i2) {
            int j;
            System.err.println("Applying " + i2 + " (" + iterator2[i2].length + " coordinates)");
            for (j = 0; j < iterator2[i2].length; ++j) {
                SphereIterators.put(sphere, r, iterator2[i2][j], !SphereIterators.get(sphere, r, iterator2[i2][j]));
            }
            System.err.println("Building HalfSphereIterator");
            halfSphereIterator = SphereIterators.HalfSphereIterator(radius, normals[i2 + 1]);
            System.err.println("Checking with HalfSphereIterator");
            for (j = 0; j < halfSphereIterator.length; ++j) {
                if (SphereIterators.get(sphere, r, halfSphereIterator[j])) continue;
                System.err.println("HalfSphereIteratorsIterator failed at " + i2 + ", " + j);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-landmarks")) {
            double[][] sphere = SphereIterators.SampleSphereSurface(100.0, 30.0);
            SphereIterators.printLandmarkSet(sphere);
            return;
        }
        double radius = 10.0;
        double[][] normals = SphereIterators.SampleSphereSurface(radius, 5.0);
        SphereIterators.testHalfSphereIteratorsIterator(radius, normals);
    }
}

