/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.sampler;

import net.imglib2.RandomAccess;
import net.imglib2.Sampler;
import net.imglib2.display.projector.sampler.ProjectedSampler;

public class SelectiveSampler<T>
implements ProjectedSampler<T> {
    private final long[] m_projectedPositions;
    private final int m_projectionDimension;
    private RandomAccess<T> m_source;
    private int m_selectedIndex = 0;

    public SelectiveSampler(int projectionDimension, long[] projectedPositions) {
        this.m_projectedPositions = projectedPositions;
        this.m_projectionDimension = projectionDimension;
    }

    @Override
    public void jumpFwd(long steps) {
        this.m_selectedIndex = (int)((long)this.m_selectedIndex + steps);
    }

    @Override
    public void fwd() {
        ++this.m_selectedIndex;
    }

    @Override
    public void reset() {
        this.m_selectedIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.m_selectedIndex < this.m_projectedPositions.length;
    }

    @Override
    public T get() {
        this.m_source.setPosition(this.m_selectedIndex, this.m_projectionDimension);
        return this.m_source.get();
    }

    @Override
    public T getType() {
        return this.m_source.getType();
    }

    @Override
    public Sampler<T> copy() {
        this.m_source.setPosition(this.m_selectedIndex, this.m_projectionDimension);
        return this.m_source.copy();
    }

    @Override
    public void setRandomAccess(RandomAccess<T> srcAccess) {
        this.m_source = srcAccess;
    }
}

