/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.kdtree.KDTreeUtils;

public abstract class KDTreePositions {
    final int numDimensions;
    final int numPoints;
    private volatile RealInterval boundingBox;

    KDTreePositions(int numDimensions, int numPoints) {
        this.numDimensions = numDimensions;
        this.numPoints = numPoints;
    }

    public abstract double get(int var1, int var2);

    public abstract double[] asFlatArray();

    public abstract double[][] asNestedArray();

    abstract RealInterval createBoundingBox();

    public abstract PositionsLayout layout();

    public int numDimensions() {
        return this.numDimensions;
    }

    public int numPoints() {
        return this.numPoints;
    }

    public static KDTreePositions createNested(double[][] positions) {
        return new Nested(positions);
    }

    public static KDTreePositions createFlat(double[] positions, int numDimensions) {
        return new Flat(positions, numDimensions);
    }

    private static class Flat
    extends KDTreePositions {
        private final double[] positions;

        Flat(double[] positions, int numDimensions) {
            super(numDimensions, positions.length / numDimensions);
            this.positions = positions;
        }

        @Override
        public double get(int i, int d) {
            return this.positions[this.numDimensions * i + d];
        }

        @Override
        public double[] asFlatArray() {
            return this.positions;
        }

        @Override
        public double[][] asNestedArray() {
            return KDTreeUtils.unflatten(this.positions, this.numDimensions);
        }

        @Override
        protected RealInterval createBoundingBox() {
            double[] min = new double[this.numDimensions];
            double[] max = new double[this.numDimensions];
            KDTreeUtils.computeMinMax(this.positions, min, max);
            return FinalRealInterval.wrap(min, max);
        }

        @Override
        public PositionsLayout layout() {
            return PositionsLayout.FLAT;
        }
    }

    private static class Nested
    extends KDTreePositions {
        private final double[][] positions;

        Nested(double[][] positions) {
            super(positions.length, positions[0].length);
            this.positions = positions;
        }

        @Override
        public double get(int i, int d) {
            return this.positions[d][i];
        }

        @Override
        public double[] asFlatArray() {
            return null;
        }

        @Override
        public double[][] asNestedArray() {
            return this.positions;
        }

        @Override
        protected RealInterval createBoundingBox() {
            double[] min = new double[this.numDimensions];
            double[] max = new double[this.numDimensions];
            KDTreeUtils.computeMinMax(this.positions, min, max);
            return FinalRealInterval.wrap(min, max);
        }

        @Override
        public PositionsLayout layout() {
            return PositionsLayout.NESTED;
        }
    }

    public static enum PositionsLayout {
        FLAT,
        NESTED;

    }
}

