/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.filter.Duplicater;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.lang.reflect.Array;
import sc.fiji.i5d.ChannelImagePlus;
import sc.fiji.i5d.I5DVirtualStack;
import sc.fiji.i5d.cal.ChannelCalibration;
import sc.fiji.i5d.cal.ChannelDisplayProperties;
import sc.fiji.i5d.gui.ChannelControl;
import sc.fiji.i5d.gui.Image5DCanvas;
import sc.fiji.i5d.gui.Image5DWindow;

public class Image5D
extends ImagePlus {
    public static final String VERSION = "1.2.6-DEV";
    static final int nDefaultDimensions = 5;
    protected int nDimensions = 5;
    private final String[] dimensionLabels = new String[]{"x", "y", "ch", "z", "t"};
    protected boolean isInitialized;
    protected ImageStack imageStack;
    protected int imageStackSize;
    private Object dummyImage;
    protected int[] currentPosition = new int[this.nDimensions];
    protected ChannelImagePlus[] channelImps = new ChannelImagePlus[1];
    protected ImageProcessor[] channelIPs = new ImageProcessor[1];
    protected int colorDimension = 2;
    private ChannelCalibration[] chCalibration;
    private ChannelDisplayProperties[] chDisplayProps;
    private final ImageJ ij = IJ.getInstance();
    int[] awtImagePixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    ColorModel imageColorModel;
    Image awtImage;
    int[][] awtChannelPixels;
    protected int displayMode;
    protected boolean displayAllGray;
    protected boolean displayGrayInTiles;
    protected boolean activated5d;
    static IndexColorModel grayColorModel = ChannelDisplayProperties.createModelFromColor(Color.white);
    static final String outOfRange = "Argument out of range: ";
    protected int xSav;
    protected int ySav;

    public Image5D(String title, int type, int[] dimensions, boolean fill) {
        this(title, Image5D.createProcessorFromDims(type, dimensions));
        for (int i = 2; i < this.nDimensions; ++i) {
            this.expandDimension(i, dimensions[i], fill);
        }
    }

    public Image5D(String title, int type, int width, int height, int nChannels, int nSlices, int nFrames, boolean fill) {
        this(title, type, new int[]{width, height, nChannels, nSlices, nFrames}, fill);
    }

    public Image5D(String title, ImageProcessor ip) {
        this(title, Image5D.createStackFromProcessor(ip), 1, 1, 1);
    }

    public Image5D(String title, ImageStack stack) {
        this(title, stack, 1, 1, 1);
    }

    public Image5D(String title, ImageStack stack, int nChannels, int nSlices, int nFrames) {
        super(title, Image5D.createZStackFromImageStack(stack, nChannels, nSlices, nFrames));
        int i;
        if (IJ.versionLessThan((String)"1.34p")) {
            throw new IllegalArgumentException("ImageJ version too old");
        }
        this.imageStack = stack;
        this.imageStackSize = stack.getSize();
        super.setDimensions(nChannels, nSlices, nFrames);
        for (i = 0; i < this.nDimensions; ++i) {
            this.currentPosition[i] = 0;
        }
        this.chCalibration = new ChannelCalibration[nChannels];
        for (i = 0; i < nChannels; ++i) {
            this.chCalibration[i] = new ChannelCalibration();
        }
        this.chDisplayProps = new ChannelDisplayProperties[nChannels];
        for (i = 0; i < nChannels; ++i) {
            this.chDisplayProps[i] = new ChannelDisplayProperties();
            this.chDisplayProps[i].setColorModel(this.ip.getColorModel());
            this.chDisplayProps[i].setMinValue(this.ip.getMin());
            this.chDisplayProps[i].setMaxValue(this.ip.getMax());
            this.chDisplayProps[i].setMinThreshold(this.ip.getMinThreshold());
            this.chDisplayProps[i].setMaxThreshold(this.ip.getMaxThreshold());
            this.chDisplayProps[i].setLutUpdateMode(this.ip.getLutUpdateMode());
            this.chDisplayProps[i].setDisplayedGray(false);
        }
        ImageProcessor[] newChannelIPs = new ImageProcessor[nChannels];
        this.channelImps = new ChannelImagePlus[nChannels];
        for (int i2 = 0; i2 < nChannels; ++i2) {
            newChannelIPs[i2] = Image5D.createProcessorFromDims(this.getType(), new int[]{this.width, this.height, 1, 1, 1});
            newChannelIPs[i2].setPixels(this.imageStack.getPixels(this.getCurrentSliceOffset() + i2));
            newChannelIPs[i2].setColorModel(this.chDisplayProps[i2].getColorModel());
            newChannelIPs[i2].setThreshold(this.chDisplayProps[i2].getMinThreshold(), this.chDisplayProps[i2].getMaxThreshold(), 2);
            newChannelIPs[i2].setMinAndMax(this.chDisplayProps[i2].getMinValue(), this.chDisplayProps[i2].getMaxValue());
            this.channelImps[i2] = new ChannelImagePlus("", newChannelIPs[i2]);
        }
        this.channelIPs = newChannelIPs;
        this.displayMode = 1;
        this.displayAllGray = false;
        this.displayGrayInTiles = false;
        String modePref = Prefs.get((String)"image5d.displayMode", (String)ChannelControl.displayModes[this.displayMode]);
        int mode = this.displayMode;
        for (int i3 = 0; i3 < ChannelControl.displayModes.length; ++i3) {
            if (!ChannelControl.displayModes[i3].equals(modePref)) continue;
            mode = i3;
            break;
        }
        this.setDisplayMode(mode);
        this.imageStack.setColorModel((ColorModel)grayColorModel);
        this.setCalibration(super.getCalibration());
        this.isInitialized = true;
    }

    public Image5D() {
        throw new IllegalArgumentException("Empty constructor not supported.");
    }

    public Image5D(String title, Image img) {
        throw new IllegalArgumentException("Constructor Image5D(String, Image) not supported.");
    }

    public Image5D(String pathOrURL) {
        throw new IllegalArgumentException("Constructor Image5D(String) not supported.");
    }

    public static int compareToVersion(String testVersion) {
        int startTest = 0;
        int endTest = 0;
        int numTest = 0;
        int startThis = 0;
        int endThis = 0;
        int numThis = 0;
        String thisVersion = "1.2.6-DEV.";
        testVersion = testVersion + ".";
        for (int i = 0; i < 3; ++i) {
            endTest = testVersion.indexOf(46, startTest);
            if (endTest < 0) {
                numTest = 0;
            } else {
                numTest = Integer.parseInt(testVersion.substring(startTest, endTest));
                startTest = endTest + 1;
            }
            endThis = "1.2.6-DEV.".indexOf(46, startThis);
            if (endThis < 0) {
                numThis = 0;
            } else {
                numThis = Integer.parseInt("1.2.6-DEV.".substring(startThis, endThis));
                startThis = endThis + 1;
            }
            if (numTest < numThis) {
                return -1;
            }
            if (numTest <= numThis) continue;
            return 1;
        }
        return 0;
    }

    public void setStack(String title, ImageStack stack) {
        if (this.isInitialized && this.imageStack.isVirtual()) {
            return;
        }
        if (stack.getProcessor(1) instanceof ColorProcessor) {
            throw new IllegalArgumentException("Cannot accept RGB stack for Image5D.");
        }
        if (this.isInitialized) {
            if (!stack.getProcessor(1).getClass().equals(this.getProcessor().getClass())) {
                throw new IllegalArgumentException("Stack type does not match current Image5D type.");
            }
            if (stack.getWidth() != this.width || stack.getHeight() != this.height || stack.getSize() != this.getNSlices()) {
                throw new IllegalArgumentException("Stack dimensions don't match current Image5D dimensions.");
            }
        }
        ImageWindow tempWin = this.win;
        this.win = null;
        super.setStack(title, stack);
        this.win = tempWin;
        if (this.isInitialized) {
            int offs = this.getCurrentStackOffset() - 1;
            int incr = this.getCurrentStackIncrement();
            int size = this.getNSlices();
            Object[] imageStackArray = this.imageStack.getImageArray();
            for (int i = 0; i < size; ++i) {
                imageStackArray[offs + i * incr] = stack.getPixels(i + 1);
            }
            this.chDisplayProps[this.currentPosition[this.colorDimension]].setColorModel(stack.getColorModel());
            this.setSlice(this.currentPosition[3] + 1);
        }
        this.updateAndRepaintWindow();
    }

    public void updateWindowControls() {
        if (this.win != null) {
            Image5DWindow iWin = (Image5DWindow)this.win;
            iWin.getChannelControl().updateChannelSelector();
        }
    }

    public void updateImageAndDraw() {
        this.img = null;
        this.updateAndDraw();
    }

    public void mouseMoved(int x, int y) {
        IJ.showStatus((String)this.getStatusString(x, y));
        this.getCanvas().setShowCursorStatus(true);
        this.xSav = x;
        this.ySav = y;
    }

    public void updateStatusbarValue() {
        IJ.showStatus((String)this.getStatusString(this.xSav, this.ySav));
    }

    protected String getStatusString(int x, int y) {
        String str = this.getLocationAsString(x, y) + "; value = ";
        if (this.displayMode == 0 || this.displayMode == 1) {
            str = str + this.channelImps[this.getCurrentChannel() - 1].getValueAsStringI5d(x, y);
        } else {
            for (int i = 0; i < this.getNChannels(); ++i) {
                if (i > 0) {
                    str = str + ", ";
                }
                str = str + this.channelImps[i].getValueAsStringI5d(x, y);
            }
        }
        return str;
    }

    public void setImage(Image img) {
        ImageWindow tempWin = this.win;
        this.win = null;
        super.setImage(img);
        this.win = tempWin;
    }

    public void setProcessor(String title, ImageProcessor ip) {
        ImageWindow tempWin = this.win;
        this.win = null;
        super.setProcessor(title, ip);
        this.win = tempWin;
        if (this.win != null) {
            this.updateAndDraw();
        }
    }

    protected void setType(int type) {
        super.setType(type);
    }

    public synchronized void setChannel(int index) {
        this.setCurrentPosition(this.colorDimension, index - 1);
    }

    public synchronized void setSlice(int index) {
        this.setCurrentPosition(3, index - 1);
    }

    public synchronized void setFrame(int index) {
        this.setCurrentPosition(4, index - 1);
    }

    public synchronized void setCurrentPosition(int dimension, int position) {
        if (dimension < 0 || dimension >= this.nDimensions) {
            throw new IllegalArgumentException("Invalid dimension: " + dimension);
        }
        if (position < 0 || position >= this.getDimensions()[dimension]) {
            return;
        }
        int[] tmpPos = new int[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            tmpPos[i] = i == dimension ? position : this.currentPosition[i];
        }
        this.setCurrentPosition(tmpPos);
    }

    public synchronized void setCurrentPosition(int x, int y, int ch, int z, int t) {
        this.setCurrentPosition(new int[]{x, y, ch, z, t});
    }

    public synchronized void setCurrentPosition(int[] position) {
        int i;
        if (position.length < this.nDimensions) {
            throw new IllegalArgumentException("Position array is smaller than number of dimensions.");
        }
        int[] dimensions = this.getDimensions();
        for (int i2 = 0; i2 < this.nDimensions; ++i2) {
            if (position[i2] < 0) {
                position[i2] = 0;
                continue;
            }
            if (position[i2] < dimensions[i2]) continue;
            position[i2] = dimensions[i2] - 1;
        }
        if (!this.imageStack.isVirtual()) {
            this.imageStack.setSliceLabel(this.getStack().getSliceLabel(this.getCurrentSlice()), this.getCurrentImageStackIndex());
        }
        this.storeCurrentChannelProperties();
        int oldChannel = this.currentPosition[this.colorDimension];
        int newChannel = position[this.colorDimension];
        boolean channelChanged = oldChannel != newChannel;
        boolean stackChanged = channelChanged || this.currentPosition[4] != position[4];
        for (i = 0; i < this.nDimensions; ++i) {
            this.currentPosition[i] = position[i];
        }
        if (stackChanged) {
            ImageWindow tempWin;
            int incr;
            int offs;
            if (!this.imageStack.isVirtual()) {
                ImageStack newStack = new ImageStack(this.width, this.height, this.chDisplayProps[position[this.colorDimension]].getColorModel());
                offs = this.getCurrentStackOffset();
                incr = this.getCurrentStackIncrement();
                for (int i3 = 0; i3 < this.getNSlices(); ++i3) {
                    newStack.addSlice(this.imageStack.getSliceLabel(offs + i3 * incr), this.imageStack.getPixels(offs + i3 * incr));
                }
                tempWin = this.win;
                this.win = null;
                super.setStack(null, newStack);
                this.win = tempWin;
            } else {
                I5DVirtualStack newStack = new I5DVirtualStack(this.width, this.height, this.chDisplayProps[position[this.colorDimension]].getColorModel(), ((I5DVirtualStack)this.imageStack).getPath());
                offs = this.getCurrentStackOffset();
                incr = this.getCurrentStackIncrement();
                for (int i4 = 0; i4 < this.getNSlices(); ++i4) {
                    newStack.addSlice(this.imageStack.getSliceLabel(offs + i4 * incr));
                }
                tempWin = this.win;
                this.win = null;
                super.setStack(null, (ImageStack)newStack);
                this.win = tempWin;
            }
        }
        this.channelIPs[this.currentPosition[this.colorDimension]] = this.getProcessor();
        this.channelImps[this.currentPosition[this.colorDimension]].setProcessor(null, this.getProcessor());
        for (i = 0; i < this.getNChannels(); ++i) {
            if (i == this.currentPosition[this.colorDimension]) continue;
            this.channelIPs[i].setPixels(this.imageStack.getPixels(this.getCurrentSliceOffset() + i));
            this.channelImps[i].updateImage();
        }
        this.restoreCurrentChannelProperties();
        this.newPixels = true;
        ImageWindow tempWin = this.win;
        this.win = null;
        super.setSlice(this.currentPosition[3] + 1);
        this.win = tempWin;
        if (this.win != null) {
            ((Image5DWindow)this.win).updateSliceSelector();
        }
        if (IJ.spaceBarDown() && (this.getType() == 1 || this.getType() == 2)) {
            this.ip.resetMinAndMax();
            IJ.showStatus((String)(this.currentPosition[3] + 1 + ": min=" + this.ip.getMin() + ", max=" + this.ip.getMax()));
        }
        this.newPixels = true;
        this.updateAndRepaintWindow();
    }

    public int getNDimensions() {
        return this.nDimensions;
    }

    public String getDimensionLabel(int dimension) {
        if (dimension < 0 || dimension >= this.nDimensions) {
            throw new IllegalArgumentException("Invalid Dimension: " + dimension);
        }
        return this.dimensionLabels[dimension];
    }

    public int getDimensionSize(int dimension) {
        if (dimension < 0 || dimension > 4) {
            return 0;
        }
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
            case 2: {
                return this.getNChannels();
            }
            case 3: {
                return this.getNSlices();
            }
            case 4: {
                return this.getNFrames();
            }
        }
        return 0;
    }

    public int getImageStackSize() {
        return this.imageStackSize;
    }

    public ImageStack getImageStack() {
        return this.imageStack;
    }

    public String getI5DMetaData() {
        return "";
    }

    public FileInfo getFileInfo() {
        FileInfo fi = super.getFileInfo();
        fi.nImages = this.getImageStackSize();
        if (fi.nImages > 1) {
            fi.pixels = this.getImageStack().getImageArray();
        }
        return fi;
    }

    public Object getPixels(int channel, int slice, int frame) {
        if (channel < 1 || channel > this.getNChannels() || slice < 1 || slice > this.getNSlices() || frame < 1 || frame > this.getNFrames()) {
            throw new IllegalArgumentException("Argument out of range: <" + channel + ", " + slice + ", " + frame + ">");
        }
        return this.imageStack.getPixels(this.getImageStackIndex(channel, slice, frame));
    }

    public void setPixels(Object pixels) {
        if (this.isInitialized && pixels != null) {
            if (this.imageStack.isVirtual()) {
                return;
            }
            if (!pixels.getClass().equals(this.imageStack.getPixels(this.getCurrentImageStackIndex()).getClass())) {
                return;
            }
            if (this.width * this.height != Array.getLength(pixels)) {
                throw new IllegalArgumentException("Array size does not match image dimensions.");
            }
            this.imageStack.setPixels(pixels, this.getCurrentImageStackIndex());
            this.channelIPs[this.currentPosition[2]].setPixels(pixels);
            super.getStack().setPixels(pixels, this.getCurrentPosition(3) + 1);
        }
    }

    public void setPixels(Object pixels, int channel, int slice, int frame) {
        if (this.isInitialized && pixels != null) {
            if (this.imageStack.isVirtual()) {
                return;
            }
            if (!pixels.getClass().equals(this.imageStack.getPixels(this.getImageStackIndex(channel, slice, frame)).getClass())) {
                throw new IllegalArgumentException("Invalid pixels array.");
            }
            if (this.width * this.height != Array.getLength(pixels)) {
                throw new IllegalArgumentException("Array size does not match image dimensions.");
            }
            this.checkChannel(channel);
            this.checkSlice(slice);
            this.checkFrame(frame);
            this.imageStack.setPixels(pixels, this.getImageStackIndex(channel, slice, frame));
            if (slice == this.getCurrentSlice() && frame == this.getCurrentFrame()) {
                this.channelIPs[channel - 1].setPixels(pixels);
            }
            if (channel == this.getCurrentChannel() && frame == this.getCurrentFrame()) {
                super.getStack().setPixels(pixels, slice);
            }
            if (channel == this.getCurrentChannel() && slice == this.getCurrentSlice() && frame == this.getCurrentFrame()) {
                this.getProcessor().setPixels(pixels);
            }
        }
    }

    public Object createEmptyPixels() {
        Object[] pixelsArray = null;
        switch (this.getType()) {
            case 0: {
                pixelsArray = new byte[this.getWidth() * this.getHeight()];
                break;
            }
            case 1: {
                pixelsArray = new short[this.getWidth() * this.getHeight()];
                break;
            }
            case 2: {
                pixelsArray = new float[this.getWidth() * this.getHeight()];
            }
        }
        return pixelsArray;
    }

    public int getColorDimension() {
        return this.colorDimension;
    }

    public int getCurrentImageStackIndex() {
        return this.currentPosition[4] * this.getNChannels() * this.getNSlices() + this.currentPosition[3] * this.getNChannels() + this.currentPosition[2] + 1;
    }

    public int getImageStackIndex(int channel, int slice, int frame) {
        return (frame - 1) * this.getNChannels() * this.getNSlices() + (slice - 1) * this.getNChannels() + (channel - 1) + 1;
    }

    public int[] getCurrentPosition() {
        int[] pos = new int[this.nDimensions];
        System.arraycopy(this.currentPosition, 0, pos, 0, this.nDimensions);
        return pos;
    }

    public int getCurrentPosition(int dimension) {
        return this.currentPosition[dimension];
    }

    public int getCurrentChannel() {
        return this.currentPosition[2] + 1;
    }

    public int getCurrentSlice() {
        return this.currentPosition[3] + 1;
    }

    public int getCurrentFrame() {
        return this.currentPosition[4] + 1;
    }

    public void setChannelColorModel(int channel, ColorModel model) {
        this.checkChannel(channel);
        if (!(model instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Only accepting IndexColorModels");
        }
        this.storeChannelProperties(channel);
        this.chDisplayProps[channel - 1].setColorModel(model);
        this.restoreChannelProperties(channel);
    }

    public void setChannelMinMax(int channel, double minValue, double maxValue) {
        this.checkChannel(channel);
        this.storeChannelProperties(channel);
        this.chDisplayProps[channel - 1].setMinValue(minValue);
        this.chDisplayProps[channel - 1].setMaxValue(maxValue);
        this.restoreChannelProperties(channel);
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        int i;
        if (this.displayMode == displayMode) {
            return;
        }
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.storeChannelProperties(i);
        }
        this.displayMode = displayMode;
        if (displayMode == 0) {
            this.displayAllGray = true;
        } else if (displayMode == 1 || displayMode == 2) {
            this.displayAllGray = false;
        } else if (displayMode == 3) {
            this.displayAllGray = this.displayGrayInTiles;
        }
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.restoreChannelProperties(i);
        }
        Image5DWindow win = (Image5DWindow)this.getWindow();
        if (win != null) {
            win.setDisplayMode(displayMode);
        }
        this.updateImageAndDraw();
    }

    public void setDisplayGrayInTiles(boolean displayGrayInTiles) {
        if (this.displayGrayInTiles == displayGrayInTiles) {
            return;
        }
        this.displayGrayInTiles = displayGrayInTiles;
        Image5DWindow win = (Image5DWindow)this.getWindow();
        if (win != null) {
            win.setDisplayGrayInTiles(displayGrayInTiles);
        }
        if (this.displayMode == 3) {
            int i;
            for (i = 1; i <= this.getNChannels(); ++i) {
                this.storeChannelProperties(i);
            }
            this.displayAllGray = displayGrayInTiles;
            for (i = 1; i <= this.getNChannels(); ++i) {
                this.restoreChannelProperties(i);
            }
            this.updateImageAndDraw();
        }
    }

    public boolean isDisplayGrayInTiles() {
        return this.displayGrayInTiles;
    }

    public boolean isDisplayedInOverlay(int channel) {
        this.checkChannel(channel);
        return this.chDisplayProps[channel - 1].isDisplayedInOverlay();
    }

    public void setDisplayedInOverlay(int channel, boolean displayed) {
        int i;
        this.checkChannel(channel);
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.storeChannelProperties(i);
        }
        this.chDisplayProps[channel - 1].setDisplayedInOverlay(displayed);
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.restoreChannelProperties(i);
        }
    }

    public boolean isDisplayedGray(int channel) {
        this.checkChannel(channel);
        return this.chDisplayProps[channel - 1].isDisplayedGray();
    }

    public void setDisplayedGray(int channel, boolean displayedGray) {
        int i;
        this.checkChannel(channel);
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.storeChannelProperties(i);
        }
        this.chDisplayProps[channel - 1].setDisplayedGray(displayedGray);
        for (i = 1; i <= this.getNChannels(); ++i) {
            this.restoreChannelProperties(i);
        }
    }

    public boolean isDisplayAllGray() {
        return this.displayAllGray;
    }

    public void setActivated() {
        this.activated5d = true;
    }

    public void show(String statusMessage) {
        if (this.win != null) {
            return;
        }
        if (IJ.macroRunning() && this.ij == null || Interpreter.isBatchMode()) {
            WindowManager.setTempCurrentImage((ImagePlus)this);
            Interpreter.addBatchModeImage((ImagePlus)this);
            return;
        }
        this.activated5d = false;
        this.win = new Image5DWindow(this);
        if (this.roi != null) {
            this.roi.setImage((ImagePlus)this);
        }
        this.draw();
        IJ.showStatus((String)statusMessage);
        if (IJ.macroRunning()) {
            long start = System.currentTimeMillis();
            while (!this.activated5d) {
                IJ.wait((int)5);
                if (System.currentTimeMillis() - start <= 2000L) continue;
                WindowManager.setTempCurrentImage((ImagePlus)this);
                break;
            }
        }
        IJ.showStatus((String)statusMessage);
        this.notifyListeners(0);
    }

    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    public void updateImage() {
        int imageSize = this.width * this.height;
        int nChannels = this.getNChannels();
        ImageProcessor tmpProcessor = this.ip;
        int type = this.getType();
        int displayMode = -1;
        if (this.win != null) {
            displayMode = ((Image5DWindow)this.win).getDisplayMode();
        }
        if (displayMode == 0 || displayMode == 1) {
            this.img = this.ip.createImage();
        } else if (displayMode == 2 || displayMode == 3) {
            int i;
            if (this.awtImagePixels == null || this.awtImagePixels.length != imageSize) {
                this.awtImagePixels = new int[imageSize];
                this.newPixels = true;
            }
            if (this.awtChannelPixels == null || this.awtChannelPixels.length != nChannels || this.awtChannelPixels[0].length != imageSize) {
                this.awtChannelPixels = new int[nChannels][];
                for (i = 0; i < nChannels; ++i) {
                    this.awtChannelPixels[i] = new int[imageSize];
                }
            }
            if (displayMode == 3) {
                switch (type) {
                    case 0: {
                        tmpProcessor = new ByteProcessor(this.width, this.height, null, null);
                        break;
                    }
                    case 1: {
                        this.dummyImage = new short[imageSize];
                        tmpProcessor = new ShortProcessor(this.width, this.height, null, null);
                        break;
                    }
                    case 2: {
                        tmpProcessor = new FloatProcessor(this.width, this.height, null, null);
                    }
                }
                this.channelIPs[this.getCurrentChannel() - 1].createImage();
            }
            for (i = 0; i < nChannels; ++i) {
                PixelGrabber pg;
                if (!this.chDisplayProps[i].isDisplayedInOverlay()) continue;
                if (displayMode == 2) {
                    pg = new PixelGrabber(this.channelIPs[i].createImage(), 0, 0, this.width, this.height, this.awtChannelPixels[i], 0, this.width);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (displayMode != 3) continue;
                tmpProcessor.setPixels(this.channelIPs[i].getPixels());
                tmpProcessor.setColorModel(this.getChannelDisplayProperties(i + 1).getColorModel());
                tmpProcessor.setMinAndMax(this.channelIPs[i].getMin(), this.channelIPs[i].getMax());
                pg = new PixelGrabber(tmpProcessor.createImage(), 0, 0, this.width, this.height, this.awtChannelPixels[i], 0, this.width);
                try {
                    pg.grabPixels();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (i = 0; i < imageSize; ++i) {
                int redValue = 0;
                int greenValue = 0;
                int blueValue = 0;
                for (int j = 0; j < nChannels; ++j) {
                    if (!this.chDisplayProps[j].isDisplayedInOverlay()) continue;
                    greenValue += this.awtChannelPixels[j][i] >> 8 & 0xFF;
                    blueValue += this.awtChannelPixels[j][i] & 0xFF;
                    if ((redValue += this.awtChannelPixels[j][i] >> 16 & 0xFF) > 255) {
                        redValue = 255;
                    }
                    if (greenValue > 255) {
                        greenValue = 255;
                    }
                    if (blueValue <= 255) continue;
                    blueValue = 255;
                }
                this.awtImagePixels[i] = redValue << 16 | greenValue << 8 | blueValue;
            }
            if (this.img == null && this.awtImage != null) {
                this.img = this.awtImage;
            }
            if (this.imageSource == null) {
                this.imageColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
                this.imageSource = new MemoryImageSource(this.width, this.height, this.imageColorModel, this.awtImagePixels, 0, this.width);
                this.imageSource.setAnimated(true);
                this.imageSource.setFullBufferUpdates(true);
                this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
                this.newPixels = false;
            } else if (this.newPixels) {
                this.imageSource.newPixels(this.awtImagePixels, this.imageColorModel, 0, this.width);
                this.newPixels = false;
            } else {
                this.imageSource.newPixels();
            }
        }
    }

    public void draw() {
        if (this.win != null) {
            ((Image5DWindow)this.win).repaintCanvasses();
        }
    }

    public void updateAndDraw() {
        if (this.win != null) {
            ((Image5DWindow)this.win).setImagesUpdated();
        }
        super.updateAndDraw();
    }

    public void setDefaultColors() {
        int nChannels = this.getNChannels();
        float colorIncr = 1.0f / (float)nChannels;
        for (int c = 1; c <= nChannels; ++c) {
            this.setChannelColorModel(c, ChannelDisplayProperties.createModelFromColor(Color.getHSBColor(colorIncr * (float)(c - 1), 1.0f, 1.0f)));
        }
    }

    public void setDefaultChannelNames() {
        int nChannels = this.getNChannels();
        for (int c = 1; c <= nChannels; ++c) {
            this.getChannelCalibration(c).setLabel("Ch-" + c);
        }
    }

    public synchronized void flush() {
        int i;
        Object[] arrays;
        super.flush();
        if (this.locked) {
            return;
        }
        ImageStack stack = this.getStack();
        if (stack != null && (arrays = stack.getImageArray()) != null && arrays[0] != null) {
            return;
        }
        Object[] imageStackArrays = this.imageStack.getImageArray();
        if (imageStackArrays != null) {
            for (i = 0; i < imageStackArrays.length; ++i) {
                imageStackArrays[i] = null;
            }
        }
        this.dummyImage = null;
        if (this.channelImps != null) {
            for (i = 0; i < this.channelImps.length; ++i) {
                this.channelImps[i].flush();
                this.channelImps[i] = null;
            }
        }
        if (this.channelIPs != null) {
            for (i = 0; i < this.channelIPs.length; ++i) {
                this.channelIPs[i] = null;
            }
        }
        if (this.chCalibration != null) {
            for (i = 0; i < this.chCalibration.length; ++i) {
                this.chCalibration[i] = null;
            }
        }
        if (this.chDisplayProps != null) {
            for (i = 0; i < this.chDisplayProps.length; ++i) {
                this.chDisplayProps[i] = null;
            }
        }
        this.awtImagePixels = null;
        if (this.awtChannelPixels != null) {
            for (i = 0; i < this.awtChannelPixels.length; ++i) {
                this.awtChannelPixels[i] = null;
            }
        }
        System.gc();
    }

    public void paste() {
        super.paste();
        if (this.win != null) {
            ((Image5DWindow)this.win).adaptRois((Image5DCanvas)this.getCanvas());
        }
    }

    public void copy(boolean cut) {
        if (this.displayMode != 2) {
            super.copy(cut);
        } else {
            if (cut) {
                return;
            }
            super.copy(false);
            ImagePlus imgClip = Image5D.getClipboard();
            ColorProcessor clipProcessor = new ColorProcessor(this.width, this.height, this.awtImagePixels);
            Roi roi = this.getRoi();
            if (roi != null && !roi.isArea()) {
                IJ.error((String)"Cut/Copy", (String)"The Cut and Copy commands require\nan area selection, or no selection.");
                return;
            }
            String msg = cut ? "Cut" : "Copy";
            IJ.showStatus((String)(msg + "ing..."));
            if (roi != null) {
                clipProcessor.setRoi((Roi)roi.clone());
            }
            ColorProcessor clipProcessor2 = (ColorProcessor)clipProcessor.crop();
            Roi roi2 = null;
            if (roi != null && roi.getType() != 0) {
                roi2 = (Roi)roi.clone();
                Rectangle r = roi.getBounds();
                if (r.x < 0 || r.y < 0) {
                    roi2.setLocation(Math.min(r.x, 0), Math.min(r.y, 0));
                }
            }
            imgClip.setProcessor(null, (ImageProcessor)clipProcessor2);
            if (roi2 != null) {
                imgClip.setRoi(roi2);
            }
            int bytesPerPixel = 4;
            IJ.showStatus((String)(msg + ": " + imgClip.getWidth() * imgClip.getHeight() * 4 / 1024 + "k"));
        }
    }

    public void putRoi(Roi newRoi) {
        Rectangle bounds = new Rectangle();
        if (newRoi != null) {
            bounds = newRoi.getBounds();
            if (bounds.width == 0 && bounds.height == 0 && newRoi.getType() != 10) {
                newRoi = null;
            }
        }
        this.roi = newRoi;
        if (this.roi != null) {
            if (this.ip != null) {
                this.ip.setMask(null);
                if (this.roi.isArea()) {
                    this.ip.setRoi(bounds);
                } else {
                    this.ip.resetRoi();
                }
            }
            this.roi.setImage((ImagePlus)this);
        }
        this.draw();
    }

    public synchronized void expandDimension(int dimension, int newSize, boolean fill) {
        if (this.imageStack.isVirtual()) {
            return;
        }
        if (dimension < 2 || dimension > this.nDimensions) {
            throw new IllegalArgumentException("Invalid dimension: " + dimension);
        }
        int[] dimensionSize = this.getDimensions();
        int oldSize = dimensionSize[dimension];
        if (oldSize >= newSize) {
            return;
        }
        dimensionSize[dimension] = newSize;
        int lowerDimSize = 1;
        int higherDimSize = 1;
        for (int i = 2; i < this.nDimensions; ++i) {
            if (i < dimension) {
                lowerDimSize *= dimensionSize[i];
                continue;
            }
            if (i <= dimension) continue;
            higherDimSize *= dimensionSize[i];
        }
        int type = this.getType();
        int imageSize = dimensionSize[0] * dimensionSize[1];
        if (!fill && this.dummyImage == null) {
            switch (type) {
                case 0: {
                    this.dummyImage = new byte[imageSize];
                    break;
                }
                case 1: {
                    this.dummyImage = new short[imageSize];
                    break;
                }
                case 2: {
                    this.dummyImage = new float[imageSize];
                }
            }
        }
        ImageStack newImageStack = new ImageStack(this.width, this.height, (ColorModel)grayColorModel);
        for (int highIndex = 0; highIndex < higherDimSize; ++highIndex) {
            int newIndex;
            int baseIndexOld;
            for (int oldIndex = baseIndexOld = highIndex * lowerDimSize * oldSize + 1; oldIndex < baseIndexOld + lowerDimSize * oldSize; ++oldIndex) {
                newImageStack.addSlice(this.imageStack.getSliceLabel(oldIndex), this.imageStack.getPixels(oldIndex));
            }
            if (fill) {
                block13: for (newIndex = lowerDimSize * oldSize; newIndex < lowerDimSize * newSize; ++newIndex) {
                    switch (type) {
                        case 0: {
                            newImageStack.addSlice("", (Object)new byte[imageSize]);
                            continue block13;
                        }
                        case 1: {
                            newImageStack.addSlice("", (Object)new short[imageSize]);
                            continue block13;
                        }
                        case 2: {
                            newImageStack.addSlice("", (Object)new float[imageSize]);
                        }
                    }
                }
                continue;
            }
            for (newIndex = lowerDimSize * oldSize; newIndex < lowerDimSize * newSize; ++newIndex) {
                newImageStack.addSlice("", this.dummyImage);
            }
        }
        this.imageStack = newImageStack;
        this.imageStackSize = 1;
        for (int i = 2; i < this.nDimensions; ++i) {
            this.imageStackSize *= dimensionSize[i];
        }
        super.setDimensions(dimensionSize[2], dimensionSize[3], dimensionSize[4]);
        if (dimension == this.colorDimension) {
            ChannelCalibration[] newChCalibration = new ChannelCalibration[newSize];
            System.arraycopy(this.chCalibration, 0, newChCalibration, 0, oldSize);
            for (int i = oldSize; i < newSize; ++i) {
                newChCalibration[i] = new ChannelCalibration();
            }
            this.chCalibration = newChCalibration;
            ChannelDisplayProperties[] newChDisplayProps = new ChannelDisplayProperties[newSize];
            System.arraycopy(this.chDisplayProps, 0, newChDisplayProps, 0, oldSize);
            for (int i = oldSize; i < newSize; ++i) {
                newChDisplayProps[i] = new ChannelDisplayProperties();
            }
            this.chDisplayProps = newChDisplayProps;
            ImageProcessor[] newChannelIPs = new ImageProcessor[newSize];
            System.arraycopy(this.channelIPs, 0, newChannelIPs, 0, oldSize);
            ChannelImagePlus[] newChannelImps = new ChannelImagePlus[newSize];
            System.arraycopy(this.channelImps, 0, newChannelImps, 0, oldSize);
            for (int i = oldSize; i < newSize; ++i) {
                newChannelIPs[i] = Image5D.createProcessorFromDims(this.getType(), new int[]{this.width, this.height, 1, 1, 1});
                newChannelIPs[i].setPixels(this.imageStack.getPixels(this.getCurrentSliceOffset() + i));
                newChannelIPs[i].setColorModel(this.chDisplayProps[i].getColorModel());
                newChannelIPs[i].setThreshold(this.chDisplayProps[i].getMinThreshold(), this.chDisplayProps[i].getMaxThreshold(), 2);
                newChannelIPs[i].setMinAndMax(this.chDisplayProps[i].getMinValue(), this.chDisplayProps[i].getMaxValue());
                newChannelImps[i] = new ChannelImagePlus("" + (i + 1), newChannelIPs[i]);
            }
            this.channelIPs = newChannelIPs;
            this.channelImps = newChannelImps;
        }
        if (dimension == 3) {
            ImageStack newStack = new ImageStack(this.width, this.height, this.chDisplayProps[this.currentPosition[this.colorDimension]].getColorModel());
            int offs = this.getCurrentStackOffset();
            int incr = this.getCurrentStackIncrement();
            for (int i = 0; i < dimensionSize[3]; ++i) {
                newStack.addSlice(this.imageStack.getSliceLabel(offs + i * incr), this.imageStack.getPixels(offs + i * incr));
            }
            this.setStack(null, newStack);
        }
        if (this.win != null) {
            ((Image5DWindow)this.win).updateCanvasses();
        }
        this.setSlice(this.currentPosition[3] + 1);
    }

    public void setDimensions(int nChannels, int nSlices, int nFrames) {
    }

    protected int getCurrentSliceOffset() {
        return this.currentPosition[4] * this.getNSlices() * this.getNChannels() + this.currentPosition[3] * this.getNChannels() + 1;
    }

    protected int getCurrentStackOffset() {
        return this.currentPosition[4] * this.getNSlices() * this.getNChannels() + this.currentPosition[2] + 1;
    }

    protected int getCurrentStackIncrement() {
        return this.getNChannels();
    }

    protected void checkChannel(int channel) {
        if (channel < 1 || channel > this.getNChannels()) {
            throw new IllegalArgumentException("Invalid channel: " + channel);
        }
    }

    protected void checkSlice(int slice) {
        if (slice < 1 || slice > this.getNSlices()) {
            throw new IllegalArgumentException("Invalid slice: " + slice);
        }
    }

    protected void checkFrame(int frame) {
        if (frame < 1 || frame > this.getNFrames()) {
            throw new IllegalArgumentException("Invalid frame: " + frame);
        }
    }

    public ChannelImagePlus getChannelImagePlus(int channel) {
        this.checkChannel(channel);
        return this.channelImps[channel - 1];
    }

    public ChannelCalibration getChannelCalibration(int channel) {
        this.checkChannel(channel);
        return this.chCalibration[channel - 1];
    }

    public void setChannelCalibration(int channel, ChannelCalibration cal) {
        this.checkChannel(channel);
        this.chCalibration[channel - 1] = cal;
    }

    public ChannelDisplayProperties getChannelDisplayProperties(int channel) {
        this.checkChannel(channel);
        return this.chDisplayProps[channel - 1];
    }

    public void setChannelDisplayProperties(int channel, ChannelDisplayProperties props) {
        this.checkChannel(channel);
        this.chDisplayProps[channel - 1] = props;
    }

    public void storeCurrentChannelProperties() {
        int channel = this.getCurrentChannel();
        this.storeChannelProperties(channel);
        ChannelCalibration chCal = this.chCalibration[channel - 1];
        if (this.getGlobalCalibration() == null) {
            Calibration cal = this.getCalibration();
            chCal.setFunction(cal.getFunction(), cal.getCoefficients(), cal.getValueUnit(), cal.zeroClip());
        }
    }

    public void restoreCurrentChannelProperties() {
        int channel = this.getCurrentChannel();
        this.restoreChannelProperties(channel);
        ChannelCalibration chCal = this.chCalibration[channel - 1];
        if (this.getGlobalCalibration() == null) {
            Calibration cal = this.getCalibration();
            cal.setFunction(chCal.getFunction(), chCal.getCoefficients(), chCal.getValueUnit(), chCal.isZeroClip());
        }
    }

    public void storeChannelProperties(int channel) {
        this.checkChannel(channel);
        ChannelDisplayProperties props = this.chDisplayProps[channel - 1];
        ImageProcessor channelIP = this.channelIPs[channel - 1];
        if (!props.isDisplayedGray() && !this.displayAllGray) {
            props.setColorModel(channelIP.getColorModel());
        }
        props.setMinValue(channelIP.getMin());
        props.setMaxValue(channelIP.getMax());
        props.setMinThreshold(channelIP.getMinThreshold());
        props.setMaxThreshold(channelIP.getMaxThreshold());
        props.setLutUpdateMode(channelIP.getLutUpdateMode());
    }

    public void restoreChannelProperties(int channel) {
        this.checkChannel(channel);
        ChannelDisplayProperties props = this.chDisplayProps[channel - 1];
        ImageProcessor channelIP = this.channelIPs[channel - 1];
        if (props.isDisplayedGray() || this.displayAllGray) {
            channelIP.setColorModel((ColorModel)grayColorModel);
            if (channel == this.getCurrentChannel()) {
                this.getStack().setColorModel((ColorModel)grayColorModel);
            }
        } else {
            channelIP.setColorModel(props.getColorModel());
            if (channel == this.getCurrentChannel()) {
                this.getStack().setColorModel(props.getColorModel());
            }
        }
        channelIP.setMinAndMax(props.getMinValue(), props.getMaxValue());
        if (props.getMinThreshold() != -808080.0) {
            channelIP.setThreshold(props.getMinThreshold(), props.getMaxThreshold(), props.getLutUpdateMode());
        }
    }

    public ImageProcessor getProcessor(int channel) {
        this.checkChannel(channel);
        return this.channelIPs[channel - 1];
    }

    public Image5D duplicate() {
        String newTitle = WindowManager.makeUniqueName((String)this.getTitle());
        ImagePlus impOrig = new ImagePlus(newTitle, this.imageStack);
        ImagePlus impCopy = new Duplicater().duplicateStack(impOrig, newTitle);
        ImageStack stackCopy = impCopy.getStack();
        Image5D i5d = new Image5D(newTitle, stackCopy, this.getNChannels(), this.getNSlices(), this.getNFrames());
        i5d.setCalibration(this.getCalibration().copy());
        for (int i = 0; i < this.getNChannels(); ++i) {
            i5d.setCurrentPosition(0, 0, i, 0, 0);
            i5d.chCalibration[i] = this.chCalibration[i].copy();
            i5d.chDisplayProps[i] = this.chDisplayProps[i].copy();
            i5d.restoreCurrentChannelProperties();
        }
        i5d.setDisplayGrayInTiles(this.displayGrayInTiles);
        i5d.setDisplayMode(this.displayMode);
        i5d.setCurrentPosition(this.currentPosition);
        return i5d;
    }

    private static ImageStack createStackFromProcessor(ImageProcessor ip) {
        if (ip == null) {
            throw new IllegalArgumentException("ImageProcessor is null.");
        }
        ImageStack is = new ImageStack(ip.getWidth(), ip.getHeight(), ip.getColorModel());
        is.addSlice("", ip);
        return is;
    }

    protected static ImageProcessor createProcessorFromDims(int type, int[] dimensionSizes) {
        ByteProcessor ip;
        if (dimensionSizes.length != 5) {
            throw new IllegalArgumentException("Invalid number of dimensions.");
        }
        switch (type) {
            case 0: {
                ip = new ByteProcessor(dimensionSizes[0], dimensionSizes[1]);
                break;
            }
            case 1: {
                ip = new ShortProcessor(dimensionSizes[0], dimensionSizes[1]);
                break;
            }
            case 2: {
                ip = new FloatProcessor(dimensionSizes[0], dimensionSizes[1]);
                break;
            }
            default: {
                Object ip2 = null;
                throw new IllegalArgumentException("Invalid data type.");
            }
        }
        return ip;
    }

    protected static ImageStack createZStackFromImageStack(ImageStack imageStack, int nChannels, int nSlices, int nFrames) {
        if (imageStack == null) {
            throw new IllegalArgumentException("ImageStack is null");
        }
        if (nChannels < 1 | nSlices < 1 | nFrames < 1) {
            throw new IllegalArgumentException("Stack dimensions must be >=1.");
        }
        if (nChannels * nSlices * nFrames != imageStack.getSize()) {
            throw new IllegalArgumentException("Dimensions don't match ImageStack size.");
        }
        ImageStack stack = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 0; i < nSlices; ++i) {
            stack.addSlice(imageStack.getSliceLabel(nChannels * i + 1), imageStack.getPixels(nChannels * i + 1));
        }
        return stack;
    }
}

