/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

class HypervolumeOpenerDialog
extends GenericDialog {
    private static final long serialVersionUID = 4208097793696642019L;
    ImagePlus imp;
    int fileCount;
    boolean eightBits;
    String saveFilter = "";
    String[] list;

    public HypervolumeOpenerDialog(String title, ImagePlus imp, String[] list) {
        super(title);
        this.imp = imp;
        this.list = list;
        this.fileCount = list.length;
    }

    protected void setup() {
        this.setStackInfo();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setStackInfo();
    }

    public void textValueChanged(TextEvent e) {
        this.setStackInfo();
    }

    void setStackInfo() {
        int n2;
        TextField tf;
        String filter;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int bytesPerPixel = 1;
        int nSlices = this.imp.getStackSize();
        this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
        int n = this.getNumber(this.numberField.elementAt(0));
        int start = this.getNumber(this.numberField.elementAt(1));
        int inc = this.getNumber(this.numberField.elementAt(2));
        double scale = this.getNumber(this.numberField.elementAt(3));
        if (scale < 5.0) {
            scale = 5.0;
        }
        if (scale > 100.0) {
            scale = 100.0;
        }
        if (n < 1) {
            n = this.fileCount;
        }
        if (start < 1 || start > this.fileCount) {
            start = 1;
        }
        if (start + n - 1 > this.fileCount) {
            n = this.fileCount - start + 1;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (!(filter = (tf = (TextField)this.stringField.elementAt(0)).getText()).equals("") && !filter.equals("*")) {
            n2 = n;
            n = 0;
            for (int i = start - 1; i < start - 1 + n2; ++i) {
                if (this.list[i].indexOf(filter) < 0) continue;
                ++n;
            }
            this.saveFilter = filter;
        }
        switch (this.imp.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
            }
        }
        if (this.eightBits) {
            bytesPerPixel = 1;
        }
        width = (int)((double)width * scale / 100.0);
        height = (int)((double)height * scale / 100.0);
        n2 = n / inc;
        if (n2 < 0) {
            n2 = 0;
        }
        double size = (double)(width * height * nSlices * n2 * bytesPerPixel) / 1048576.0;
        ((Label)this.theLabel).setText(width + " x " + height + " x " + nSlices * n2 + " (" + IJ.d2s((double)size, (int)1) + "MB)");
    }

    public int getNumber(Object field) {
        Double d;
        TextField tf = (TextField)field;
        String theText = tf.getText();
        try {
            d = new Double(theText);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return (int)d.doubleValue();
        }
        return 0;
    }
}

