/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import sc.fiji.i5d.Image5D;

public class Image5D_Extensions
implements PlugIn,
MacroExtension {
    private final ExtensionDescriptor[] extensions = new ExtensionDescriptor[]{ExtensionDescriptor.newDescriptor((String)"getChannel", (MacroExtension)this, (int)18), ExtensionDescriptor.newDescriptor((String)"getFrame", (MacroExtension)this, (int)18), ExtensionDescriptor.newDescriptor((String)"setChannel", (MacroExtension)this, (int)2), ExtensionDescriptor.newDescriptor((String)"setFrame", (MacroExtension)this, (int)2), ExtensionDescriptor.newDescriptor((String)"getDisplayMode", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"setDisplayMode", (MacroExtension)this, (int)1)};

    public void run(String arg) {
        if (!IJ.macroRunning()) {
            IJ.error((String)"Cannot install extensions from outside a macro!");
            return;
        }
        Functions.registerExtensions((MacroExtension)this);
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        return this.extensions;
    }

    public String handleExtension(String name, Object[] args) {
        if (!(IJ.getImage() instanceof Image5D)) {
            IJ.error((String)"Current image is not an Image5D");
        }
        Image5D im5d = (Image5D)IJ.getImage();
        if (name.equals("getChannel")) {
            int[] pos = im5d.getCurrentPosition();
            ((Double[])args[0])[0] = new Double(pos[im5d.getColorDimension()] + 1);
        } else if (name.equals("setChannel")) {
            int ch = ((Double)args[0]).intValue();
            im5d.setChannel(ch);
        } else if (name.equals("getFrame")) {
            int[] pos = im5d.getCurrentPosition();
            ((Double[])args[0])[0] = new Double(pos[4] + 1);
        } else if (name.equals("setFrame")) {
            int fr = ((Double)args[0]).intValue();
            im5d.setFrame(fr);
        } else {
            if (name.equals("getDisplayMode")) {
                int mode = im5d.getDisplayMode();
                switch (mode) {
                    case 1: {
                        return "color";
                    }
                    case 0: {
                        return "gray";
                    }
                    case 2: {
                        return "overlay";
                    }
                }
                return "unknown";
            }
            if (name.equals("setDisplayMode")) {
                String arg = (String)args[0];
                if (arg.equals("color")) {
                    im5d.setDisplayMode(1);
                } else if (arg.equals("gray")) {
                    im5d.setDisplayMode(0);
                } else if (arg.equals("overlay")) {
                    im5d.setDisplayMode(2);
                } else {
                    IJ.error((String)("Illegal display mode value: " + arg));
                    return null;
                }
            }
        }
        return null;
    }
}

