/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.util;

import fiji.util.gui.GenericDialogPlus;
import ij.Prefs;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class PluginHelper {
    public static boolean useFileDialog = true;

    public static void addSaveAsFileField(GenericDialogPlus dialog, String label, String defaultPath, int columns) {
        dialog.addStringField(label, defaultPath, columns);
        TextField text = (TextField)dialog.getStringFields().lastElement();
        GridBagLayout layout = (GridBagLayout)dialog.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        Button button = new Button("Browse...");
        ChooseXmlFileListener listener = new ChooseXmlFileListener(text);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)dialog);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        dialog.add((Component)panel);
    }

    public static int[][] parseResolutionsString(String s) {
        String regex = "\\{\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\}";
        Pattern pattern = Pattern.compile("\\{\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\}");
        Matcher matcher = pattern.matcher(s);
        ArrayList<int[]> tmp = new ArrayList<int[]>();
        while (matcher.find()) {
            int[] resolution = new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))};
            tmp.add(resolution);
        }
        int[][] resolutions = new int[tmp.size()][];
        for (int i = 0; i < resolutions.length; ++i) {
            resolutions[i] = (int[])tmp.get(i);
        }
        return resolutions;
    }

    public static File createNewPartitionFile(String baseFilename) throws IOException {
        File hdf5File = new File(String.format("%s.h5", baseFilename));
        if (!hdf5File.exists() && hdf5File.createNewFile()) {
            return hdf5File;
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            hdf5File = new File(String.format("%s-%d.h5", baseFilename, i));
            if (hdf5File.exists() || !hdf5File.createNewFile()) continue;
            return hdf5File;
        }
        throw new RuntimeException("could not generate new partition filename");
    }

    public static int numThreads() {
        return Math.max(1, Prefs.getThreads());
    }

    public static class ChooseXmlFileListener
    implements ActionListener {
        TextField text;

        public ChooseXmlFileListener(TextField text) {
            this.text = text;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File directory;
            String fn = directory.getName();
            for (directory = new File(this.text.getText()); directory != null && !directory.exists(); directory = directory.getParentFile()) {
            }
            if (Prefs.useJFileChooser) {
                JFileChooser fc = new JFileChooser(directory);
                fc.setSelectedFile(new File(fn));
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "xml files";
                    }

                    @Override
                    public boolean accept(File f) {
                        String s;
                        int i;
                        if (f.isDirectory()) {
                            return true;
                        }
                        if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                            String ext = s.substring(i + 1).toLowerCase();
                            return ext.equals("xml");
                        }
                        return false;
                    }
                });
                fc.setFileSelectionMode(0);
                int returnVal = fc.showSaveDialog(null);
                if (returnVal == 0) {
                    String f = fc.getSelectedFile().getAbsolutePath();
                    if (!f.endsWith(".xml")) {
                        f = f + ".xml";
                    }
                    this.text.setText(f);
                }
            } else {
                FileDialog fd = new FileDialog((Frame)null, "Save", 1);
                fd.setDirectory(directory.getAbsolutePath());
                fd.setFile(fn);
                fd.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        int i = name.lastIndexOf(46);
                        if (i > 0 && i < name.length() - 1) {
                            String ext = name.substring(i + 1).toLowerCase();
                            return ext.equals("xml");
                        }
                        return false;
                    }
                });
                fd.setVisible(true);
                String filename = fd.getFile();
                if (filename != null) {
                    String f = new File(fd.getDirectory() + filename).getAbsolutePath();
                    if (!f.endsWith(".xml")) {
                        f = f + ".xml";
                    }
                    this.text.setText(f);
                }
            }
        }
    }
}

