/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.SexpPool;
import org.renjin.compiler.ThunkMap;
import org.renjin.compiler.ir.tac.IRFunction;

public class GenerationContext {
    private String className;
    private SexpPool sexpPool;
    private ThunkMap thunkMap;
    private Map<String, IRFunction> closures = Maps.newHashMap();
    private int contextLdc = 1;
    private int environmentLdc = 2;

    public GenerationContext(String className, SexpPool sexpPool, ThunkMap thunkMap) {
        this.className = className;
        this.sexpPool = sexpPool;
        this.thunkMap = thunkMap;
    }

    public int getContextLdc() {
        return this.contextLdc;
    }

    public int getEnvironmentLdc() {
        return this.environmentLdc;
    }

    public void setContextLdc(int contextLdc) {
        this.contextLdc = contextLdc;
    }

    public void setEnvironmentLdc(int environmentLdc) {
        this.environmentLdc = environmentLdc;
    }

    public int getFirstFreeLocalVariable() {
        return Math.max(this.contextLdc, this.environmentLdc) + 1;
    }

    public String getClassName() {
        return this.className;
    }

    public SexpPool getSexpPool() {
        return this.sexpPool;
    }

    public ThunkMap getThunkMap() {
        return this.thunkMap;
    }

    public String addClosure(IRFunction fn) {
        String className = this.className + "$closure$" + this.closures.size();
        this.closures.put(className, fn);
        return className;
    }

    public List<Map.Entry<String, IRFunction>> getNestedClosures() {
        return Lists.newArrayList(this.closures.entrySet());
    }
}

