/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class CmpGE
implements SimpleExpression {
    private Expression op1;
    private Expression op2;

    public CmpGE(Expression op1, Expression op2) {
        this.op1 = op1;
        this.op2 = op2;
    }

    public String toString() {
        return this.op1 + " >= " + this.op2;
    }

    public Expression getOp1() {
        return this.op1;
    }

    public Expression getOp2() {
        return this.op2;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        Integer a = (Integer)this.op1.retrieveValue(context, temps);
        Integer b = (Integer)this.op2.retrieveValue(context, temps);
        return a >= b;
    }

    @Override
    public Set<Variable> variables() {
        return Sets.union(this.op1.variables(), this.op2.variables());
    }

    @Override
    public CmpGE replaceVariable(Variable name, Variable newName) {
        return new CmpGE(this.op1.replaceVariable(name, newName), this.op2.replaceVariable(name, newName));
    }

    @Override
    public List<Expression> getChildren() {
        return Arrays.asList(this.op1, this.op2);
    }

    @Override
    public void setChild(int i, Expression expr) {
        if (i == 0) {
            this.op1 = expr;
        } else if (i == 1) {
            this.op2 = expr;
        } else {
            throw new IllegalArgumentException("i=" + i);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitCmpGE(this);
    }

    @Override
    public SEXP getSExpression() {
        throw new UnsupportedOperationException();
    }
}

