/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.eval.Context;

public class ExprStatement
implements Statement {
    private Expression operand;

    public ExprStatement(Expression operand) {
        this.operand = operand;
    }

    @Override
    public Object interpret(Context context, Object[] temp) {
        this.operand.retrieveValue(context, temp);
        return null;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    @Override
    public Expression getRHS() {
        return this.operand;
    }

    public String toString() {
        return this.operand.toString();
    }

    @Override
    public Set<Variable> variables() {
        return this.operand.variables();
    }

    @Override
    public Statement withRHS(Expression newRHS) {
        return new ExprStatement(newRHS);
    }

    @Override
    public List<Expression> getChildren() {
        return Arrays.asList(this.operand);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.operand = child;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitExprStatement(this);
    }
}

