/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.primitives.special.ReturnException;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Calls {
    public static PairList evaluateList(Context context, Environment rho, PairList args2) {
        PairList.Builder evaled = new PairList.Builder();
        for (PairList.Node node : args2.nodes()) {
            evaled.add(node.getRawTag(), context.evaluate(node.getValue(), rho));
        }
        return evaled.build();
    }

    public static SEXP applyClosure(Closure closure, Context context, Environment callingEnvironment, FunctionCall call2, PairList promisedArgs, Frame suppliedEnvironment) {
        Context functionContext = context.beginFunction(callingEnvironment, call2, closure, promisedArgs);
        Environment functionEnvironment = functionContext.getEnvironment();
        try {
            Calls.matchArgumentsInto(closure.getFormals(), promisedArgs, functionContext, functionEnvironment);
            for (Symbol name : suppliedEnvironment.getSymbols()) {
                functionEnvironment.setVariable(name, suppliedEnvironment.getVariable(name));
            }
            SEXP result = functionContext.evaluate(closure.getBody(), functionEnvironment);
            functionContext.exit();
            return result;
        }
        catch (ReturnException e) {
            if (e.getEnvironment() != functionEnvironment) {
                throw e;
            }
            return e.getValue();
        }
    }

    public static PairList promiseArgs(PairList el, Context context, Environment rho) {
        PairList.Builder list2 = new PairList.Builder();
        for (PairList.Node node : el.nodes()) {
            if (node.getValue().equals(Symbols.ELLIPSES)) {
                PromisePairList dotExp = (PromisePairList)rho.findVariable(Symbols.ELLIPSES);
                for (PairList.Node dotNode : dotExp.nodes()) {
                    list2.add(dotNode.getRawTag(), dotNode.getValue());
                }
                continue;
            }
            if (node.getValue() == Symbol.MISSING_ARG) {
                list2.add(node.getRawTag(), node.getValue());
                continue;
            }
            if (node.getValue() instanceof Promise) {
                list2.add(node.getRawTag(), node.getValue());
                continue;
            }
            list2.add(node.getRawTag(), (SEXP)Promise.repromise(rho, node.getValue()));
        }
        return list2.build();
    }

    public static PairList stripDefaultValues(PairList formals2) {
        PairList.Builder result = new PairList.Builder();
        for (PairList.Node node : formals2.nodes()) {
            result.add(node.getRawTag(), (SEXP)Symbol.MISSING_ARG);
        }
        return result.build();
    }

    public static void matchArgumentsInto(PairList formals2, PairList actuals, Context innerContext, Environment innerEnv) {
        ClosureDispatcher.matchArgumentsInto(formals2, actuals, innerContext, innerEnv);
    }

    public static PairList matchArguments(PairList formals2, PairList actuals, boolean populateMissing) {
        return ClosureDispatcher.matchArguments(formals2, actuals, populateMissing);
    }
}

