/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public enum ClippingMode {
    PLOT(Logical.FALSE),
    FIGURE(Logical.TRUE),
    DEVICE(Logical.NA);

    private final Logical logicalValue;

    private ClippingMode(Logical logicalValue) {
        this.logicalValue = logicalValue;
    }

    public LogicalVector toExp() {
        return new LogicalArrayVector(this.logicalValue);
    }

    public static ClippingMode fromExp(SEXP exp2) {
        if (exp2 instanceof LogicalVector) {
            switch (((LogicalVector)exp2).getElementAsLogical(0)) {
                case FALSE: {
                    return PLOT;
                }
                case TRUE: {
                    return FIGURE;
                }
                case NA: {
                    return DEVICE;
                }
            }
        }
        throw new IllegalArgumentException(exp2.toString());
    }
}

