/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.packaging;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.renjin.eval.Context;
import org.renjin.packaging.SerializedPromise;
import org.renjin.primitives.io.serialization.RDataWriter;
import org.renjin.sexp.Environment;
import org.renjin.sexp.NamedValue;

public class LazyLoadFrameBuilder {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private File outputDir;
    private Context context;
    private Predicate<NamedValue> filter = Predicates.alwaysTrue();

    public LazyLoadFrameBuilder(Context context) {
        this.context = context;
    }

    public LazyLoadFrameBuilder outputTo(File dir2) {
        this.outputDir = dir2;
        return this;
    }

    public LazyLoadFrameBuilder filter(Predicate<NamedValue> filter) {
        this.filter = filter;
        return this;
    }

    public void build(Environment env2) throws IOException {
        Iterable toWrite = Iterables.filter(env2.namedValues(), this.filter);
        File indexFile = new File(this.outputDir, "environment");
        DataOutputStream indexOut = new DataOutputStream(new FileOutputStream(indexFile));
        indexOut.writeInt(2);
        indexOut.writeInt(Iterables.size((Iterable)toWrite));
        for (NamedValue namedValue : toWrite) {
            indexOut.writeUTF(namedValue.getName());
            byte[] bytes = this.serializeSymbol(namedValue);
            if (bytes.length > 1024) {
                indexOut.writeInt(-1);
                Files.write((byte[])bytes, (File)new File(this.outputDir, SerializedPromise.resourceName(namedValue.getName())));
                continue;
            }
            indexOut.writeInt(bytes.length);
            indexOut.write(bytes);
        }
        indexOut.close();
    }

    private byte[] serializeSymbol(NamedValue namedValue) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDataWriter writer = new RDataWriter(this.context, (OutputStream)baos);
        writer.serialize(namedValue.getValue());
        baos.close();
        return baos.toByteArray();
    }
}

