/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.renjin.RVersion;
import org.renjin.RenjinVersion;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.Capabilities;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class System {
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final int LC_ALL = 1;

    @Internal
    public static String getRHome(@Current Context context) throws URISyntaxException {
        return context.getSession().getHomeDirectory();
    }

    @Internal
    public static ListVector Version() {
        return ListVector.newNamedBuilder().add("platform", "i386-pc-mingw32").add("arch", "i386").add("os", "mingw32").add("system", "i386, mingw32").add("status", "").add("major", RVersion.MAJOR).add("minor", RVersion.MINOR).add("year", "2009").add("month", "12").add("day", "14").add("engine", "Renjin").add("language", "R").add("svn rev", "50720").add("version.string", "Renjin version " + RenjinVersion.getVersionName()).build();
    }

    @Internal(value="Sys.getenv")
    public static StringVector getEnvironment(@Current Context context, StringVector names2, String unset) {
        StringVector.Builder result = new StringVector.Builder();
        Map<String, String> map = context.getSession().getSystemEnvironment();
        if (names2.length() == 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.add(entry.getKey() + "=" + entry.getValue());
            }
        } else {
            for (String name : names2) {
                String value = map.get(name);
                result.add(value == null ? unset : value);
            }
        }
        return result.build();
    }

    @Internal(value="Sys.setenv")
    public static LogicalVector setEnvironment(@Current Context context, StringVector names2, StringVector values) {
        Map<String, String> map = context.getSession().getSystemEnvironment();
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        for (int i = 0; i != names2.length(); ++i) {
            map.put(names2.getElementAsString(i), values.getElementAsString(i));
            result.add(true);
        }
        return result.build();
    }

    @Invisible
    @Internal(value="Sys.unsetenv")
    public static LogicalVector unsetEnvironment(@Current Context context, StringVector names2) {
        Map<String, String> map = context.getSession().getSystemEnvironment();
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        for (int i = 0; i != names2.length(); ++i) {
            map.remove(names2.getElementAsString(i));
            result.add(true);
        }
        return result.build();
    }

    @Internal(value="Sys.getlocale")
    public static String getLocale(int categoryIndex) {
        if (categoryIndex == 1) {
            StringBuilder info2 = new StringBuilder();
            boolean needsSemi = false;
            for (LocaleCategory category : LocaleCategory.values()) {
                if (needsSemi) {
                    info2.append(';');
                } else {
                    needsSemi = true;
                }
                info2.append(category.name()).append('=').append(category.value());
            }
            return info2.toString();
        }
        return LocaleCategory.values()[categoryIndex - 2].value();
    }

    @Internal(value="Sys.setlocale")
    public static String setLocale(int categoryIndex, String locale) {
        java.lang.System.out.println("locale = " + locale);
        return "";
    }

    @Internal
    public static StringVector commandArgs(@Current Context context) {
        return context.getSession().getCommandLineArguments();
    }

    @Internal
    public static LogicalVector capabilities(StringVector what) {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        StringVector.Builder names2 = new StringVector.Builder();
        for (String capability : what) {
            if (!Capabilities.NAMES.contains(capability)) continue;
            names2.add(capability);
            result.add(false);
        }
        result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        return result.build();
    }

    @Internal
    public static LogicalVector capabilities() {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        StringVector.Builder names2 = new StringVector.Builder();
        for (String capability : Capabilities.NAMES) {
            names2.add(capability);
            result.add(false);
        }
        result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        return result.build();
    }

    @Internal
    public static StringVector date() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
        StringVector.Builder b = new StringVector.Builder();
        Date d = new Date();
        String parsed = null;
        parsed = sdf.format(d);
        b.add(parsed);
        return b.build();
    }

    @Internal(value="Sys.info")
    public static StringVector sysInfo() {
        StringVector.Builder sb = new StringVector.Builder();
        sb.add(java.lang.System.getProperty("os.name"));
        sb.add(java.lang.System.getProperty("os.version"));
        sb.add(java.lang.System.getProperty("os.build"));
        try {
            sb.add(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            sb.add("Can not get hostname");
        }
        sb.add(java.lang.System.getProperty("os.arch"));
        sb.add(java.lang.System.getProperty("login.name"));
        sb.add(java.lang.System.getProperty("user.name"));
        sb.setAttribute("names", (SEXP)new StringArrayVector("sysname", "release", "version", "nodename", "machine", "login", "user"));
        return sb.build();
    }

    @Internal(value="Sys.getpid")
    public static int SysGetPid() {
        String name;
        try {
            name = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (Exception e) {
            throw new EvalException("Can not catch the pid.", e);
        }
        int atIndex = name.indexOf("@");
        int result = 1;
        try {
            result = Integer.parseInt(name.substring(0, atIndex));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Internal(value="Sys.sleep")
    public static void SysSleep(double seconds) {
        try {
            Thread.currentThread();
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException ie) {
            throw new EvalException("Sys.sleep interrupted", new Object[0]);
        }
    }

    @Internal
    public static DoubleVector gc(@Current Context context, boolean verbose, boolean reset) {
        java.lang.System.gc();
        context.getSession().runFinalizers();
        return new DoubleArrayVector(new double[0]);
    }

    @Builtin(value="proc.time")
    public static DoubleVector procTime() {
        long elapsedTime;
        long totalCPUTime;
        long userCPUTime;
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder();
        StringVector.Builder names2 = new StringVector.Builder();
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            userCPUTime = TimeUnit.NANOSECONDS.toMillis(threadMXBean.getCurrentThreadUserTime());
            totalCPUTime = TimeUnit.NANOSECONDS.toMillis(threadMXBean.getCurrentThreadCpuTime());
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            elapsedTime = runtimeMXBean.getUptime();
        }
        catch (Error e) {
            totalCPUTime = elapsedTime = java.lang.System.currentTimeMillis();
            userCPUTime = elapsedTime;
        }
        names2.add("user.self");
        result.add((double)userCPUTime / 1000.0);
        names2.add("sys.self");
        result.add((double)(totalCPUTime - userCPUTime) / 1000.0);
        names2.add("elapsed");
        result.add((double)elapsedTime / 1000.0);
        names2.add("user.child");
        result.add(0.0);
        names2.add("sys.child");
        result.add(0.0);
        result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        result.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("proc_time"));
        return result.build();
    }

    @Internal
    public static String machine() {
        return "Unix";
    }

    @Internal
    public static void dirchmod(StringVector dir2) {
    }

    @Internal(value="Sys.chmod")
    public static boolean sysChmod(@Recycle String path2, int mode, boolean useUmask) {
        return false;
    }

    @Internal(value="Sys.umask")
    public static int sysChmod(int umask2) {
        return 0;
    }

    @Internal(value="system")
    public static SEXP system(@Current Context context, String command, int flag, SEXP stdin2, SEXP stdout2, SEXP stderr2) throws IOException, InterruptedException {
        boolean invisible2 = flag >= 20 && flag < 29;
        boolean minimized = flag >= 10 && flag < 19;
        List<String> args2 = System.parseArgs(command);
        ProcessBuilder builder = new ProcessBuilder(args2);
        FileObject workingDir = context.getSession().getWorkingDirectory();
        if (workingDir instanceof LocalFile) {
            File localDir = new File(workingDir.getURL().getFile());
            builder.directory(localDir);
        }
        Process process = builder.start();
        process.waitFor();
        int exitValue = process.exitValue();
        return new IntArrayVector(exitValue);
    }

    @VisibleForTesting
    static List<String> parseArgs(String commandLine) {
        ArrayList terms2 = Lists.newArrayList();
        boolean dquoted = false;
        boolean squoted = false;
        char lastChar = '\u0000';
        StringBuilder currentTerm = new StringBuilder();
        for (int i = 0; i != commandLine.length(); ++i) {
            char c2 = commandLine.charAt(i);
            if (!dquoted && !squoted && Character.isWhitespace(c2)) {
                if (!Character.isWhitespace(lastChar)) {
                    terms2.add(currentTerm.toString());
                    currentTerm.setLength(0);
                }
            } else if (!squoted && c2 == '\"') {
                dquoted = !dquoted;
            } else if (!dquoted && c2 == '\'') {
                squoted = !squoted;
            } else {
                currentTerm.append(c2);
            }
            lastChar = c2;
        }
        if (currentTerm.length() > 0) {
            terms2.add(currentTerm.toString());
        }
        return terms2;
    }

    private static enum LocaleCategory {
        LC_COLLATE,
        LC_MONETARY,
        LC_NUMERIC,
        LC_TIME,
        LC_MESSAGES,
        LC_PAPER,
        LC_MEASUREMENT;


        String value() {
            return "English_United States.1252";
        }
    }
}

