/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.SessionScoped;
import org.renjin.primitives.packaging.BaseNamespace;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceFile;
import org.renjin.primitives.packaging.Package;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

@SessionScoped
public class NamespaceRegistry {
    private static final Symbol BASE = Symbol.get("base");
    public static final Set<String> CORE_PACKAGES = Sets.newHashSet((Object[])new String[]{"datasets", "graphics", "grDevices", "hamcrest", "methods", "splines", "stats", "stats4", "utils", "grid", "parallel", "tools"});
    private PackageLoader loader;
    private Multimap<Symbol, Namespace> localNameMap = HashMultimap.create();
    private Map<FqPackageName, Namespace> namespaceMap = Maps.newHashMap();
    private Map<Environment, Namespace> envirMap = Maps.newIdentityHashMap();
    private final Namespace baseNamespace;

    public NamespaceRegistry(PackageLoader loader, Context context, Environment baseNamespaceEnv) {
        this.loader = loader;
        this.baseNamespace = new BaseNamespace(baseNamespaceEnv);
        this.localNameMap.put((Object)BASE, (Object)this.baseNamespace);
        this.envirMap.put(baseNamespaceEnv, this.baseNamespace);
    }

    public Namespace getBaseNamespace() {
        return this.baseNamespace;
    }

    public Environment getBaseNamespaceEnv() {
        return this.getBaseNamespace().getNamespaceEnvironment();
    }

    public Namespace getNamespace(Environment envir) {
        Namespace ns = this.envirMap.get(envir);
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        return ns;
    }

    public Iterable<Symbol> getLoadedNamespaces() {
        return this.localNameMap.keySet();
    }

    public Optional<Namespace> getNamespaceIfPresent(Symbol name) {
        Collection matching = this.localNameMap.get((Object)name);
        if (matching.size() == 1) {
            return Optional.of(matching.iterator().next());
        }
        return Optional.absent();
    }

    public Namespace getNamespace(Context context, String name) {
        return this.getNamespace(context, Symbol.get(name));
    }

    public Namespace getNamespace(Context context, Symbol symbol2) {
        FqPackageName candidate;
        if (symbol2.getPrintName().equals("base")) {
            return this.baseNamespace;
        }
        for (FqPackageName fqPackageName : this.namespaceMap.keySet()) {
            if (!symbol2.getPrintName().equals(fqPackageName.toString('.')) && !symbol2.getPrintName().equals(fqPackageName.getPackageName())) continue;
            return this.namespaceMap.get(fqPackageName);
        }
        if (CORE_PACKAGES.contains(symbol2.getPrintName())) {
            return this.getNamespace(context, FqPackageName.corePackage(symbol2));
        }
        ArrayList candidates = Lists.newArrayList();
        if (this.couldBeFullyQualified(symbol2)) {
            candidates.add(FqPackageName.fromSymbol(symbol2));
        }
        candidates.add(new FqPackageName("org.renjin.bioconductor", symbol2.getPrintName()));
        candidates.add(new FqPackageName("org.renjin.cran", symbol2.getPrintName()));
        Optional<Namespace> namespace = Optional.absent();
        Iterator i$ = candidates.iterator();
        while (i$.hasNext() && !(namespace = this.tryGetNamespace(context, candidate = (FqPackageName)i$.next())).isPresent()) {
        }
        if (!namespace.isPresent()) {
            throw new EvalException("Could not load package " + symbol2 + "; tried " + Joiner.on((String)", ").join((Iterable)candidates), new Object[0]);
        }
        return (Namespace)namespace.get();
    }

    public static Set<String> getCorePackages() {
        return CORE_PACKAGES;
    }

    public Namespace getNamespace(Context context, FqPackageName fqPackageName) {
        Optional<Namespace> namespace = this.tryGetNamespace(context, fqPackageName);
        if (!namespace.isPresent()) {
            throw new EvalException("Could not load package " + fqPackageName, new Object[0]);
        }
        return (Namespace)namespace.get();
    }

    private Optional<Namespace> tryGetNamespace(Context context, FqPackageName fqName) {
        if (this.namespaceMap.containsKey(fqName)) {
            return Optional.of((Object)this.namespaceMap.get(fqName));
        }
        return this.tryLoad(context, fqName);
    }

    private Optional<Namespace> tryLoad(Context context, FqPackageName fqName) {
        Optional<Package> loadResult = this.loader.load(fqName);
        if (!loadResult.isPresent()) {
            return Optional.absent();
        }
        Package pkg = (Package)loadResult.get();
        try {
            Namespace namespace = this.createNamespace(pkg);
            this.populateNamespace(context, pkg, namespace);
            this.setupImportsExports(context, pkg, namespace);
            if (namespace.getNamespaceEnvironment().hasVariable(Symbol.get(".onLoad"))) {
                StringVector nameArgument = StringVector.valueOf(pkg.getName().getPackageName());
                context.evaluate(FunctionCall.newCall(Symbol.get(".onLoad"), nameArgument, nameArgument), namespace.getNamespaceEnvironment());
            }
            return Optional.of((Object)namespace);
        }
        catch (Exception e) {
            throw new EvalException("IOException while loading package " + fqName + ": " + e.getMessage(), e);
        }
    }

    private boolean couldBeFullyQualified(Symbol name) {
        String string = name.getPrintName();
        return string.indexOf(58) != -1 || string.indexOf(46) != -1;
    }

    private void populateNamespace(Context context, Package pkg, Namespace namespace) throws IOException {
        for (NamedValue value : pkg.loadSymbols(context)) {
            namespace.getNamespaceEnvironment().setVariable(Symbol.get(value.getName()), value.getValue());
        }
    }

    private void setupImportsExports(Context context, Package pkg, Namespace namespace) throws IOException {
        try {
            CharSource namespaceSource = pkg.getResource("NAMESPACE").asCharSource(Charsets.UTF_8);
            NamespaceFile namespaceFile = NamespaceFile.parse(context, namespaceSource);
            namespace.initImports(context, this, namespaceFile);
            namespace.initExports(namespaceFile);
            namespace.registerS3Methods(context, namespaceFile);
        }
        catch (Exception e) {
            throw new EvalException("Exception setting up imports/exports for namespace " + namespace.getName() + ": " + e.getMessage(), e);
        }
    }

    public boolean isRegistered(Symbol name) {
        return this.localNameMap.containsKey((Object)name);
    }

    public Namespace getBase() {
        return this.baseNamespace;
    }

    public Namespace createNamespace(Package pkg) {
        Environment imports = Environment.createNamedEnvironment(this.getBaseNamespaceEnv(), "imports:" + pkg.getName().toString('.'));
        Environment namespaceEnv = Environment.createNamespaceEnvironment(imports, pkg.getName().getPackageName());
        Namespace namespace = new Namespace(pkg, namespaceEnv);
        this.localNameMap.put((Object)pkg.getName().getPackageSymbol(), (Object)namespace);
        this.namespaceMap.put(pkg.getName(), namespace);
        this.envirMap.put(namespaceEnv, namespace);
        namespaceEnv.setVariable(".packageName", (SEXP)StringVector.valueOf(pkg.getName().getPackageName()));
        return namespace;
    }

    public boolean isNamespaceEnv(Environment envir) {
        return this.envirMap.containsKey(envir);
    }
}

