/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import org.renjin.eval.EvalException;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.Formula;
import org.renjin.stats.internals.models.Term;
import org.renjin.stats.internals.models.TermBuilder;
import org.renjin.stats.internals.models.TermList;

public class FormulaInterpreter {
    private SEXP response;
    private int intercept = 1;
    private static final Symbol tilde = Symbol.get("~");
    private static final Symbol UNION = Symbol.get("+");
    private static final Symbol EXPAND_TERMS = Symbol.get("*");
    private static final Symbol DIFFERENCE = Symbol.get("-");
    private static final Symbol GROUP = Symbol.get("(");

    public Formula interpret(FunctionCall call2) {
        if (call2.getFunction() != tilde) {
            throw new EvalException("expected model formula (~)", new Object[0]);
        }
        TermList terms2 = new TermList();
        if (call2.getArguments().length() == 1) {
            this.response = null;
            this.add(terms2, (SEXP)call2.getArgument(0));
        } else if (call2.getArguments().length() == 2) {
            this.response = call2.getArgument(0);
            this.add(terms2, (SEXP)call2.getArgument(1));
        }
        return new Formula(this.response, this.intercept, terms2.sorted());
    }

    private TermList buildTermList(SEXP argument, boolean subtracting) {
        TermList list2 = new TermList();
        this.add(list2, argument, subtracting);
        return list2;
    }

    private TermList buildTermList(SEXP argument) {
        return this.buildTermList(argument, false);
    }

    private void add(TermList list2, SEXP argument, boolean subtracting) {
        if (argument instanceof Symbol) {
            list2.add(new Term(argument));
        } else if (argument instanceof Vector) {
            this.intercept((Vector)argument, subtracting);
        } else if (argument instanceof FunctionCall) {
            FunctionCall call2 = (FunctionCall)argument;
            if (call2.getFunction() == UNION) {
                this.unionTerms(list2, call2);
            } else if (call2.getFunction() == EXPAND_TERMS) {
                this.multiply(list2, call2);
            } else if (call2.getFunction() == DIFFERENCE) {
                this.difference(list2, call2);
            } else if (call2.getFunction() == GROUP) {
                this.add(list2, (SEXP)call2.getArgument(0), subtracting);
            } else {
                list2.add(new TermBuilder().build(call2));
            }
        }
    }

    private void add(TermList list2, SEXP argument) {
        this.add(list2, argument, false);
    }

    private void multiply(TermList terms2, FunctionCall call2) {
        TermList a = this.buildTermList((SEXP)call2.getArgument(0));
        TermList b = this.buildTermList((SEXP)call2.getArgument(1));
        terms2.add(a);
        terms2.add(b);
        for (Term a_i : a) {
            for (Term b_i : b) {
                terms2.add(new Term(a_i, b_i));
            }
        }
    }

    private void unionTerms(TermList terms2, FunctionCall call2) {
        for (SEXP argument : call2.getArguments().values()) {
            this.add(terms2, argument);
        }
    }

    private void difference(TermList terms2, FunctionCall call2) {
        if (call2.getArguments().length() == 1) {
            this.buildTermList((SEXP)call2.getArgument(0), true);
        } else {
            TermList a = this.buildTermList((SEXP)call2.getArgument(0));
            TermList b = this.buildTermList((SEXP)call2.getArgument(1), true);
            a.subtract(b);
            terms2.add(a);
        }
    }

    private void intercept(Vector vector2, boolean subtracting) {
        if (vector2.length() != 1) {
            throw new EvalException("Invalid intercept: " + vector2.toString() + ", expected 0 or 1", new Object[0]);
        }
        this.intercept = vector2.getElementAsInt(0);
        if (this.intercept != 0 && this.intercept != 1) {
            throw new EvalException("Invalid intercept: " + this.intercept + ", expected 0 or 1", new Object[0]);
        }
        if (subtracting) {
            this.intercept = this.intercept == 0 ? 1 : 0;
        }
    }
}

