/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.network.client.ArchipelagoClient;
import edu.utexas.clm.archipelago.ui.ClusterUI;
import edu.utexas.clm.archipelago.util.EasyLogger;
import edu.utexas.clm.archipelago.util.IJLogger;
import edu.utexas.clm.archipelago.util.IJPopupLogger;
import edu.utexas.clm.archipelago.util.NullLogger;
import edu.utexas.clm.archipelago.util.PrintStreamLogger;
import ij.gui.GenericDialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;

public final class FijiArchipelago {
    public static final String PREF_ROOT = "FijiArchipelago";
    private static EasyLogger logger = new NullLogger();
    private static EasyLogger errorLogger = new NullLogger();
    private static EasyLogger debugLogger = new NullLogger();
    private static final AtomicLong nextID = new AtomicLong(0L);
    private static String fileRoot = "";
    private static String execRoot = "";

    private FijiArchipelago() {
    }

    public static boolean fileIsInRoot(String path) {
        File file = new File(path);
        return file.getAbsolutePath().startsWith(fileRoot);
    }

    public static synchronized void setFileRoot(String root) {
        fileRoot = root.endsWith("/") ? root : root + "/";
    }

    public static synchronized void setExecRoot(String root) {
        execRoot = root.endsWith("/") ? root : root + "/";
    }

    public static String getFileRoot() {
        return fileRoot;
    }

    public static String getExecRoot() {
        return execRoot;
    }

    public static String truncateFileRoot(String filename) {
        return FijiArchipelago.truncateFileRoot(new File(filename));
    }

    public static String truncateFileRoot(File file) {
        String filename = file.getAbsolutePath();
        if (filename.startsWith(fileRoot)) {
            return filename.replaceFirst(fileRoot, "");
        }
        return filename;
    }

    public static synchronized void setInfoLogger(EasyLogger l) {
        logger = l;
    }

    public static synchronized void setErrorLogger(EasyLogger l) {
        errorLogger = l;
    }

    public static synchronized void setDebugLogger(EasyLogger l) {
        debugLogger = l;
    }

    public static synchronized void log(String s) {
        logger.log(s);
    }

    public static synchronized void err(String s) {
        errorLogger.log(s);
    }

    public static synchronized void debug(String s) {
        debugLogger.log(s);
    }

    public static synchronized void debug(String s, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        debugLogger.log(s + " " + sw);
    }

    public static synchronized long getUniqueID() {
        return nextID.incrementAndGet();
    }

    public static boolean runClientGUI() {
        GenericDialog gd = new GenericDialog("Connect to Cluster as Client");
        gd.addStringField("Host", "");
        gd.addNumericField("Port", 4012.0, 0);
        gd.showDialog();
        try {
            if (gd.wasOKed()) {
                FijiArchipelago.setDebugLogger(new PrintStreamLogger());
                FijiArchipelago.setInfoLogger(new IJLogger());
                FijiArchipelago.setErrorLogger(new IJPopupLogger());
                FijiArchipelago.startClient(gd.getNextString(), (int)gd.getNextNumber(), true);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            FijiArchipelago.err("Could not start client: " + ioe);
            FijiArchipelago.debug("Could not start client: ", ioe);
            return false;
        }
    }

    public static ArchipelagoClient startClient(String host, int port, boolean ui) throws IOException {
        return FijiArchipelago.startClient(host, port, -1L, ui);
    }

    public static ArchipelagoClient startClient(String host, int port, long id, boolean ui) throws IOException {
        final Socket s = new Socket(host, port);
        final ArchipelagoClient client = new ArchipelagoClient(id, s.getInputStream(), s.getOutputStream());
        if (ui) {
            Dimension size = new Dimension(256, 48);
            final Frame frame = new Frame("Archipelago client");
            Panel panel = new Panel();
            final Label label = new Label("Client is running");
            panel.add(label);
            frame.add(panel);
            frame.setMinimumSize(size);
            frame.setSize(size);
            frame.setPreferredSize(size);
            panel.setMinimumSize(size);
            panel.setSize(size);
            panel.setPreferredSize(size);
            frame.validate();
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GenericDialog gd = new GenericDialog("Sure?");
                    gd.addMessage("Close the client?");
                    gd.showDialog();
                    if (gd.wasOKed()) {
                        frame.setVisible(false);
                        frame.removeAll();
                        client.close();
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (client.isActive()) {
                            Thread.sleep(100L);
                        }
                        label.setText("Client has stopped.");
                        frame.validate();
                    }
                    catch (InterruptedException ie) {
                        client.close();
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        frame.removeAll();
                        frame.setVisible(false);
                    }
                }
            }.start();
        }
        return client;
    }

    public static boolean runClusterGUI(Cluster cluster) {
        FijiArchipelago.setDebugLogger(new NullLogger());
        FijiArchipelago.setInfoLogger(new IJLogger());
        FijiArchipelago.setErrorLogger(new IJPopupLogger());
        new ClusterUI(cluster);
        return true;
    }

    public static boolean runClusterGUI(String file) {
        boolean ok = true;
        FijiArchipelago.setDebugLogger(new NullLogger());
        FijiArchipelago.setInfoLogger(new IJLogger());
        FijiArchipelago.setErrorLogger(new IJPopupLogger());
        ClusterUI ui = new ClusterUI();
        if (file != null) {
            ok = ui.loadFromFile(file);
        }
        return ok;
    }

    public static boolean runClusterGUI() {
        return FijiArchipelago.runClusterGUI((String)null);
    }
}

