/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ui;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.node.NodeParametersFactory;
import edu.utexas.clm.archipelago.network.shell.NodeShellParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClusterXML {
    public static boolean saveToFile(Cluster cluster, File file) {
        try {
            FijiArchipelago.debug("Save called");
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            NodeParametersFactory paramFactory = cluster.getParametersFactory();
            ArrayList<NodeParameters> params = cluster.getNodeParameters();
            Document doc = docBuilder.newDocument();
            Element clusterXML = doc.createElement("Cluster");
            Element rootNode = doc.createElement("RootNode");
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(file);
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            doc.appendChild(clusterXML);
            ClusterXML.addXMLField(doc, rootNode, "exec", FijiArchipelago.getExecRoot());
            ClusterXML.addXMLField(doc, rootNode, "file", FijiArchipelago.getFileRoot());
            ClusterXML.addXMLField(doc, rootNode, "default-exec", paramFactory.getDefaultExecRoot());
            ClusterXML.addXMLField(doc, rootNode, "default-file", paramFactory.getDefaultFileRoot());
            ClusterXML.addXMLField(doc, rootNode, "default-user", paramFactory.getDefaultUser());
            clusterXML.appendChild(rootNode);
            for (NodeParameters np : params) {
                Element clusterNode = doc.createElement("ClusterNode");
                Element shellParams = doc.createElement("ShellParameters");
                ClusterXML.addXMLField(doc, clusterNode, "host", np.getHost());
                ClusterXML.addXMLField(doc, clusterNode, "user", np.getUser());
                ClusterXML.addXMLField(doc, clusterNode, "exec", np.getExecRoot());
                ClusterXML.addXMLField(doc, clusterNode, "file", np.getFileRoot());
                ClusterXML.addXMLField(doc, clusterNode, "limit", "" + np.getThreadLimit());
                ClusterXML.addXMLField(doc, clusterNode, "shell", np.getShell().name());
                try {
                    np.getShellParams().toXML(shellParams);
                    clusterNode.appendChild(shellParams);
                    clusterXML.appendChild(clusterNode);
                }
                catch (Exception exception) {}
            }
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            FijiArchipelago.log("Saved configuration to " + file);
            return true;
        }
        catch (Exception e) {
            FijiArchipelago.err("Error saving file: " + e);
            return false;
        }
    }

    public static String replaceProperties(String instring) {
        String string = instring;
        String key = "";
        try {
            int b;
            while ((b = string.indexOf("[")) >= 0) {
                int e = string.indexOf("]");
                key = string.substring(b + 1, e);
                string = string.replace("[" + key + "]", System.getProperty(key));
            }
        }
        catch (StringIndexOutOfBoundsException ioobe) {
            FijiArchipelago.debug("Warning: Malformed input string " + instring);
        }
        catch (NullPointerException npe) {
            FijiArchipelago.debug("No such system property: " + key + ". Input string: " + instring);
        }
        FijiArchipelago.debug("Translated " + instring + " -> " + string);
        return string;
    }

    private static String getXMLField(Element e, String tag) {
        Node n = e.getElementsByTagName(tag).item(0);
        return n == null ? null : ClusterXML.replaceProperties(n.getTextContent());
    }

    private static void addXMLField(Document doc, Element parent, String field, String value) {
        Element e = doc.createElement(field);
        e.appendChild(doc.createTextNode(value));
        parent.appendChild(e);
    }

    public static boolean loadClusterFile(File file, Cluster cluster, List<Exception> nodeExceptions) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(file);
        if (nodeExceptions == null) {
            nodeExceptions = new ArrayList<Exception>();
        }
        doc.getDocumentElement().normalize();
        Element rootNode = (Element)doc.getElementsByTagName("RootNode").item(0);
        String execRoot = ClusterXML.getXMLField(rootNode, "exec");
        String fileRoot = ClusterXML.getXMLField(rootNode, "file");
        String dExecRoot = ClusterXML.getXMLField(rootNode, "default-exec");
        String dFileRoot = ClusterXML.getXMLField(rootNode, "default-file");
        String user = ClusterXML.getXMLField(rootNode, "default-user");
        String autoStart = ClusterXML.getXMLField(rootNode, "auto-start");
        boolean ok = Cluster.configureCluster(cluster, dExecRoot, dFileRoot, execRoot, fileRoot, user);
        NodeList clusterNodes = doc.getElementsByTagName("ClusterNode");
        for (int i = 0; i < clusterNodes.getLength(); ++i) {
            try {
                cluster.startNode(ClusterXML.xmlToNodeParameter(cluster, (Element)clusterNodes.item(i)));
                continue;
            }
            catch (Exception e) {
                FijiArchipelago.debug("loadClusterFile: could not add node: " + e);
                e.printStackTrace();
                nodeExceptions.add(e);
            }
        }
        if ("yes".equals(autoStart)) {
            cluster.start();
        }
        return ok;
    }

    private static NodeParameters xmlToNodeParameter(Cluster cluster, Element node) throws Exception {
        NodeParameters nodeParam = cluster.getParametersFactory().getNewParameters(ClusterXML.getXMLField(node, "host"));
        nodeParam.setUser(ClusterXML.getXMLField(node, "user"));
        nodeParam.setExecRoot(ClusterXML.getXMLField(node, "exec"));
        nodeParam.setFileRoot(ClusterXML.getXMLField(node, "file"));
        nodeParam.setThreadLimit(Integer.parseInt(ClusterXML.getXMLField(node, "limit")));
        nodeParam.setShell(ClusterXML.getXMLField(node, "shell"));
        if (nodeParam.getShell() == null) {
            throw new Exception("Could not load shell " + ClusterXML.getXMLField(node, "shell"));
        }
        NodeShellParameters shellParams = nodeParam.getShell().defaultParameters();
        shellParams.fromXML((Element)node.getElementsByTagName("ShellParameters").item(0));
        nodeParam.setShellParams(shellParams);
        return nodeParam;
    }
}

