/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.AbstractTransformedBoxModel;
import bdv.tools.boundingbox.BoxSelectionPanel;
import bdv.util.ModifiableInterval;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;

public class TransformedBoxModel
extends AbstractTransformedBoxModel {
    private final ModifiableInterval interval;
    private final BoxSelectionPanel.Box box = new BoxSelectionPanel.Box(){

        @Override
        public Interval getInterval() {
            return TransformedBoxModel.this.interval;
        }

        @Override
        public void setInterval(Interval i) {
            TransformedBoxModel.this.setDiscreteInterval(i);
        }
    };

    public TransformedBoxModel(Interval interval, AffineTransform3D transform) {
        this(new ModifiableInterval(interval), transform);
    }

    public TransformedBoxModel(ModifiableInterval interval, AffineTransform3D transform) {
        super(transform);
        this.interval = interval;
    }

    @Override
    public RealInterval getInterval() {
        return TransformedBoxModel.enlarge(this.interval);
    }

    private void setDiscreteInterval(Interval i) {
        if (!Intervals.equals(this.interval, i)) {
            this.interval.set(i);
            this.notifyIntervalChanged();
        }
    }

    @Override
    public void setInterval(RealInterval i) {
        this.setDiscreteInterval(TransformedBoxModel.round(TransformedBoxModel.shrink(i)));
    }

    public BoxSelectionPanel.Box box() {
        return this.box;
    }

    private static RealInterval enlarge(RealInterval interval) {
        return TransformedBoxModel.expand(interval, 0.5);
    }

    private static RealInterval shrink(RealInterval interval) {
        return TransformedBoxModel.expand(interval, -0.5);
    }

    private static FinalRealInterval expand(RealInterval interval, double border) {
        int n = interval.numDimensions();
        double[] min = new double[n];
        double[] max = new double[n];
        interval.realMin(min);
        interval.realMax(max);
        int d = 0;
        while (d < n) {
            int n2 = d;
            min[n2] = min[n2] - border;
            int n3 = d++;
            max[n3] = max[n3] + border;
        }
        return new FinalRealInterval(min, max);
    }

    private static Interval round(RealInterval ri) {
        int n = ri.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.round(ri.realMin(d));
            max[d] = Math.round(ri.realMax(d));
        }
        return new FinalInterval(min, max);
    }
}

