/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.BigDataViewer;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.boundingbox.TransformedBoxSelectionDialog;
import bdv.tools.boundingbox.TransformedRealBoxSelectionDialog;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.AbstractSource;
import bdv.util.AxisOrder;
import bdv.util.Bdv;
import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvOverlaySource;
import bdv.util.BdvPointsSource;
import bdv.util.BdvStackSource;
import bdv.util.BdvVirtualChannelSource;
import bdv.util.ChannelSources;
import bdv.util.PlaceHolderConverterSetup;
import bdv.util.PlaceHolderOverlayInfo;
import bdv.util.PlaceHolderSource;
import bdv.util.PointsOverlay;
import bdv.util.RandomAccessibleIntervalSource;
import bdv.util.RandomAccessibleIntervalSource4D;
import bdv.util.RandomAccessibleSource;
import bdv.util.RandomAccessibleSource4D;
import bdv.util.RealRandomAccessibleIntervalSource;
import bdv.util.VirtualChannels;
import bdv.util.volatiles.VolatileView;
import bdv.util.volatiles.VolatileViewData;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class BdvFunctions {
    public static BdvHandle show() {
        return BdvFunctions.show(Bdv.options());
    }

    public static BdvHandle show(BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        if (handle instanceof BdvHandleFrame && ((BdvHandleFrame)handle).getBigDataViewer() == null) {
            handle.createViewer(Collections.emptyList(), Collections.emptyList(), 1);
        }
        return handle;
    }

    public static <T> BdvStackSource<T> show(RandomAccessibleInterval<T> img, String name) {
        return BdvFunctions.show(img, name, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(RandomAccessibleInterval<T> img, String name, BdvOptions options) {
        Object type;
        BdvHandle handle = BdvFunctions.getHandle(options);
        AxisOrder axisOrder = AxisOrder.getAxisOrder(options.values.axisOrder(), img, handle.is2D());
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        if (img instanceof VolatileView) {
            VolatileViewData viewData = ((VolatileView)((Object)img)).getVolatileViewData();
            type = viewData.getVolatileType();
            handle.getCacheControls().addCacheControl(viewData.getCacheControl());
        } else {
            type = Util.getTypeFromInterval(img);
        }
        return BdvFunctions.addRandomAccessibleInterval(handle, img, (NumericType)type, name, axisOrder, sourceTransform);
    }

    public static <T extends NumericType<T>> BdvStackSource<T> show(RandomAccessible<T> img, Interval interval, String name) {
        return BdvFunctions.show(img, interval, name, Bdv.options());
    }

    public static <T extends NumericType<T>> BdvStackSource<T> show(RandomAccessible<T> img, Interval interval, String name, BdvOptions options) {
        NumericType type;
        BdvHandle handle = BdvFunctions.getHandle(options);
        boolean numTimepoints = true;
        AxisOrder axisOrder = AxisOrder.getAxisOrder(options.values.axisOrder(), img, handle.is2D());
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        if (img instanceof VolatileView) {
            VolatileViewData viewData = ((VolatileView)((Object)img)).getVolatileViewData();
            type = (NumericType)viewData.getVolatileType();
            handle.getCacheControls().addCacheControl(viewData.getCacheControl());
        } else {
            type = (NumericType)Util.getTypeFromInterval(Views.interval(img, interval));
        }
        return BdvFunctions.addRandomAccessible(handle, img, interval, 1, type, name, axisOrder, sourceTransform);
    }

    public static <T extends Type<T>> BdvStackSource<T> show(RealRandomAccessible<T> img, Interval interval, String name) {
        return BdvFunctions.show(img, interval, name, Bdv.options());
    }

    public static <T extends Type<T>> BdvStackSource<T> show(RealRandomAccessible<T> img, Interval interval, String name, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        AxisOrder axisOrder = AxisOrder.getAxisOrder(options.values.axisOrder(), img, handle.is2D());
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        Type type = (Type)img.realRandomAccess().get();
        return BdvFunctions.addRealRandomAccessible(handle, img, interval, type, name, axisOrder, sourceTransform);
    }

    public static List<BdvVirtualChannelSource> show(RandomAccessibleInterval<ARGBType> img, List<? extends VirtualChannels.VirtualChannel> virtualChannels, String name) {
        return BdvFunctions.show(img, virtualChannels, name, Bdv.options());
    }

    public static List<BdvVirtualChannelSource> show(RandomAccessibleInterval<ARGBType> img, List<? extends VirtualChannels.VirtualChannel> virtualChannels, String name, BdvOptions options) {
        return VirtualChannels.show(img, virtualChannels, name, options);
    }

    public static <T> BdvStackSource<T> show(Source<T> source) {
        return BdvFunctions.show(source, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(Source<T> source, BdvOptions options) {
        return BdvFunctions.show(source, 1, options);
    }

    public static <T> BdvStackSource<T> show(Source<T> source, int numTimePoints) {
        return BdvFunctions.show(source, numTimePoints, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(Source<T> source, int numTimePoints, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        BdvStackSource<T> stackSource = BdvFunctions.addSource(handle, source, numTimePoints);
        return stackSource;
    }

    public static <T> BdvStackSource<T> show(SourceAndConverter<T> source) {
        return BdvFunctions.show(source, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(SourceAndConverter<T> source, BdvOptions options) {
        return BdvFunctions.show(source, 1, options);
    }

    public static <T> BdvStackSource<T> show(SourceAndConverter<T> source, int numTimePoints) {
        return BdvFunctions.show(source, numTimePoints, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(SourceAndConverter<T> soc, int numTimepoints, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        T type = soc.getSpimSource().getType();
        int setupId = handle.getUnusedSetupId();
        List<ConverterSetup> converterSetups = Collections.singletonList(BigDataViewer.createConverterSetup(soc, setupId));
        List<SourceAndConverter<T>> sources = Collections.singletonList(soc);
        handle.add(converterSetups, sources, numTimepoints);
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    public static <T> BdvStackSource<T> show(List<SourceAndConverter<T>> sources, int numTimepoints, BdvOptions options) {
        if (sources.isEmpty()) {
            throw new IllegalArgumentException();
        }
        BdvHandle handle = BdvFunctions.getHandle(options);
        T type = sources.get(0).getSpimSource().getType();
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>(sources.size());
        for (SourceAndConverter<T> source : sources) {
            int setupId = handle.getUnusedSetupId();
            ConverterSetup converterSetup = BigDataViewer.createConverterSetup(source, setupId);
            handle.add(Collections.singletonList(converterSetup), Collections.singletonList(source), numTimepoints);
            converterSetups.add(converterSetup);
        }
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    public static <T> BdvStackSource<T> show(ChannelSources<T> channels) {
        return BdvFunctions.show(channels, Bdv.options());
    }

    public static <T> BdvStackSource<T> show(ChannelSources<T> channels, BdvOptions options) {
        List<SourceAndConverter<T>> sources = channels.getSources();
        if (sources.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int numTimepoints = channels.numTimepoints();
        BdvHandle handle = BdvFunctions.getHandle(options);
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>(sources.size());
        for (SourceAndConverter<T> source : sources) {
            int setupId = handle.getUnusedSetupId();
            ConverterSetup converterSetup = BigDataViewer.createConverterSetup(source, setupId);
            handle.add(Collections.singletonList(converterSetup), Collections.singletonList(source), numTimepoints);
            converterSetups.add(converterSetup);
        }
        T type = channels.getType();
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        CacheControl cacheControl = channels.getCacheControl();
        if (cacheControl != null) {
            handle.getCacheControls().addCacheControl(cacheControl);
        }
        return bdvSource;
    }

    public static List<BdvStackSource<?>> show(AbstractSpimData<?> spimData) {
        return BdvFunctions.show(spimData, Bdv.options());
    }

    public static List<BdvStackSource<?>> show(AbstractSpimData<?> spimData, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        WrapBasicImgLoader.wrapImgLoaderIfNecessary(spimData);
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        int numTimepoints = seq.getTimePoints().size();
        CacheControl cache = ((ViewerImgLoader)seq.getImgLoader()).getCacheControl();
        handle.getBdvHandle().getCacheControls().addCacheControl(cache);
        if (cache instanceof VolatileGlobalCellCache) {
            ((VolatileGlobalCellCache)cache).clearCache();
        }
        ArrayList sources = new ArrayList();
        BigDataViewer.initSetups(spimData, new ArrayList<ConverterSetup>(), sources);
        ArrayList bdvSources = new ArrayList();
        for (SourceAndConverter<?> source : sources) {
            bdvSources.add(BdvFunctions.addSpimDataSource(handle, source, numTimepoints));
        }
        WrapBasicImgLoader.removeWrapperIfPresent(spimData);
        return bdvSources;
    }

    public static BdvPointsSource showPoints(List<? extends RealLocalizable> points, String name) {
        return BdvFunctions.showPoints(points, name, Bdv.options());
    }

    public static BdvPointsSource showPoints(List<? extends RealLocalizable> points, String name, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        int setupId = handle.getUnusedSetupId();
        ARGBType defaultColor = new ARGBType(-16711936);
        PlaceHolderConverterSetup setup = new PlaceHolderConverterSetup(setupId, 0.0, 255.0, defaultColor);
        PlaceHolderSource source = new PlaceHolderSource(name);
        SourceAndConverter<Void> soc = new SourceAndConverter<Void>(source, null);
        ArrayList<PlaceHolderConverterSetup> converterSetups = new ArrayList<PlaceHolderConverterSetup>(Collections.singletonList(setup));
        ArrayList<SourceAndConverter<Void>> sources = new ArrayList<SourceAndConverter<Void>>(Collections.singletonList(soc));
        boolean numTimepoints = true;
        handle.add(converterSetups, sources, 1);
        PlaceHolderOverlayInfo info = new PlaceHolderOverlayInfo(handle.getViewerPanel(), soc, setup);
        PointsOverlay overlay = new PointsOverlay();
        overlay.setOverlayInfo(info);
        overlay.setPoints(points);
        overlay.setSourceTransform(sourceTransform);
        handle.getViewerPanel().getDisplay().overlays().add((Object)overlay);
        BdvPointsSource bdvSource = new BdvPointsSource(handle, 1, setup, soc, info, overlay);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    public static <O extends BdvOverlay> BdvOverlaySource<O> showOverlay(O overlay, String name) {
        return BdvFunctions.showOverlay(overlay, name, Bdv.options());
    }

    public static <O extends BdvOverlay> BdvOverlaySource<O> showOverlay(O overlay, String name, BdvOptions options) {
        BdvHandle handle = BdvFunctions.getHandle(options);
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        int setupId = handle.getUnusedSetupId();
        ARGBType defaultColor = new ARGBType(-16711936);
        PlaceHolderConverterSetup setup = new PlaceHolderConverterSetup(setupId, 0.0, 255.0, defaultColor);
        PlaceHolderSource source = new PlaceHolderSource(name);
        SourceAndConverter<Void> soc = new SourceAndConverter<Void>(source, null);
        ArrayList<PlaceHolderConverterSetup> converterSetups = new ArrayList<PlaceHolderConverterSetup>(Collections.singletonList(setup));
        ArrayList<SourceAndConverter<Void>> sources = new ArrayList<SourceAndConverter<Void>>(Collections.singletonList(soc));
        boolean numTimepoints = true;
        handle.add(converterSetups, sources, 1);
        PlaceHolderOverlayInfo info = new PlaceHolderOverlayInfo(handle.getViewerPanel(), soc, setup);
        overlay.setOverlayInfo(info);
        overlay.setSourceTransform(sourceTransform);
        handle.getViewerPanel().getDisplay().overlays().add(overlay);
        BdvOverlaySource<O> bdvSource = new BdvOverlaySource<O>(handle, 1, setup, soc, info, overlay);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    public static int getUnusedSetupId(BigDataViewer bdv) {
        return BdvFunctions.getUnusedSetupId(bdv.getSetupAssignments());
    }

    public static synchronized int getUnusedSetupId(SetupAssignments setupAssignments) {
        return SetupAssignments.getUnusedSetupId(setupAssignments);
    }

    public static TransformedRealBoxSelectionDialog.Result selectRealBox(Bdv bdv, AffineTransform3D boxTransform, RealInterval initialInterval, RealInterval rangeInterval) {
        return BdvFunctions.selectRealBox(bdv, boxTransform, initialInterval, rangeInterval, BoxSelectionOptions.options());
    }

    public static TransformedRealBoxSelectionDialog.Result selectRealBox(Bdv bdv, AffineTransform3D boxTransform, RealInterval initialInterval, RealInterval rangeInterval, BoxSelectionOptions options) {
        BdvHandle handle = bdv.getBdvHandle();
        InputTriggerConfig keyConfig = options.values.getInputTriggerConfig();
        if (keyConfig == null) {
            keyConfig = new InputTriggerConfig();
        }
        return (TransformedRealBoxSelectionDialog.Result)new TransformedRealBoxSelectionDialog(handle.getViewerPanel(), handle.getConverterSetups(), handle.getUnusedSetupId(), keyConfig, handle.getTriggerbindings(), boxTransform, initialInterval, rangeInterval, options).getResult();
    }

    public static TransformedBoxSelectionDialog.Result selectBox(Bdv bdv, AffineTransform3D boxTransform, Interval initialInterval, Interval rangeInterval) {
        return BdvFunctions.selectBox(bdv, boxTransform, initialInterval, rangeInterval, BoxSelectionOptions.options());
    }

    public static TransformedBoxSelectionDialog.Result selectBox(Bdv bdv, AffineTransform3D boxTransform, Interval initialInterval, Interval rangeInterval, BoxSelectionOptions options) {
        BdvHandle handle = bdv.getBdvHandle();
        InputTriggerConfig keyConfig = options.values.getInputTriggerConfig();
        if (keyConfig == null) {
            keyConfig = new InputTriggerConfig();
        }
        return (TransformedBoxSelectionDialog.Result)new TransformedBoxSelectionDialog(handle.getViewerPanel(), handle.getConverterSetups(), handle.getUnusedSetupId(), keyConfig, handle.getTriggerbindings(), boxTransform, initialInterval, rangeInterval, options).getResult();
    }

    private static BdvHandle getHandle(BdvOptions options) {
        Bdv bdv = options.values.addTo();
        return bdv == null ? new BdvHandleFrame(options) : bdv.getBdvHandle();
    }

    private static <T extends NumericType<T>> BdvStackSource<T> addRandomAccessibleInterval(BdvHandle handle, RandomAccessibleInterval<T> img, T type, String name, AxisOrder axisOrder, AffineTransform3D sourceTransform) {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        ArrayList<RandomAccessibleInterval<T>> stacks = AxisOrder.splitInputStackIntoSourceStacks(img, axisOrder);
        int numTimepoints = 1;
        for (RandomAccessibleInterval<T> stack : stacks) {
            AbstractSource s;
            if (stack.numDimensions() > 3) {
                numTimepoints = (int)stack.max(3) + 1;
                s = new RandomAccessibleIntervalSource4D<T>(stack, type, sourceTransform, name);
            } else {
                s = new RandomAccessibleIntervalSource<T>(stack, type, sourceTransform, name);
            }
            BdvFunctions.addSourceToListsGenericType(s, handle.getUnusedSetupId(), converterSetups, sources);
        }
        handle.add(converterSetups, sources, numTimepoints);
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    private static <T extends NumericType<T>> BdvStackSource<T> addRandomAccessible(BdvHandle handle, RandomAccessible<T> img, Interval interval, int numTimepoints, T type, String name, AxisOrder axisOrder, AffineTransform3D sourceTransform) {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        Pair<ArrayList<RandomAccessible<T>>, Interval> stacksAndInterval = AxisOrder.splitInputStackIntoSourceStacks(img, interval, axisOrder);
        ArrayList<RandomAccessible<T>> stacks = stacksAndInterval.getA();
        Interval stackInterval = stacksAndInterval.getB();
        for (RandomAccessible<T> stack : stacks) {
            AbstractSource s = stack.numDimensions() > 3 ? new RandomAccessibleSource4D<T>(stack, stackInterval, type, sourceTransform, name) : new RandomAccessibleSource<T>(stack, stackInterval, type, sourceTransform, name);
            BdvFunctions.addSourceToListsGenericType(s, handle.getUnusedSetupId(), converterSetups, sources);
        }
        handle.add(converterSetups, sources, numTimepoints);
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    private static <T extends Type<T>> BdvStackSource<T> addRealRandomAccessible(BdvHandle handle, RealRandomAccessible<T> img, Interval interval, T type, String name, AxisOrder axisOrder, AffineTransform3D sourceTransform) {
        if (!axisOrder.hasZ()) {
            img = RealViews.addDimension(img);
            interval = new FinalInterval(new long[]{interval.min(0), interval.min(1), 0L}, new long[]{interval.max(0), interval.max(1), 0L});
        }
        RealRandomAccessibleIntervalSource<T> s = new RealRandomAccessibleIntervalSource<T>(img, interval, type, sourceTransform, name);
        return BdvFunctions.addSource(handle, s, 1);
    }

    private static <T> BdvStackSource<T> addSource(BdvHandle handle, Source<T> source, int numTimepoints) {
        T type = source.getType();
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList<SourceAndConverter<T>> sources = new ArrayList<SourceAndConverter<T>>();
        BdvFunctions.addSourceToListsGenericType(source, handle.getUnusedSetupId(), converterSetups, sources);
        handle.add(converterSetups, sources, numTimepoints);
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, converterSetups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }

    private static <T> void addSourceToListsGenericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        T type = source.getType();
        if (!(type instanceof RealType || type instanceof ARGBType || type instanceof VolatileARGBType)) {
            throw new IllegalArgumentException("Unknown source type. Expected RealType, ARGBType, or VolatileARGBType");
        }
        BdvFunctions.addSourceToListsNumericType(source, setupId, converterSetups, sources);
    }

    private static <T extends NumericType<T>> void addSourceToListsNumericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        NumericType type = (NumericType)source.getType();
        SourceAndConverter<NumericType> soc = BigDataViewer.wrapWithTransformedSource(new SourceAndConverter<NumericType>(source, BigDataViewer.createConverterToARGB(type)));
        converterSetups.add(BigDataViewer.createConverterSetup(soc, setupId));
        sources.add(soc);
    }

    private static <T> BdvStackSource<T> addSpimDataSource(BdvHandle handle, SourceAndConverter<T> source, int numTimepoints) {
        ConverterSetup setup = BigDataViewer.createConverterSetup(source, handle.getUnusedSetupId());
        List<ConverterSetup> setups = Collections.singletonList(setup);
        List<SourceAndConverter<T>> sources = Collections.singletonList(source);
        handle.add(setups, sources, numTimepoints);
        T type = source.getSpimSource().getType();
        BdvStackSource<T> bdvSource = new BdvStackSource<T>(handle, numTimepoints, type, setups, sources);
        handle.addBdvSource(bdvSource);
        return bdvSource;
    }
}

