/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.cache.CacheControl;
import bdv.tools.InitializeViewerState;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.ui.CardPanel;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvSource;
import bdv.viewer.ConverterSetups;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerStateChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public abstract class BdvHandle
implements Bdv {
    protected ViewerPanel viewer;
    protected CardPanel cards;
    protected SplitPanel splitPanel;
    protected ConverterSetups setups;
    protected SetupAssignments setupAssignments;
    protected final ArrayList<BdvSource> bdvSources;
    protected final BdvOptions bdvOptions;
    protected boolean hasPlaceHolderSources;
    protected final int origNumTimepoints;
    protected CacheControl.CacheControls cacheControls;
    private boolean initTransformPending;

    public BdvHandle(BdvOptions options) {
        this.bdvOptions = options;
        this.bdvSources = new ArrayList();
        this.origNumTimepoints = 1;
    }

    @Override
    public BdvHandle getBdvHandle() {
        return this;
    }

    public ViewerPanel getViewerPanel() {
        return this.viewer;
    }

    public CardPanel getCardPanel() {
        return this.cards;
    }

    public SplitPanel getSplitPanel() {
        return this.splitPanel;
    }

    public ConverterSetups getConverterSetups() {
        return this.setups;
    }

    @Deprecated
    public SetupAssignments getSetupAssignments() {
        return this.setupAssignments;
    }

    public CacheControl.CacheControls getCacheControls() {
        return this.cacheControls;
    }

    public abstract KeymapManager getKeymapManager();

    public abstract AppearanceManager getAppearanceManager();

    @Deprecated
    int getUnusedSetupId() {
        return BdvFunctions.getUnusedSetupId(this.setupAssignments);
    }

    @Override
    public void close() {
        if (this.viewer != null) {
            this.viewer.stop();
            this.bdvSources.clear();
            this.cacheControls.clear();
            this.viewer = null;
            this.cards = null;
            this.splitPanel = null;
            this.setups = null;
            this.setupAssignments = null;
            this.cacheControls = null;
        }
    }

    public abstract ManualTransformationEditor getManualTransformEditor();

    public abstract InputActionBindings getKeybindings();

    public abstract TriggerBehaviourBindings getTriggerbindings();

    abstract boolean createViewer(List<? extends ConverterSetup> var1, List<? extends SourceAndConverter<?>> var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, int numTimepoints) {
        boolean initTransform;
        if (this.viewer == null) {
            initTransform = this.createViewer(converterSetups, sources, numTimepoints);
        } else {
            boolean bl = initTransform = this.viewer.state().getSources().isEmpty() && sources != null && !sources.isEmpty();
            if (converterSetups != null && sources != null && converterSetups.size() != sources.size()) {
                System.err.println("WARNING! Adding sources to BdvHandle with converterSetups.size() != sources.size().");
            }
            if (converterSetups != null) {
                int numSetups = Math.min(converterSetups.size(), sources.size());
                for (int i = 0; i < numSetups; ++i) {
                    SourceAndConverter<?> source = sources.get(i);
                    ConverterSetup setup = converterSetups.get(i);
                    if (setup == null) continue;
                    this.setups.put(source, setup);
                }
                converterSetups.forEach(this.setupAssignments::addSetup);
            }
            if (sources != null) {
                for (SourceAndConverter<?> soc : sources) {
                    this.viewer.state().addSource(soc);
                    this.viewer.state().setSourceActive(soc, true);
                }
            }
        }
        if (initTransform) {
            BdvHandle bdvHandle = this;
            synchronized (bdvHandle) {
                this.initTransformPending = true;
                this.tryInitTransform();
            }
        }
    }

    protected synchronized void tryInitTransform() {
        if (this.viewer.getDisplay().getWidth() <= 0 || this.viewer.getDisplay().getHeight() <= 0) {
            return;
        }
        if (this.initTransformPending) {
            this.initTransformPending = false;
            InitializeViewerState.initTransform(this.viewer);
        }
    }

    void remove(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, List<TransformListener<AffineTransform3D>> transformListeners, List<TimePointListener> timepointListeners, List<ViewerStateChangeListener> viewerStateChangeListeners, List<OverlayRenderer> overlays) {
        if (this.viewer == null) {
            return;
        }
        if (converterSetups != null) {
            converterSetups.forEach(this.setupAssignments::removeSetup);
        }
        if (transformListeners != null) {
            for (TransformListener transformListener : transformListeners) {
                this.viewer.removeTransformListener(transformListener);
            }
        }
        if (timepointListeners != null) {
            for (TimePointListener timePointListener : timepointListeners) {
                this.viewer.removeTimePointListener(timePointListener);
            }
        }
        if (viewerStateChangeListeners != null) {
            this.viewer.state().changeListeners().removeAll(viewerStateChangeListeners);
        }
        if (overlays != null) {
            for (OverlayRenderer overlayRenderer : overlays) {
                this.viewer.getDisplay().overlays().remove((Object)overlayRenderer);
            }
        }
        if (sources != null) {
            this.viewer.state().removeSources(sources);
        }
    }

    void addBdvSource(BdvSource bdvSource) {
        this.bdvSources.add(bdvSource);
        this.updateHasPlaceHolderSources();
        this.updateNumTimepoints();
    }

    void removeBdvSource(BdvSource bdvSource) {
        this.bdvSources.remove(bdvSource);
        this.updateHasPlaceHolderSources();
        this.updateNumTimepoints();
    }

    void updateHasPlaceHolderSources() {
        for (BdvSource s : this.bdvSources) {
            if (!s.isPlaceHolderSource()) continue;
            this.hasPlaceHolderSources = true;
            return;
        }
        this.hasPlaceHolderSources = false;
    }

    void updateNumTimepoints() {
        int numTimepoints = this.origNumTimepoints;
        for (BdvSource s : this.bdvSources) {
            numTimepoints = Math.max(numTimepoints, s.getNumTimepoints());
        }
        if (this.viewer != null) {
            this.viewer.setNumTimepoints(numTimepoints);
        }
    }

    boolean is2D() {
        return this.bdvOptions.values.is2D();
    }
}

