/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render.awt;

import bdv.util.AWTUtils;
import bdv.viewer.render.RenderResult;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;

public class BufferedImageRenderResult
implements RenderResult {
    private final AffineTransform3D viewerTransform = new AffineTransform3D();
    private int width;
    private int height;
    private int[] data = new int[0];
    private ARGBScreenImage screenImage;
    private BufferedImage bufferedImage;
    private double scaleFactor;

    @Override
    public void init(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        if (this.data.length < width * height) {
            this.data = new int[width * height];
        }
        this.screenImage = new ARGBScreenImage(width, height, this.data);
        this.bufferedImage = AWTUtils.getBufferedImage(this.screenImage);
    }

    @Override
    public RandomAccessibleInterval<ARGBType> getTargetImage() {
        return this.screenImage;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public AffineTransform3D getViewerTransform() {
        return this.viewerTransform;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public void setUpdated() {
    }

    @Override
    public void patch(RenderResult patch, Interval interval, double ox, double oy) {
        BufferedImageRenderResult biresult = (BufferedImageRenderResult)patch;
        double s = this.scaleFactor / patch.getScaleFactor();
        double tx = ox - (double)interval.min(0);
        double ty = oy - (double)interval.min(1);
        AffineTransform transform = new AffineTransform(s, 0.0, 0.0, s, tx, ty);
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        op.filter(biresult.getBufferedImage(), this.subImage(interval));
    }

    private BufferedImage subImage(Interval interval) {
        int x = (int)interval.min(0);
        int y = (int)interval.min(1);
        int w = (int)interval.dimension(0);
        int h = (int)interval.dimension(1);
        return this.bufferedImage.getSubimage(x, y, w, h);
    }
}

