/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume_Viewer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TFrgb
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int height = 128;
    int channel = 3;
    private Control control;
    private Volume_Viewer vv;
    int xLast = -1;
    int yLast = -1;
    int count = 0;

    public TFrgb(Control control, Volume_Viewer vv) {
        this.control = control;
        this.vv = vv;
        this.setPreferredSize(new Dimension(256, this.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        for (int i = 0; i < 256; ++i) {
            int n = i;
            vv.lookupTable.lut[i][2] = n;
            vv.lookupTable.lut[i][1] = n;
            vv.lookupTable.lut[i][0] = n;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.xLast = e.getX();
        this.yLast = e.getY();
        this.handleMouseDragged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e);
        if (this.count++ % 10 == 0) {
            this.control.newDisplayMode();
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > 255) {
            x = 255;
        }
        if (y > this.height) {
            y = this.height;
        }
        int sx = this.xLast;
        int ex = x;
        int sy = this.yLast;
        int ey = y;
        if (ex < sx) {
            sx = x;
            ex = this.xLast;
            sy = y;
            ey = this.yLast;
        }
        int lx = ex - sx;
        int ly = ey - sy;
        block6: for (int i = sx; i <= ex; ++i) {
            if (lx == 0) {
                lx = 1;
            }
            double r = (double)(i - sx) / (double)lx;
            int yi = (int)Math.round((double)sy + r * (double)ly);
            int v = 255 * (this.height - yi) / this.height;
            switch (this.channel) {
                case 0: {
                    this.vv.lookupTable.lut[i][0] = v;
                    continue block6;
                }
                case 1: {
                    this.vv.lookupTable.lut[i][1] = v;
                    continue block6;
                }
                case 2: {
                    this.vv.lookupTable.lut[i][2] = v;
                    continue block6;
                }
                case 3: {
                    int n = v;
                    this.vv.lookupTable.lut[i][2] = n;
                    this.vv.lookupTable.lut[i][1] = n;
                    this.vv.lookupTable.lut[i][0] = n;
                }
            }
        }
        this.yLast = y;
        this.xLast = x;
        this.vv.gradientLUT.repaint();
        if (this.control.alphaMode == 1) {
            this.vv.gradient2.repaint();
            if (!this.control.pickColor) {
                this.vv.tf_a2.updateLutGradVal();
                this.vv.tf_a2.repaint();
            }
        } else if (this.control.alphaMode == 2) {
            this.vv.gradient3.repaint();
            if (!this.control.pickColor) {
                this.vv.tf_a3.updateLutGradVal();
                this.vv.tf_a3.repaint();
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = 256;
        int[] pixels = new int[width * this.height];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = -13421773;
        }
        int[][] lut = this.vv.lookupTable.lut;
        for (int x = 0; x < width - 1; ++x) {
            int i;
            int y = this.height * lut[x][0] / 256;
            int y1 = this.height * lut[x + 1][0] / 256;
            int min = Math.min(y1, y);
            int max = Math.max(y1, y);
            for (i = min; i <= max; ++i) {
                int n = (this.height - 1 - i) * 256 + x;
                pixels[n] = pixels[n] | 0xFFFF0000;
            }
            y = this.height * lut[x][1] / 256;
            y1 = this.height * lut[x + 1][1] / 256;
            min = Math.min(y1, y);
            max = Math.max(y1, y);
            for (i = min; i <= max; ++i) {
                int n = (this.height - 1 - i) * 256 + x;
                pixels[n] = pixels[n] | 0xFF00FF00;
            }
            y = this.height * lut[x][2] / 256;
            y1 = this.height * lut[x + 1][2] / 256;
            min = Math.min(y1, y);
            max = Math.max(y1, y);
            for (i = min; i <= max; ++i) {
                int n = (this.height - 1 - i) * 256 + x;
                pixels[n] = pixels[n] | 0xFF0000FF;
            }
        }
        BufferedImage image = new BufferedImage(width, this.height, 2);
        image.setRGB(0, 0, width, this.height, pixels, 0, width);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)image, 0, 0, null);
    }
}

