/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Cube;
import fiji.plugin.volumeviewer.Gradient;
import fiji.plugin.volumeviewer.Gui;
import fiji.plugin.volumeviewer.LookupTable;
import fiji.plugin.volumeviewer.TFalpha1;
import fiji.plugin.volumeviewer.TFalpha2;
import fiji.plugin.volumeviewer.TFalpha3;
import fiji.plugin.volumeviewer.TFalpha4;
import fiji.plugin.volumeviewer.TFrgb;
import fiji.plugin.volumeviewer.Transform;
import fiji.plugin.volumeviewer.Volume;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public final class Volume_Viewer
implements PlugIn {
    private static String volumePath = "/Users/barthel/Applications/ImageJ/_images/_stacks/engine.zip";
    private static final String version = "2.01";
    private Control control;
    private JFrame frame;
    final float[] a1_R = new float[256];
    final float[][] a2_R = new float[256][128];
    final float[][] a3_R = new float[256][128];
    Volume vol = null;
    Cube cube = null;
    LookupTable lookupTable = null;
    private Transform tr = null;
    private Transform trLight = null;
    ImagePlus imp;
    Gui gui;
    Gradient gradientLUT;
    Gradient gradient2;
    Gradient gradient3;
    Gradient gradient4;
    TFrgb tf_rgb = null;
    TFalpha1 tf_a1 = null;
    TFalpha2 tf_a2 = null;
    TFalpha3 tf_a3 = null;
    TFalpha4 tf_a4 = null;
    private boolean batch = false;

    public static void main(String[] args) {
        Volume_Viewer vv = new Volume_Viewer();
        IJ.open((String)volumePath);
        vv.run("");
    }

    public void run(String args) {
        this.control = new Control(this);
        String str = Macro.getOptions();
        if (str != null) {
            if (!this.getMacroParameters(str)) {
                return;
            }
        } else {
            this.readPrefs();
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null || this.imp.getStackSize() <= 1) {
            IJ.showMessage((String)"Stack required");
            return;
        }
        if (this.imp.getType() == 4) {
            this.control.isRGB = true;
        }
        this.vol = new Volume(this.control, this);
        this.lookupTable = new LookupTable(this.control, this);
        this.lookupTable.readLut();
        this.cube = new Cube(this.control, this.vol.widthV, this.vol.heightV, this.vol.depthV);
        this.cube.setSlicePositions(this.control.positionFactorX, this.control.positionFactorY, this.control.positionFactorZ, this.control.zAspect);
        this.tr = new Transform(this.control, this.control.windowWidthImageRegion, this.control.windowHeight, this.vol.xOffa, this.vol.yOffa, this.vol.zOffa);
        this.tr.setScale(this.control.scale);
        this.tr.setZAspect(this.control.zAspect);
        this.setRotation(this.control.degreeX, this.control.degreeY, this.control.degreeZ);
        this.initializeTransformation();
        this.cube.setTransform(this.tr);
        this.cube.setTextPositions(this.control.scale, this.control.zAspect);
        this.trLight = new Transform(this.control, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
        this.trLight.initializeTransformation();
        this.gradientLUT = new Gradient(this.control, this, 256, 18);
        this.gui = new Gui(this.control, this);
        this.gui.makeGui();
        this.gui.newDisplayMode();
        this.lookupTable.setLut();
        this.lookupTable.orig();
        if (Interpreter.isBatchMode()) {
            this.batch = true;
        }
        if (this.batch) {
            do {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!this.control.isReady);
            this.gui.imageRegion.saveToImage();
            this.cleanup();
        } else {
            this.frame = new JFrame("Volume Viewer 2.01 ");
            this.frame.setLocation(this.control.xloc, this.control.yloc);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (((Volume_Viewer)Volume_Viewer.this).control.snapshot) {
                        Volume_Viewer.this.gui.imageRegion.saveToImage();
                    }
                    Volume_Viewer.this.writePrefs();
                    Volume_Viewer.this.cleanup();
                    Volume_Viewer.this.frame.dispose();
                }
            });
            this.frame.setVisible(true);
            this.frame.getContentPane().add(this.gui);
            this.gui.requestFocus();
            this.frame.pack();
            this.frame.validate();
        }
    }

    public ImagePlus get3DVisualization(ImagePlus newImp, boolean showTF, int renderMode, int interpolationMode, Color backgroundColor, int lutNr, float sampling, float dist, boolean showAxes, boolean showSlices, boolean showClipLines, float scale, float angleX, float angleY, float angleZ, int alphaMode, int windowWidthImageRegion, int windowHeight, boolean useLight, float ambientValue, float diffuseValue, float specularValue, float shineValue, float objectLightValue, int lightRed, int lightGreen, int lightBlue, float rotationLightX, float rotationLightY) {
        this.control = new Control(this);
        this.control.showTF = showTF;
        this.control.renderMode = renderMode;
        this.control.interpolationMode = interpolationMode;
        this.control.backgroundColor = backgroundColor;
        this.control.lutNr = lutNr;
        this.control.sampling = sampling;
        this.control.dist = dist;
        this.control.showAxes = showAxes;
        this.control.showSlices = showSlices;
        this.control.showClipLines = showClipLines;
        this.control.scale = scale;
        this.control.degreeX = angleX;
        this.control.degreeY = angleY;
        this.control.degreeZ = angleZ;
        this.control.alphaMode = alphaMode;
        this.control.windowWidthImageRegion = windowWidthImageRegion;
        this.control.windowHeight = windowHeight;
        this.control.useLight = useLight;
        this.control.ambientValue = ambientValue;
        this.control.diffuseValue = diffuseValue;
        this.control.specularValue = specularValue;
        this.control.shineValue = shineValue;
        this.control.objectLightValue = objectLightValue;
        this.control.lightRed = lightRed;
        this.control.lightGreen = lightGreen;
        this.control.lightBlue = lightBlue;
        this.control.snapshot = true;
        this.imp = newImp;
        if (this.imp.getType() == 4) {
            this.control.isRGB = true;
        }
        this.vol = new Volume(this.control, this);
        this.lookupTable = new LookupTable(this.control, this);
        this.lookupTable.readLut();
        this.cube = new Cube(this.control, this.vol.widthV, this.vol.heightV, this.vol.depthV);
        this.cube.setSlicePositions(this.control.positionFactorX, this.control.positionFactorY, this.control.positionFactorZ, this.control.zAspect);
        this.tr = new Transform(this.control, this.control.windowWidthImageRegion, this.control.windowHeight, this.vol.xOffa, this.vol.yOffa, this.vol.zOffa);
        this.tr.setScale(this.control.scale);
        this.tr.setZAspect(this.control.zAspect);
        this.setRotation(this.control.degreeX, this.control.degreeY, this.control.degreeZ);
        this.initializeTransformation();
        this.cube.setTransform(this.tr);
        this.cube.setTextPositions(this.control.scale, this.control.zAspect);
        this.trLight = new Transform(this.control, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
        this.trLight.initializeTransformation();
        this.gradientLUT = new Gradient(this.control, this, 256, 18);
        this.gui = new Gui(this.control, this);
        this.gui.makeGui();
        this.gui.newDisplayMode();
        this.lookupTable.setLut();
        this.lookupTable.orig();
        this.changeRotationLight(0, 0, Math.round((1.0f + rotationLightX) * 10.0f), Math.round(rotationLightY * 10.0f), 20);
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!this.control.isReady);
        ImagePlus imp2 = this.gui.imageRegion.getImage();
        this.cleanup();
        return imp2;
    }

    void reset() {
        this.tf_rgb = null;
        this.tf_a1 = null;
        this.tf_a2 = null;
        this.tf_a3 = null;
        this.tf_a4 = null;
        this.control.reset();
        this.buildFrame();
    }

    void buildFrame() {
        Insets insets = this.frame.getInsets();
        int ww = this.frame.getWidth() - insets.left - insets.right;
        int wh = this.frame.getHeight() - insets.bottom - insets.top;
        int h = wh - (this.gui.upperButtonPanel.getHeight() + this.gui.lowerButtonPanel.getHeight());
        if (h < this.control.windowMinHeight) {
            h = this.control.windowMinHeight;
        }
        Dimension dim = this.gui.picSlice.getSliceViewSize((int)(0.25 * (double)ww), h - 130);
        int wl = dim.width;
        int transferPanelWidth = this.control.showTF ? this.gui.transferFunctionPanel.getPreferredSize().width : 0;
        int wr = ww - (wl + this.control.windowWidthSliderRegion + transferPanelWidth);
        if (wr < 480) {
            int diff = 480 - wr;
            wr = 480;
            if ((wl -= diff) < 200) {
                wl = 200;
            }
        }
        if (this.control.windowHeight > 0 && ww > 0) {
            this.control.windowHeight = h;
            this.control.windowWidthSlices = wl;
            this.control.windowWidthImageRegion = wr;
            this.frame.getContentPane().remove(this.gui);
            this.tr = new Transform(this.control, this.control.windowWidthImageRegion, this.control.windowHeight, this.vol.xOffa, this.vol.yOffa, this.vol.zOffa);
            this.tr.setScale(this.control.scale);
            this.tr.setZAspect(this.control.zAspect);
            this.setRotation(this.control.degreeX, this.control.degreeY, this.control.degreeZ);
            this.initializeTransformation();
            this.cube.setTransform(this.tr);
            this.gui = new Gui(this.control, this);
            this.gui.makeGui();
            this.frame.getContentPane().add(this.gui);
            this.frame.pack();
            this.gui.requestFocus();
            this.gui.newDisplayMode();
        }
    }

    private void cleanup() {
        this.vol.data3D = null;
        this.vol.grad3D = null;
        this.vol.mean3D = null;
        this.vol.diff3D = null;
        this.vol.col_3D = null;
        this.vol.aPaint_3D = null;
        this.vol.aPaint_3D2 = null;
        this.vol.nx_3D = null;
        this.vol.ny_3D = null;
        this.vol.nz_3D = null;
        this.vol.histValGrad = null;
        this.vol.histMeanDiff = null;
        this.vol.histVal = null;
        this.vol = null;
        this.gui.pic = null;
        this.gui.picSlice = null;
        this.gui = null;
        this.cube = null;
        this.lookupTable = null;
        this.tr = null;
        this.trLight = null;
        this.imp = null;
        this.gradient4 = null;
        this.gradient3 = null;
        this.gradient2 = null;
        this.gradientLUT = null;
        this.tf_rgb = null;
        this.tf_a1 = null;
        this.tf_a2 = null;
        this.tf_a3 = null;
        this.tf_a4 = null;
        this.control = null;
        System.gc();
    }

    private void readPrefs() {
        this.control.xloc = (int)Prefs.get((String)"VolumeViewer.xloc", (double)100.0);
        this.control.yloc = (int)Prefs.get((String)"VolumeViewer.yloc", (double)50.0);
        this.control.showTF = Prefs.get((String)"VolumeViewer.showTF", (boolean)true);
        this.control.renderMode = (int)Prefs.get((String)"VolumeViewer.renderMode", (double)this.control.renderMode);
        this.control.interpolationMode = (int)Prefs.get((String)"VolumeViewer.interpolationMode", (double)this.control.interpolationMode);
        this.control.backgroundColor = new Color((int)Prefs.get((String)"VolumeViewer.backgroundColor", (double)this.control.backgroundColor.getRGB()));
        this.control.lutNr = (int)Prefs.get((String)"VolumeViewer.lutNr", (double)this.control.lutNr);
        this.control.sampling = (float)Prefs.get((String)"VolumeViewer.sampling", (double)this.control.sampling);
        this.control.dist = (float)Prefs.get((String)"VolumeViewer.dist", (double)this.control.dist);
        this.control.showAxes = Prefs.get((String)"VolumeViewer.showAxes", (boolean)this.control.showAxes);
        this.control.showSlices = Prefs.get((String)"VolumeViewer.showSlices", (boolean)this.control.showSlices);
        this.control.showClipLines = Prefs.get((String)"VolumeViewer.showClipLines", (boolean)this.control.showClipLines);
        this.control.scale = (float)Prefs.get((String)"VolumeViewer.scale", (double)this.control.scale);
        this.control.degreeX = (float)Prefs.get((String)"VolumeViewer.degreeX", (double)this.control.degreeX);
        this.control.degreeY = (float)Prefs.get((String)"VolumeViewer.degreeY", (double)this.control.degreeY);
        this.control.degreeZ = (float)Prefs.get((String)"VolumeViewer.degreeZ", (double)this.control.degreeZ);
        this.control.alphaMode = (int)Prefs.get((String)"VolumeViewer.alphaMode", (double)this.control.alphaMode);
        this.control.windowWidthImageRegion = (int)Prefs.get((String)"VolumeViewer.windowWidthImageRegion", (double)this.control.windowWidthImageRegion);
        this.control.windowWidthSlices = (int)Prefs.get((String)"VolumeViewer.windowWidthSlices", (double)this.control.windowWidthSlices);
        this.control.windowHeight = (int)Prefs.get((String)"VolumeViewer.windowHeight", (double)this.control.windowHeight);
        this.control.useLight = Prefs.get((String)"VolumeViewer.useLight", (boolean)this.control.useLight);
        this.control.ambientValue = (float)Prefs.get((String)"VolumeViewer.ambientValue", (double)this.control.ambientValue);
        this.control.diffuseValue = (float)Prefs.get((String)"VolumeViewer.diffuseValue", (double)this.control.diffuseValue);
        this.control.specularValue = (float)Prefs.get((String)"VolumeViewer.specularValue", (double)this.control.specularValue);
        this.control.shineValue = (float)Prefs.get((String)"VolumeViewer.shineValue", (double)this.control.shineValue);
        this.control.objectLightValue = (float)Prefs.get((String)"VolumeViewer.objectLightValue", (double)this.control.objectLightValue);
        this.control.lightRed = (int)Prefs.get((String)"VolumeViewer.lightRed", (double)this.control.lightRed);
        this.control.lightGreen = (int)Prefs.get((String)"VolumeViewer.lightGreen", (double)this.control.lightGreen);
        this.control.lightBlue = (int)Prefs.get((String)"VolumeViewer.lightBlue", (double)this.control.lightBlue);
    }

    private void writePrefs() {
        Prefs.set((String)"VolumeViewer.xloc", (int)this.frame.getLocation().x);
        Prefs.set((String)"VolumeViewer.yloc", (int)this.frame.getLocation().y);
        Prefs.set((String)"VolumeViewer.showTF", (boolean)true);
        Prefs.set((String)"VolumeViewer.renderMode", (int)this.control.renderMode);
        Prefs.set((String)"VolumeViewer.interpolationMode", (int)this.control.interpolationMode);
        Prefs.set((String)"VolumeViewer.backgroundColor", (int)this.control.backgroundColor.getRGB());
        Prefs.set((String)"VolumeViewer.lutNr", (int)this.control.lutNr);
        Prefs.set((String)"VolumeViewer.sampling", (double)this.control.sampling);
        Prefs.set((String)"VolumeViewer.dist", (double)this.control.dist);
        Prefs.set((String)"VolumeViewer.showAxes", (boolean)this.control.showAxes);
        Prefs.set((String)"VolumeViewer.showSlices", (boolean)this.control.showSlices);
        Prefs.set((String)"VolumeViewer.showClipLines", (boolean)this.control.showClipLines);
        Prefs.set((String)"VolumeViewer.scale", (double)this.control.scale);
        Prefs.set((String)"VolumeViewer.degreeX", (double)this.control.degreeX);
        Prefs.set((String)"VolumeViewer.degreeY", (double)this.control.degreeY);
        Prefs.set((String)"VolumeViewer.degreeZ", (double)this.control.degreeZ);
        Prefs.set((String)"VolumeViewer.alphaMode", (int)this.control.alphaMode);
        Prefs.set((String)"VolumeViewer.windowWidthImageRegion", (int)this.control.windowWidthImageRegion);
        Prefs.set((String)"VolumeViewer.windowWidthSlices", (int)this.control.windowWidthSlices);
        Prefs.set((String)"VolumeViewer.windowHeight", (int)this.control.windowHeight);
        Prefs.set((String)"VolumeViewer.useLight", (boolean)this.control.useLight);
        Prefs.set((String)"VolumeViewer.ambientValue", (double)this.control.ambientValue);
        Prefs.set((String)"VolumeViewer.diffuseValue", (double)this.control.diffuseValue);
        Prefs.set((String)"VolumeViewer.specularValue", (double)this.control.specularValue);
        Prefs.set((String)"VolumeViewer.shineValue", (double)this.control.shineValue);
        Prefs.set((String)"VolumeViewer.objectLightValue", (double)this.control.objectLightValue);
        Prefs.set((String)"VolumeViewer.lightRed", (int)this.control.lightRed);
        Prefs.set((String)"VolumeViewer.lightGreen", (int)this.control.lightGreen);
        Prefs.set((String)"VolumeViewer.lightBlue", (int)this.control.lightBlue);
    }

    void setRotation(float degreeX, float degreeY, float degreeZ) {
        this.tr.setView(Math.toRadians(degreeX), Math.toRadians(degreeY), Math.toRadians(degreeZ));
        this.updateGuiSpinners();
    }

    void initializeTransformation() {
        this.tr.initializeTransformation();
        this.cube.transformCorners(this.tr);
        this.updateGuiSpinners();
    }

    void setScale() {
        this.tr.setScale(this.control.scale);
    }

    void changeRotation(int xStart, int yStart, int xAct, int yAct, int width) {
        this.tr.setMouseMovement(xStart, yStart, xAct, yAct, width);
        this.updateGuiSpinners();
    }

    void changeRotationLight(int xStart, int yStart, int xAct, int yAct, int width) {
        this.trLight.setMouseMovement(xStart, yStart, xAct, yAct, width);
    }

    void setZAspect() {
        this.gui.updateDistSlider();
        this.tr.setZAspect(this.control.zAspect);
        if (this.control.zAspect == 0.0f) {
            this.control.zAspect = 0.01f;
        }
        this.cube.setTextPositions(this.control.scale, this.control.zAspect);
    }

    void changeTranslation(int dx, int dy) {
        this.tr.setMouseMovementOffset(dx, dy);
        this.updateGuiSpinners();
    }

    void updateGuiSpinners() {
        this.control.degreeX = this.tr.getDegreeX();
        this.control.degreeY = this.tr.getDegreeY();
        this.control.degreeZ = this.tr.getDegreeZ();
        if (!this.control.spinnersAreChanging && this.gui != null) {
            this.gui.setSpinners();
        }
        this.cube.transformCorners(this.tr);
    }

    private boolean getMacroParameters(String st) {
        String[] paramStrings = new String[]{"display_mode=", "interpolation=", "bg_r=", "bg_g=", "bg_b=", "lut=", "z-aspect=", "sampling=", "dist=", "axes=", "slices=", "clipping=", "scale=", "angle_x=", "angle_y=", "angle_z=", "alphamode=", "width=", "height=", "useLight=", "ambientValue=", "diffuseValue=", "specularValue=", "shineValue=", "objectLightValue=", "lightRed=", "lightGreen=", "lightBlue=", "snapshot="};
        float[] paramVals = new float[]{this.control.renderMode, this.control.interpolationMode, this.control.backgroundColor.getRed(), this.control.backgroundColor.getGreen(), this.control.backgroundColor.getBlue(), this.control.lutNr, this.control.zAspect, this.control.sampling, this.control.dist, this.control.showAxes ? 1.0f : 0.0f, this.control.showSlices ? 1.0f : 0.0f, this.control.showClipLines ? 1.0f : 0.0f, this.control.scale, this.control.degreeX, this.control.degreeY, this.control.degreeZ, this.control.alphaMode, this.control.windowWidthImageRegion, this.control.windowHeight, this.control.useLight ? 1.0f : 0.0f, this.control.ambientValue, this.control.diffuseValue, this.control.specularValue, this.control.shineValue, this.control.objectLightValue, this.control.lightRed, this.control.lightGreen, this.control.lightBlue, this.control.snapshot ? 1.0f : 0.0f};
        boolean distWasSet = false;
        try {
            if (st != null) {
                StringTokenizer ex1 = new StringTokenizer(st);
                while (ex1.hasMoreTokens()) {
                    String str = ex1.nextToken();
                    boolean valid = false;
                    for (int j = 0; j < paramStrings.length; ++j) {
                        String pattern = paramStrings[j];
                        if (str.lastIndexOf(pattern) <= -1) continue;
                        int pos = str.lastIndexOf(pattern) + pattern.length();
                        paramVals[j] = Float.parseFloat(str.substring(pos));
                        valid = true;
                        if (j != 8) continue;
                        distWasSet = true;
                    }
                    if (valid) continue;
                    IJ.error((String)("Unkown macro parameter for the VolumeViewer plugin:\n \n" + str + " \n \nValid parameters are: defaultValue type (range) \ndisplay_mode=0 \tint (0 .. 4)\ninterpolation=1\tint (0 .. 3)\nbg_r=0  bg_g=52  bg_b=101\tint int (0 .. 255)\nlut=0\t\t\t\tint (0 .. 4)\nz-aspect=1 \tfloat  (!= 0)\nsampling=1\t\tfloat ( > 0) \ndist=0\t\t\tfloat\naxes=1\t\t\tint (0,1)\nslices=0\t\tint (0,1)\nclipping=0\t\tint (0,1)\nscale=1\t\tfloat (> 0.25, < 128) \nangle_x=115  angle_y=41  angle_z=17 \tfloat (0 .. 360)\nalphamode=0\tint (0 .. 3)\nwidth=500\t\tint (>= 500)\nheight=660\t\tint (>= 630)\nuseLight=0\t\tint (0,1)\nambientValue=0.5\tfloat (0 .. 1)\ndiffuseValue=0.5\tfloat (0 .. 1)\nspecularValue=0.5\tfloat (0 .. 1)\nshineValue=17\t\tfloat (0 .. 200)\nobjectLightValue=0.5\tfloat (0 .. 2)\nlightRed=255  lightGreen=128  lightBlue=0\tint (0 .. 255)\nsnapshot=0\t\tint (0,1)"));
                    return false;
                }
            }
        }
        catch (NumberFormatException e1) {
            IJ.error((String)"Error in macro parameter list");
            return false;
        }
        this.control = new Control(this);
        this.control.distWasSet = distWasSet;
        this.control.renderMode = (int)Math.min(4.0f, Math.max(0.0f, paramVals[0]));
        this.control.interpolationMode = (int)Math.min(3.0f, Math.max(0.0f, paramVals[1]));
        this.control.backgroundColor = new Color((int)paramVals[2], (int)paramVals[3], (int)paramVals[4]);
        this.control.lutNr = (int)Math.min(4.0f, Math.max(0.0f, paramVals[5]));
        this.control.zAspect = paramVals[6];
        this.control.sampling = paramVals[7] > 0.0f ? paramVals[7] : 1.0f;
        this.control.dist = paramVals[8];
        this.control.showAxes = (int)paramVals[9] != 0;
        this.control.showSlices = (int)paramVals[10] != 0;
        this.control.showClipLines = (int)paramVals[11] != 0;
        this.control.scale = Math.max(0.25f, Math.min(128.0f, paramVals[12]));
        this.control.degreeX = (int)paramVals[13];
        this.control.degreeY = (int)paramVals[14];
        this.control.degreeZ = (int)paramVals[15];
        this.control.alphaMode = (int)paramVals[16];
        this.control.windowWidthImageRegion = Math.max(this.control.windowWidthImageRegion, (int)paramVals[17]);
        this.control.windowHeight = Math.max(this.control.windowHeight, (int)paramVals[18]);
        this.control.useLight = (int)paramVals[19] != 0;
        this.control.ambientValue = Math.max(0.0f, Math.min(1.0f, paramVals[20]));
        this.control.diffuseValue = Math.max(0.0f, Math.min(1.0f, paramVals[21]));
        this.control.specularValue = Math.max(0.0f, Math.min(1.0f, paramVals[22]));
        this.control.shineValue = Math.max(0.0f, Math.min(200.0f, paramVals[23]));
        this.control.objectLightValue = Math.max(0.0f, Math.min(200.0f, paramVals[24]));
        this.control.lightRed = (int)Math.max(0.0f, Math.min(255.0f, paramVals[25]));
        this.control.lightGreen = (int)Math.max(0.0f, Math.min(255.0f, paramVals[26]));
        this.control.lightBlue = (int)Math.max(0.0f, Math.min(255.0f, paramVals[27]));
        this.control.snapshot = (int)paramVals[28] != 0;
        this.control.scaledDist = this.control.dist * this.control.scale;
        return true;
    }

    public float[] trScreen2Vol(float xS, float yS, float zS) {
        return this.tr.trScreen2Vol(xS, yS, zS);
    }

    public float[] trScreen2Volume(float[] xyzS) {
        return this.tr.trScreen2Vol(xyzS[0], xyzS[1], xyzS[2]);
    }

    public float[] trVolume2Screen(float[] xyzV) {
        return this.tr.trVol2Screen(xyzV[0], xyzV[1], xyzV[2]);
    }

    public float[] trVolume2Screen(float xV, float yV, float zV) {
        return this.tr.trVol2Screen(xV, yV, zV);
    }

    public float[] trLightScreen2Vol(float xS, float yS, float zS) {
        return this.trLight.trScreen2Vol(xS, yS, zS);
    }

    public float[] trLightVolume2Screen(float xV, float yV, float zV) {
        return this.trLight.trVol2Screen(xV, yV, zV);
    }
}

