/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.scijava.table.Table;
import org.scijava.table.TableDisplay;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;
import org.scijava.ui.viewer.table.TableDisplayPanel;

public class SwingTableDisplayPanel
extends JScrollPane
implements TableDisplayPanel {
    private final DisplayWindow window;
    private final TableDisplay display;
    private final JTable table;
    private final NullTableModel nullModel;

    public SwingTableDisplayPanel(TableDisplay display, DisplayWindow window) {
        this.display = display;
        this.window = window;
        this.nullModel = new NullTableModel();
        this.table = this.makeTable();
        this.table.setAutoCreateRowSorter(true);
        this.table.setRowSelectionAllowed(true);
        new TablePopupMenu().install();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (((SwingTableDisplayPanel)SwingTableDisplayPanel.this).table.getPreferredSize().width < SwingTableDisplayPanel.this.getWidth()) {
                    SwingTableDisplayPanel.this.table.setAutoResizeMode(4);
                } else {
                    SwingTableDisplayPanel.this.table.setAutoResizeMode(0);
                }
            }
        });
        this.setViewportView(this.table);
        window.setContent((DisplayPanel)this);
    }

    public TableDisplay getDisplay() {
        return this.display;
    }

    public DisplayWindow getWindow() {
        return this.window;
    }

    public void redoLayout() {
    }

    public void setLabel(String s) {
    }

    public void redraw() {
        javax.swing.table.TableModel model = this.table.getModel();
        this.table.setModel(this.nullModel);
        this.table.setModel(model);
    }

    private JTable makeTable() {
        return new JTable(new TableModel(this.getTable()));
    }

    private Table<?, ?> getTable() {
        return this.display.size() == 0 ? null : (Table)this.display.get(0);
    }

    private class ActionMapAction
    extends AbstractAction {
        private final Action originalAction;
        private final JComponent component;
        private final String actionCommand = "";

        ActionMapAction(String name, JComponent component, String actionKey) {
            super(name);
            this.actionCommand = "";
            this.originalAction = component.getActionMap().get(actionKey);
            if (this.originalAction == null) {
                throw new IllegalArgumentException("No Action for action key: " + actionKey);
            }
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(this.component, 1001, "", e.getWhen(), e.getModifiers());
            this.originalAction.actionPerformed(e);
        }
    }

    class TablePopupMenu
    extends JPopupMenu {
        public TablePopupMenu() {
            JMenuItem mi = new JMenuItem(new ActionMapAction("Copy", SwingTableDisplayPanel.this.table, "copy"));
            int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            mi.setAccelerator(KeyStroke.getKeyStroke(67, MASK));
            this.add(mi);
            mi = new JMenuItem(new ActionMapAction("Select All", SwingTableDisplayPanel.this.table, "selectAll"));
            mi.setAccelerator(KeyStroke.getKeyStroke(65, MASK));
            this.add(mi);
            this.addSeparator();
            mi = new JMenuItem("Delete Selected Row(s)");
            mi.addActionListener(e -> {
                int[] selectedRows = SwingTableDisplayPanel.this.table.getSelectedRows();
                if (selectedRows.length > 0) {
                    ((TableModel)SwingTableDisplayPanel.this.table.getModel()).removeRows(selectedRows);
                }
            });
            this.add(mi);
            mi = new JMenuItem("Resize Column Widths");
            mi.addActionListener(e -> this.resizeColumns());
            this.add(mi);
        }

        private void resizeColumns() {
            SwingTableDisplayPanel.this.table.setAutoResizeMode(0);
            SwingTableDisplayPanel.this.table.getTableHeader();
            for (int column = 0; column < SwingTableDisplayPanel.this.table.getColumnCount(); ++column) {
                TableColumn tableColumn = SwingTableDisplayPanel.this.table.getColumnModel().getColumn(column);
                int preferredWidth = Math.max(tableColumn.getMinWidth(), this.getColumnHeaderWidth(tableColumn, column));
                int maxWidth = tableColumn.getMaxWidth();
                for (int row = 0; row < SwingTableDisplayPanel.this.table.getRowCount(); ++row) {
                    TableCellRenderer cellRenderer = SwingTableDisplayPanel.this.table.getCellRenderer(row, column);
                    Component c = SwingTableDisplayPanel.this.table.prepareRenderer(cellRenderer, row, column);
                    int width = c.getPreferredSize().width + ((SwingTableDisplayPanel)SwingTableDisplayPanel.this).table.getIntercellSpacing().width;
                    if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                    preferredWidth = maxWidth;
                    break;
                }
                tableColumn.setPreferredWidth(preferredWidth);
            }
        }

        private int getColumnHeaderWidth(TableColumn tableColumn, int column) {
            Object value = tableColumn.getHeaderValue();
            TableCellRenderer renderer = tableColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = SwingTableDisplayPanel.this.table.getTableHeader().getDefaultRenderer();
            }
            Component c = renderer.getTableCellRendererComponent(SwingTableDisplayPanel.this.table, value, false, false, -1, column);
            return c.getPreferredSize().width;
        }

        void install() {
            SwingTableDisplayPanel.this.table.setComponentPopupMenu(this);
            SwingTableDisplayPanel.this.setComponentPopupMenu(this);
        }
    }

    public static class TableModel
    extends AbstractTableModel {
        private final Table<?, ?> tab;

        public TableModel(Table<?, ?> table) {
            this.tab = table;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            return this.tab.getColumnHeader(col - 1);
        }

        @Override
        public int getRowCount() {
            return this.tab.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tab.getColumnCount() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return null;
            }
            if (col == 0) {
                String header = this.tab.getRowHeader(row);
                if (header != null) {
                    return header;
                }
                return "" + (row + 1);
            }
            return this.tab.get(col - 1, row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return;
            }
            if (col == 0) {
                this.tab.setRowHeader(row, value == null ? null : value.toString());
                return;
            }
            this.set(this.tab, col - 1, row, value);
            this.fireTableCellUpdated(row, col);
        }

        public void removeRows(int[] indices) {
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.tab.removeRow(indices[i]);
                this.fireTableRowsDeleted(indices[i], indices[i]);
            }
        }

        private <T> void set(Table<?, T> table, int col, int row, Object value) {
            Object typedValue = value;
            table.set(col, row, typedValue);
        }
    }

    public static class NullTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }
}

