/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import com.jcraft.jzlib.ZInputStream;
import ij.IJ;
import ij.io.FileInfo;
import ij.io.FileOpener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.GZIPInputStream;

class FlexibleFileOpener
extends FileOpener {
    public static final int UNCOMPRESSED = 0;
    public static final int GZIP = 1;
    public static final int ZLIB = 2;
    int gunzipMode = 0;
    long preOffset = 0L;

    public FlexibleFileOpener(FileInfo fi) {
        this(fi, fi.fileName.toLowerCase().endsWith(".gz") ? 1 : 0, 0L);
    }

    public FlexibleFileOpener(FileInfo fi, int gunzipMode) {
        this(fi, gunzipMode, 0L);
    }

    public FlexibleFileOpener(FileInfo fi, int gunzipMode, long preOffset) {
        super(fi);
        this.gunzipMode = gunzipMode;
        this.preOffset = preOffset;
    }

    public InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        InputStream is = super.createInputStream(fi);
        if (this.preOffset != 0L) {
            is.skip(this.preOffset);
        }
        if (this.gunzipMode == 0) {
            return is;
        }
        if (this.gunzipMode == 1) {
            boolean lessThan138s;
            boolean bl = lessThan138s = IJ.getVersion().compareTo("1.38s") < 0;
            if (lessThan138s || !fi.fileName.toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(is, 50000);
            }
            return is;
        }
        if (this.gunzipMode == 2) {
            return new ZInputStream(is);
        }
        throw new IOException("Incorrect GZIP mode: " + this.gunzipMode);
    }
}

