/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifier;
import VolumeJ.VJCutout;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJMatrix;
import VolumeJ.VJRenderer;
import VolumeJ.VJShade;
import VolumeJ.VJShader;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJVoxelLoc;

public class VJViewspaceRender
extends VJRenderer {
    protected VJAlphaColor[] viewspacePixel;
    protected VJVoxelLoc[] viewspace;
    protected int pixelSize = 2;
    protected static float[] vsv;
    protected static float[] vsvstep;
    protected static float[] osv;

    public VJViewspaceRender(VJInterpolator interpolator, VJShader shader, VJClassifier classifier) throws Exception {
        super(interpolator, shader, classifier);
    }

    @Override
    public synchronized void run() {
        this.running = true;
        this.viewspace = new VJVoxelLoc[this.height * this.width];
        this.viewspacePixel = new VJAlphaColor[this.height * this.width];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                this.viewspacePixel[j * this.width + i] = this.classifier.does() == 4 ? new VJAlphaColor() : new VJAlphaColor(0.0, 0);
                int index = j * this.width + i;
                float[] vsv = VJMatrix.newVector(i + this.ioffset, j + this.joffset, this.koffset);
                float[] osv = this.mi.mul(vsv);
                this.viewspace[index] = new VJVoxelLoc();
                this.viewspace[index].x = osv[0];
                this.viewspace[index].y = osv[1];
                this.viewspace[index].z = osv[2];
            }
        }
        float[] dummy = new float[4];
        this.advanceAllRays(dummy);
        vsvstep = this.mi.getStepperColumn();
        if (this.cutout instanceof VJCutout) {
            this.cutout.setup(this.m, this.mi);
        }
        VJValue value = new VJValue();
        for (int k = 0; k < this.depth && this.running; ++k) {
            VJUserInterface.status("Render " + this.message + "(" + 100 * k / this.depth + "%)...");
            VJUserInterface.progress((float)k / (float)this.depth);
            for (int index = 0; index < this.height * this.width; ++index) {
                VJGradient g;
                VJAlphaColor color;
                if (!this.interpolator.isValid(this.viewspace[index], this.v) || !this.viewspacePixel[index].notOpaque()) continue;
                this.interpolator.value(value, this.v, this.viewspace[index]);
                if (!this.interpolator.isValidGradient(this.viewspace[index], this.v) || this.classifier.doesIndex() && !this.classifier.visible(value) || !(color = this.classifier.alphacolor(value, g = this.interpolator.gradient(this.v, this.viewspace[index]))).visible()) continue;
                g.normalize();
                VJShade shade = this.shader.shade(g);
                this.blendCompose(index, value, g, color, shade);
                if (!this.viewspacePixel[index].almostOpaque()) continue;
                this.viewspacePixel[index].setOpaque();
            }
            this.advanceAllRays(vsvstep);
            VJViewspaceRender.yield();
        }
        this.makePixels();
        this.running = false;
    }

    protected void blendCompose(int index, VJValue value, VJGradient g, VJAlphaColor color, VJShade shade) {
        this.viewspacePixel[index].blendComposeScalar(color, shade);
    }

    private Object makePixels() {
        this.newViewportBuffer();
        if (this.pixels instanceof int[]) {
            for (int index = 0; index < this.height * this.width; ++index) {
                int rvalue = this.viewspacePixel[index].getRed();
                int gvalue = this.viewspacePixel[index].getGreen();
                int bvalue = this.viewspacePixel[index].getBlue();
                if (rvalue > 255 || gvalue > 255 || bvalue > 255) {
                    VJUserInterface.write("Had composite overflow");
                }
                ((int[])this.pixels)[index] = rvalue << 16 | gvalue << 8 | bvalue;
            }
        } else {
            for (int index = 0; index < this.height * this.width; ++index) {
                int value = this.viewspacePixel[index].getValue();
                if (value > 255) {
                    VJUserInterface.write("Composite overflow");
                }
                ((byte[])this.pixels)[index] = (byte)value;
            }
        }
        return this.pixels;
    }

    private void advanceAllRays(float[] vsvstep) {
        for (int index = 0; index < this.height * this.width; ++index) {
            this.viewspace[index].move(vsvstep);
        }
    }

    public static String desc() {
        return "viewspace";
    }
}

