/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.fast_gauss;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolution;
import net.imglib2.algorithm.convolution.MultiDimensionConvolution;
import net.imglib2.algorithm.convolution.fast_gauss.FastGaussConvolverRealType;
import net.imglib2.type.numeric.RealType;

public class FastGauss {
    public static Convolution<RealType<?>> convolution(double[] sigma) {
        List steps = IntStream.range(0, sigma.length).mapToObj(i -> FastGauss.convolution1d(sigma[i], i)).collect(Collectors.toList());
        return Convolution.concat(steps);
    }

    public static Convolution<RealType<?>> convolution(double sigma) {
        return new MultiDimensionConvolution(k -> FastGauss.convolution(FastGauss.nCopies(k, sigma)));
    }

    public static Convolution<RealType<?>> convolution1d(double sigma, int direction) {
        return new LineConvolution(new FastGaussConvolverRealType(sigma), direction);
    }

    public static void convolve(double[] sigmas, RandomAccessible<? extends RealType<?>> input, RandomAccessibleInterval<? extends RealType<?>> output) {
        FastGauss.convolution(sigmas).process(input, output);
    }

    public static void convolve(double sigma, RandomAccessible<? extends RealType<?>> input, RandomAccessibleInterval<? extends RealType<?>> output) {
        FastGauss.convolution(sigma).process(input, output);
    }

    private static double[] nCopies(int n, double sigma) {
        double[] sigmas = new double[n];
        Arrays.fill(sigmas, sigma);
        return sigmas;
    }
}

